#ifndef CORE_HH
#define CORE_HH

#include <istream>
#include <memory>
#include <string>
#include <vector>

class Core {
public:
    Core();
    Core(const Core&) = default;
    virtual ~Core() = default;
    Core& operator=(const Core&) = default;
    Core(std::istream& is);
    std::string name() const;
    virtual std::istream& read(std::istream&);
    virtual double grade() const;

    friend class Student_info;

protected:
    virtual std::unique_ptr<Core> clone() {
        return std::make_unique<Core>(*this);
    }

    std::istream& read_common(std::istream&);

    std::string _name;
    double midterm, final;
    std::vector<double> homeworks;
};

inline
bool compare(const Core& c1, const Core& c2) {
    return c1.name() < c2.name();
}

#endif
