#ifndef GRAD_HH
#define GRAD_HH

#include "core.hh"

class Grad: public Core {
public:
    Grad();
    Grad(const Grad&) = default;
    Grad(std::istream&);
    Grad& operator=(const Grad&) = default;
    virtual std::istream& read(std::istream&);
    virtual double grade() const;

private:
    virtual std::unique_ptr<Core> clone() {
        return std::make_unique<Grad>(*this);
    }

    double thesis;
};

#endif
