#include <algorithm>
#include <iostream>
#include <vector>

#include "grad.hh"

using namespace std;

int main() {
    vector<Grad> students; // Different type in vector
    Grad record; // Different type into which to read
    string::size_type max_len = 0;
    // Read and store the student records
    while (record.read(cin)) { // Grad::read()
        max_len = max(max_len, record.name().size());
        students.push_back(record);
    }
    // Alphabetize the student records
    sort(students.begin(), students.end(), compare);
    // Write the names and grades
    for (auto& s : students) {
        cout << s.name()
             << string(max_len + 1 - s.name().size(), ' ');
        try {
            cout << s.grade() << endl; // Grad::grade
        } catch (domain_error e) {
            cerr << e.what() << endl;
        }
    }
    return 0;
}
