#include "median.hh"

#include <algorithm>
#include <stdexcept>

using namespace std;

double median(vector<double> vec) {
    if (vec.empty())
        throw domain_error("median of an empty vector");

    sort(vec.begin(), vec.end());

    auto mid = vec.size() / 2;

    return (vec.size() % 2 == 0) ? (vec[mid] + vec[mid - 1]) / 2
                                 : vec[mid];
}
