#include "student_info.hh"

#include "grad.hh"

using std::istream;

istream& Student_info::read(istream& is) {
    char ch;
    is >> ch; // Get record type

    // Assignment to `cp` will free if needed
    if (ch == 'U')
        cp = std::make_unique<Core>(is);
    else
        cp = std::make_unique<Grad>(is);

    return is;
}

Student_info::Student_info(const Student_info& s) {
    if (s.cp)
        cp = s.cp->clone();
}

Student_info& Student_info::operator=(const Student_info& s) {
    if (&s != this) {
        if (s.cp)
            cp = s.cp->clone();
        else
            cp = nullptr;
    }

    return *this;
}
