#ifndef STUDENT_INFO_HH
#define STUDENT_INFO_HH

#include <istream>
#include <memory>
#include <stdexcept>

#include "core.hh"

class Student_info {
public:
    // Constructors and copy control
    Student_info() { }
    Student_info(std::istream& is) { read(is); }
    Student_info(const Student_info&);
    Student_info& operator=(const Student_info&);
    // Operations
    std::istream& read(std::istream&);
    std::string name() const {
        if (cp) return cp->name();
        else throw std::runtime_error("uninitialized Student");
    }
    double grade() const {
        if (cp) return cp->grade();
        else throw std::runtime_error("uninitialized Student");
    }
    static bool compare(const Student_info& s1, const Student_info& s2) {
        return s1.name() < s2.name();
    }
private:
    std::unique_ptr<Core> cp;
};

#endif
