#include "grad.hh"

#include <cassert>
#include <sstream>

using namespace std;

static bool compare_grades(const Core& c1, const Core& c2);

bool compare_grades(const Core& c1, const Core& c2) {
    return c1.grade() < c2.grade();
}

int main() {
    string input =
        "Grad1 15 15 12 14 15 16 18\n"
        "Grad2 12 12 9 10 12 13 14\n"
        "Core1 15 15 15 14 15 16\n"
        "Core2 18 18 18 17 18 19\n";
    stringstream in(input);

    Grad g1(in);
    Grad g2(in);

    Core c1(in);
    Core c2(in);

    compare(g1, g2);
    compare(c1, c2);
    compare(c1, g1);

    assert(compare(g1, g2));
    assert(compare(c1, c2));
    assert(compare(c1, g1));

    assert(compare_grades(c1, c2));

    try {
        Core c;
        Grad g;
        Core* p = &c;
        Core& r = g;

        c.grade();  // Static binding to Core::grade()
        g.grade();  // Static binding to Grad::grade()
        p->grade(); // Dynamic binding to type object p points to
        r.grade();  // Dynamic binding to type object r refers to
    } catch (std::domain_error&) {
        // Will throw domain_error("student has done no homework")
    }

    return 0;
}
