/*
 * Decompiled with CFR 0.152.
 */
package buffer;

import buffer.BufferContent;
import buffer.BufferStoreContent;
import dk.brics.automaton.Automaton;
import dk.brics.automaton.BasicOperations;
import dk.brics.automaton.State;
import dk.brics.automaton.Transition;
import exceptions.BufferSfenceException;
import exceptions.SuffixException;
import java.io.File;
import java.io.FileWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import modelchecker.Memory;
import options.Constants;
import options.Options;

public class Buffer
implements Cloneable,
Comparable<Object> {
    private volatile Automaton automaton;

    public Buffer() {
        this.automaton = Automaton.makeEmptyString();
    }

    public Buffer(BufferStoreContent bufferStoreContent) {
        char c = BufferContent.getChar(bufferStoreContent);
        this.automaton = Automaton.makeChar(c);
    }

    public boolean resetBuffer() {
        boolean bl = !this.isEmptyString();
        this.automaton = Automaton.makeEmptyString();
        return bl;
    }

    public void setAutomaton(Automaton automaton) {
        this.automaton = automaton;
    }

    public Automaton getAutomaton() {
        return this.automaton;
    }

    public int getNbAcceptStates() {
        return this.automaton.getAcceptStates().size();
    }

    public String toDot() {
        return this.automaton.toDot();
    }

    public boolean isEmptyString() {
        return this.automaton.isEmptyString();
    }

    public boolean isEmpty() {
        return this.automaton.isEmpty();
    }

    public void makeEmpty() {
        this.automaton = Automaton.makeEmpty();
    }

    public boolean acceptsEmptyString() {
        Automaton automaton = Automaton.makeEmptyString();
        return BasicOperations.subsetOf(automaton, this.automaton);
    }

    public void minusEmptyString() {
        Automaton automaton = Automaton.makeEmptyString();
        this.automaton = this.automaton.intersection(automaton);
    }

    public void concatAutomaton(Automaton automaton) {
        this.automaton = this.automaton.concatenate(automaton);
    }

    public boolean isSubsetOf(Buffer buffer) {
        return BasicOperations.subsetOf(this.automaton, buffer.automaton);
    }

    public boolean equals(Automaton automaton) {
        return this.automaton.equals(automaton);
    }

    private void concatenateWord(BufferStoreContent bufferStoreContent) {
        char c = BufferContent.getChar(bufferStoreContent);
        this.automaton = this.automaton.concatenate(Automaton.makeChar(c));
    }

    public int hashCode() {
        return this.automaton.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Buffer)) {
            return false;
        }
        Buffer buffer = (Buffer)object;
        return this.automaton.equals(buffer.automaton);
    }

    @Override
    public int compareTo(Object object) {
        if (!(object instanceof Buffer)) {
            throw new InternalError("Should never pass here: try to compare a non Buffer with a Buffer");
        }
        Buffer buffer = (Buffer)object;
        if (this.equals(buffer)) {
            return 0;
        }
        if (this.isSubsetOf(buffer)) {
            return -1;
        }
        if (buffer.isSubsetOf(this)) {
            return 1;
        }
        throw new InternalError("Impossible code line");
    }

    public String toString() {
        return this.automaton.toString();
    }

    public Object clone() {
        Buffer buffer;
        try {
            buffer = (Buffer)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("at least one subclass of buffer does implement cloneable");
        }
        buffer.automaton = this.automaton.clone();
        return buffer;
    }

    public boolean isProperPrefix(Buffer buffer) {
        Automaton automaton = buffer.automaton.clone();
        Set<State> set = automaton.getAcceptStates();
        Set<State> set2 = automaton.getStates();
        Set<State> set3 = this.minus(set2, set);
        for (State state : set) {
            state.setAccept(false);
        }
        for (State state : set3) {
            state.setAccept(true);
        }
        return this.automaton.subsetOf(automaton);
    }

    public boolean isPrefix(Buffer buffer) {
        Automaton automaton = buffer.automaton.clone();
        Set<State> set = automaton.getStates();
        for (State state : set) {
            state.setAccept(true);
        }
        return this.automaton.subsetOf(automaton);
    }

    private Set<State> minus(Set<State> set, Set<State> set2) {
        for (State state : set2) {
            set.remove(state);
        }
        return set;
    }

    private synchronized void checkCorrectSuffix(Automaton automaton, Automaton automaton2, Automaton automaton3) throws SuffixException {
        if (!automaton.equals(automaton2.concatenate(automaton3))) {
            throw new SuffixException("Error in suffix computation");
        }
    }

    public synchronized void makeStrongCycleWithSuffix(Buffer buffer, Buffer buffer2) throws SuffixException {
        this.checkCorrectSuffix(this.automaton, buffer.automaton, buffer2.automaton);
        Automaton automaton = buffer2.automaton.repeat();
        automaton.minimize();
        Automaton automaton2 = buffer.automaton.clone();
        for (State state : automaton2.getAcceptStates()) {
            state.setAccept(true);
            automaton.getInitialState().addEpsilonT(state);
            state.addEpsilonT(automaton.getInitialState());
        }
        automaton2.setDeterministic(false);
        automaton2.minimize();
        this.setAutomaton(automaton2);
    }

    public synchronized void makeWeakCycleWithSuffix(Buffer buffer, Buffer buffer2, int n) throws SuffixException {
        this.checkCorrectSuffix(this.automaton, buffer.automaton, buffer2.automaton);
        Automaton automaton = buffer2.automaton.repeat(n);
        automaton.minimize();
        Automaton automaton2 = buffer.automaton.clone();
        this.setAutomaton(automaton2.concatenate(automaton));
        this.automaton.setDeterministic(false);
        this.automaton.minimize();
    }

    public synchronized boolean makeStrongCycle(Buffer buffer) {
        Automaton automaton = this.automaton;
        Automaton automaton2 = buffer.automaton.clone();
        Automaton automaton3 = Automaton.newSuffixAutomaton(automaton2, automaton);
        State state = new State();
        state.setAccept(true);
        state.addEpsilonT(automaton3.getInitialState());
        for (State state2 : automaton3.getAcceptStates()) {
            state2.addEpsilonT(state);
        }
        for (State state2 : automaton2.getAcceptStates()) {
            state2.setAccept(true);
            state.addEpsilonT(state2);
            state2.addEpsilonT(state);
        }
        automaton = automaton2;
        automaton.setDeterministic(false);
        automaton.minimize();
        this.automaton = automaton;
        return true;
    }

    public synchronized boolean makeWeakCycle(Buffer buffer) {
        Automaton automaton = this.automaton;
        Automaton automaton2 = buffer.automaton;
        Automaton automaton3 = Automaton.newSuffixAutomaton(automaton2, automaton);
        State state = new State();
        state.setAccept(true);
        state.addEpsilonT(automaton3.getInitialState());
        for (State state2 : automaton3.getAcceptStates()) {
            state2.addEpsilonT(state);
        }
        automaton3.setInitialState(state);
        automaton = automaton2.clone().concatenate(automaton3);
        automaton.setDeterministic(false);
        automaton.minimize();
        this.automaton = automaton;
        return true;
    }

    public void repeat(int n) {
        Automaton automaton = this.automaton;
        this.automaton = automaton.repeat(n);
    }

    public void removeEmptyWord() {
        if (this.acceptsEmptyString() && !this.isEmptyString()) {
            this.automaton = this.automaton.minus(Automaton.makeEmptyString());
        }
        this.automaton.minimize();
    }

    public synchronized void addStore(BufferStoreContent bufferStoreContent) {
        this.concatenateWord(bufferStoreContent);
        this.automaton.setDeterministic(false);
        this.automaton.minimize();
    }

    public synchronized void addStoreBefore(BufferStoreContent bufferStoreContent) {
        char c = BufferContent.getChar(bufferStoreContent);
        this.automaton = Automaton.makeChar(c).concatenate(this.automaton);
    }

    public BufferStoreContent commitStore(char c) {
        State state = this.automaton.getInitialState().step(c);
        if (state == null) {
            return null;
        }
        this.automaton.setInitialState(state);
        this.automaton.removeDeadTransitions();
        this.automaton.minimize();
        return BufferContent.getStoreContent(c);
    }

    public boolean checkPossibleCommit(char c) {
        State state = this.automaton.getInitialState().step(c);
        return state != null;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized Vector<BufferStoreContent> prepareLoadBuffer(int n) {
        void var7_10;
        Object object2;
        Automaton automaton = this.automaton.returnAutomaton().prefixAutomaton();
        HashSet<Character> hashSet = BufferContent.getAlphabet();
        HashSet<Character> hashSet2 = BufferContent.getVarAlphabet(n);
        HashSet<Character> hashSet3 = new HashSet<Character>();
        for (Character object22 : hashSet) {
            if (hashSet2.contains(object22)) continue;
            hashSet3.add(object22);
        }
        Object object3 = new String();
        for (Object object2 : hashSet3) {
            object3 = (String)object3 + ((Character)object2).charValue();
        }
        String string = new String();
        for (Character c : hashSet2) {
            String string2 = (String)var7_10 + c.charValue();
        }
        object2 = Automaton.makeCharSet((String)var7_10);
        Automaton automaton3 = Automaton.makeCharSetStar((String)object3);
        automaton3 = automaton3.concatenate((Automaton)object2);
        Automaton automaton4 = automaton.intersection(automaton3).returnAutomaton();
        Automaton automaton5 = this.automaton.intersection(Automaton.makeCharSetStar((String)object3));
        Vector<BufferStoreContent> vector = new Vector<BufferStoreContent>();
        Set<Transition> set = automaton4.getInitialState().getTransitions();
        for (Transition transition : set) {
            for (char c = transition.getMin(); c <= transition.getMax(); c = (char)(c + '\u0001')) {
                vector.add(BufferContent.getStoreContent(c));
            }
        }
        if (!automaton5.isEmpty()) {
            vector.add(null);
        }
        return vector;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized Buffer getCorrespondingBuffer(BufferStoreContent bufferStoreContent, boolean bl) {
        void var9_12;
        Buffer buffer = new Buffer();
        String string = new String();
        string = Options.getMemoryModel() == 2 && (2 == Options.getExplorationMode() || 0 == Options.getExplorationMode()) ? string + BufferContent.getBSCCharSet(bufferStoreContent) : string + BufferContent.getChar(bufferStoreContent);
        HashSet<Character> hashSet = BufferContent.getAlphabet();
        HashSet<Character> hashSet2 = BufferContent.getVarAlphabet(bufferStoreContent.getId());
        HashSet<Character> hashSet3 = new HashSet<Character>();
        for (Character object22 : hashSet) {
            if (hashSet2.contains(object22)) continue;
            hashSet3.add(object22);
        }
        Object object3 = new String();
        for (Character c : hashSet) {
            object3 = (String)object3 + c.charValue();
        }
        String string2 = new String();
        for (Character c : hashSet3) {
            String string3 = (String)var9_12 + c.charValue();
        }
        Automaton automaton = Automaton.makeCharSetStar((String)object3);
        Automaton automaton2 = Automaton.makeCharSet(string);
        Automaton automaton3 = Automaton.makeCharSetStar((String)var9_12);
        Automaton automaton4 = Automaton.makeCharSetStar((String)var9_12);
        Automaton automaton5 = this.automaton.intersection(automaton.concatenate(automaton2.concatenate(automaton3)));
        Automaton automaton6 = this.automaton.intersection(automaton4);
        buffer.automaton = automaton5;
        if (bl) {
            buffer.automaton = buffer.automaton.union(automaton6);
        }
        buffer.automaton.setDeterministic(false);
        buffer.automaton.minimize();
        return buffer;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized Buffer getCorrespondingBufferLoadNot(BufferStoreContent bufferStoreContent, boolean bl) {
        void var11_18;
        void var10_13;
        Buffer buffer = new Buffer();
        char c = BufferContent.getChar(bufferStoreContent);
        HashSet<Character> hashSet = BufferContent.getAlphabet();
        HashSet<Character> hashSet2 = BufferContent.getVarAlphabet(bufferStoreContent.getId());
        HashSet<Character> hashSet3 = new HashSet<Character>();
        HashSet<Character> hashSet4 = new HashSet<Character>();
        for (Character object32 : hashSet) {
            if (hashSet2.contains(object32)) continue;
            hashSet3.add(object32);
        }
        hashSet4.addAll(hashSet2);
        hashSet4.remove(new Character(c));
        Object object4 = new String();
        for (Character c2 : hashSet) {
            object4 = (String)object4 + c2.charValue();
        }
        String string = new String();
        for (Character c3 : hashSet3) {
            String string2 = (String)var10_13 + c3.charValue();
        }
        String string3 = new String();
        for (Character c4 : hashSet4) {
            String string4 = (String)var11_18 + c4.charValue();
        }
        Automaton automaton = Automaton.makeCharSetStar((String)object4);
        Automaton automaton2 = Automaton.makeCharSet((String)var11_18);
        Automaton automaton3 = Automaton.makeCharSetStar((String)var10_13);
        Automaton automaton4 = Automaton.makeCharSetStar((String)var10_13);
        Automaton automaton5 = this.automaton.intersection(automaton.concatenate(automaton2.concatenate(automaton3)));
        Automaton automaton6 = this.automaton.intersection(automaton4);
        buffer.automaton = automaton5;
        if (bl) {
            buffer.automaton = buffer.automaton.union(automaton6);
        }
        return buffer;
    }

    public static synchronized void updateForSfence(Vector<Buffer> vector, int n) throws BufferSfenceException {
        Buffer buffer = vector.elementAt(n);
        Buffer buffer2 = Buffer.constructSfenceBuffer(buffer);
        for (int i = 0; i < vector.size(); ++i) {
            if (i == n) continue;
            Automaton automaton = vector.elementAt(i).getAutomaton();
            if ((automaton = automaton.intersection(buffer2.getAutomaton())).isEmpty()) {
                throw new BufferSfenceException();
            }
            vector.elementAt(i).setAutomaton(automaton);
        }
    }

    private static Buffer constructSfenceBuffer(Buffer buffer) {
        Buffer buffer2 = new Buffer();
        HashSet<Character> hashSet = BufferContent.getSfenceAlphabet();
        HashSet<Character> hashSet2 = BufferContent.getAlphabetWithoutSfence();
        buffer2.setAutomaton(Automaton.makeFilterCharacter(buffer.automaton, hashSet));
        buffer2.automaton.insertCharacters(hashSet2);
        return buffer2;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized Buffer notLoadFromBuffer(BufferStoreContent bufferStoreContent) {
        void var7_10;
        Buffer buffer = new Buffer();
        BufferContent.getChar(bufferStoreContent);
        HashSet<Character> hashSet = BufferContent.getAlphabet();
        HashSet<Character> hashSet2 = BufferContent.getVarAlphabet(bufferStoreContent.getId());
        HashSet<Character> hashSet3 = new HashSet<Character>();
        for (Character object22 : hashSet) {
            if (hashSet2.contains(object22)) continue;
            hashSet3.add(object22);
        }
        Object object3 = new String();
        for (Character c : hashSet) {
            object3 = (String)object3 + c.charValue();
        }
        String string = new String();
        for (Character c : hashSet3) {
            String string2 = (String)var7_10 + c.charValue();
        }
        Automaton automaton = Automaton.makeCharSetStar((String)var7_10);
        Automaton automaton2 = this.automaton.intersection(automaton);
        buffer.setAutomaton(automaton2);
        return buffer;
    }

    public synchronized boolean strongLoadEquivalent(Buffer buffer, Memory memory, Memory memory2, BufferStoreContent[] bufferStoreContentArray) {
        int n = memory.getNbVars();
        for (int i = 0; i < n; ++i) {
            if (bufferStoreContentArray[i] == null) continue;
            BufferStoreContent bufferStoreContent = bufferStoreContentArray[i];
            Buffer buffer2 = (Buffer)this.clone();
            Buffer buffer3 = (Buffer)buffer.clone();
            buffer2 = buffer2.getCorrespondingBuffer(bufferStoreContent, false);
            buffer3 = buffer3.getCorrespondingBuffer(bufferStoreContent, false);
            if (!buffer2.equals(this) || !buffer3.equals(buffer)) {
                return false;
            }
            buffer2 = (Buffer)this.clone();
            buffer3 = (Buffer)buffer.clone();
            Vector<BufferStoreContent> vector = buffer2.prepareLoadBuffer(i);
            Vector<BufferStoreContent> vector2 = buffer3.prepareLoadBuffer(i);
            if (Options.getMemoryModel() == 2) {
                this.removeBSCTransitions(vector);
                this.removeBSCTransitions(vector2);
            }
            if (vector.size() != vector2.size()) {
                return false;
            }
            if (vector.size() != 1) {
                return false;
            }
            if (vector.elementAt(0) == null || !vector.elementAt(0).equals(bufferStoreContent)) {
                return false;
            }
            if (vector2.elementAt(0) != null && vector2.elementAt(0).equals(bufferStoreContent)) continue;
            return false;
        }
        return true;
    }

    private void removeBSCTransitions(Vector<BufferStoreContent> vector) {
        HashSet<BufferStoreContent> hashSet = new HashSet<BufferStoreContent>();
        for (BufferStoreContent bufferStoreContent : vector) {
            if (bufferStoreContent == null) continue;
            if (bufferStoreContent.getTransition() == null) {
                hashSet.add(bufferStoreContent);
                continue;
            }
            BufferStoreContent bufferStoreContent2 = new BufferStoreContent(bufferStoreContent.getId(), bufferStoreContent.isBool(), bufferStoreContent.boolValue(), bufferStoreContent.intValue(), bufferStoreContent.getName(), null);
            hashSet.add(bufferStoreContent2);
        }
        vector.clear();
        vector.addAll(hashSet);
    }

    public synchronized boolean weakLoadEquivalent(Buffer buffer, Memory memory, Memory memory2, BufferStoreContent[] bufferStoreContentArray, HashSet<Integer> hashSet) {
        int n = memory.getNbVars();
        for (int i = 0; i < n; ++i) {
            Integer n2;
            if (bufferStoreContentArray[i] == null || !hashSet.contains(n2 = new Integer(i))) continue;
            BufferStoreContent bufferStoreContent = bufferStoreContentArray[i];
            Buffer buffer2 = (Buffer)this.clone();
            Buffer buffer3 = (Buffer)buffer.clone();
            buffer2 = buffer2.getCorrespondingBuffer(bufferStoreContent, false);
            buffer3 = buffer3.getCorrespondingBuffer(bufferStoreContent, false);
            if (!buffer2.equals(this) || !buffer3.equals(buffer)) {
                return false;
            }
            Vector<BufferStoreContent> vector = this.prepareLoadBuffer(i);
            Vector<BufferStoreContent> vector2 = buffer.prepareLoadBuffer(i);
            if (Options.getMemoryModel() == 2) {
                this.removeBSCTransitions(vector);
                this.removeBSCTransitions(vector2);
            }
            if (vector.size() != vector2.size()) {
                return false;
            }
            if (vector.size() != 1) {
                return false;
            }
            if (vector.elementAt(0) == null || !vector.elementAt(0).equals(bufferStoreContent)) {
                return false;
            }
            if (vector2.elementAt(0) != null && vector2.elementAt(0).equals(bufferStoreContent)) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean strongLoadEquivalentPSO(Buffer buffer, Memory memory, Memory memory2, BufferStoreContent bufferStoreContent) {
        if (bufferStoreContent == null) {
            return true;
        }
        BufferStoreContent bufferStoreContent2 = bufferStoreContent;
        Buffer buffer2 = (Buffer)this.clone();
        Buffer buffer3 = (Buffer)buffer.clone();
        buffer2 = buffer2.getCorrespondingBuffer(bufferStoreContent2, true);
        buffer3 = buffer3.getCorrespondingBuffer(bufferStoreContent2, true);
        if (!buffer2.equals(this) || !buffer3.equals(buffer)) {
            return false;
        }
        Vector<BufferStoreContent> vector = this.prepareLoadBuffer(bufferStoreContent2.getId());
        Vector<BufferStoreContent> vector2 = buffer.prepareLoadBuffer(bufferStoreContent2.getId());
        if (Options.getMemoryModel() == 2 && (Options.getExplorationMode() == 2 || Options.getExplorationMode() == 0)) {
            this.removeBSCTransitions(vector);
            this.removeBSCTransitions(vector2);
        }
        BufferStoreContent bufferStoreContent3 = new BufferStoreContent(bufferStoreContent2.getId(), bufferStoreContent2.isBool(), bufferStoreContent2.boolValue(), bufferStoreContent2.intValue(), bufferStoreContent2.getName(), null);
        if (vector.size() != vector2.size()) {
            return false;
        }
        if (vector.size() != 1) {
            return false;
        }
        if (vector.elementAt(0) == null || !vector.elementAt(0).equals(bufferStoreContent3)) {
            return false;
        }
        return vector2.elementAt(0) != null && vector2.elementAt(0).equals(bufferStoreContent3);
    }

    public synchronized boolean weakLoadEquivalentPSO(Buffer buffer, Memory memory, Memory memory2, BufferStoreContent bufferStoreContent, HashSet<Integer> hashSet) {
        if (bufferStoreContent == null) {
            return true;
        }
        BufferStoreContent bufferStoreContent2 = bufferStoreContent;
        Integer n = new Integer(bufferStoreContent2.getId());
        if (!hashSet.contains(n)) {
            return true;
        }
        Buffer buffer2 = (Buffer)this.clone();
        Buffer buffer3 = (Buffer)buffer.clone();
        buffer2 = buffer2.getCorrespondingBuffer(bufferStoreContent2, true);
        buffer3 = buffer3.getCorrespondingBuffer(bufferStoreContent2, true);
        if (!buffer2.equals(this) || !buffer3.equals(buffer)) {
            return false;
        }
        Vector<BufferStoreContent> vector = this.prepareLoadBuffer(bufferStoreContent2.getId());
        Vector<BufferStoreContent> vector2 = buffer.prepareLoadBuffer(bufferStoreContent2.getId());
        if (Options.getMemoryModel() == 2 && (Options.getExplorationMode() == 2 || Options.getExplorationMode() == 0)) {
            this.removeBSCTransitions(vector);
            this.removeBSCTransitions(vector2);
        }
        BufferStoreContent bufferStoreContent3 = new BufferStoreContent(bufferStoreContent2.getId(), bufferStoreContent2.isBool(), bufferStoreContent2.boolValue(), bufferStoreContent2.intValue(), bufferStoreContent2.getName(), null);
        if (vector.size() != vector2.size()) {
            return false;
        }
        if (vector.size() != 1) {
            return false;
        }
        if (vector.elementAt(0) == null || !vector.elementAt(0).equals(bufferStoreContent3)) {
            return false;
        }
        return vector2.elementAt(0) != null && vector2.elementAt(0).equals(bufferStoreContent3);
    }

    public int getNbOutTransitionsFromInit() {
        State state = this.automaton.getInitialState();
        int n = 0;
        for (Transition transition : state.getTransitions()) {
            for (char c = transition.getMin(); c <= transition.getMax(); c = (char)(c + '\u0001')) {
                ++n;
            }
        }
        return n;
    }

    public char[] getOutTransitionsFromInit() {
        int n = this.getNbOutTransitionsFromInit();
        if (n == 0) {
            return null;
        }
        char[] cArray = new char[n];
        int n2 = 0;
        for (Transition transition : this.automaton.getInitialState().getTransitions()) {
            char c = transition.getMin();
            while (c <= transition.getMax()) {
                cArray[n2] = c;
                c = (char)(c + '\u0001');
                ++n2;
            }
        }
        Arrays.sort(cArray);
        return cArray;
    }

    public static Automaton unionAutomaton(Buffer buffer, Buffer buffer2) {
        return buffer.automaton.union(buffer2.automaton);
    }

    public static Buffer getUnionStar(Vector<Buffer> vector) {
        Buffer buffer2;
        Vector<Automaton> vector2 = new Vector<Automaton>();
        for (Buffer buffer2 : vector) {
            vector2.add(buffer2.getAutomaton());
        }
        Automaton automaton = Automaton.union(vector2).repeat();
        automaton.minimize();
        buffer2 = new Buffer();
        buffer2.setAutomaton(automaton);
        return buffer2;
    }

    public static Buffer getConcatenation(Buffer buffer, Buffer buffer2) {
        Automaton automaton = buffer.getAutomaton();
        Automaton automaton2 = buffer2.getAutomaton();
        Buffer buffer3 = new Buffer();
        buffer3.setAutomaton(automaton.concatenate(automaton2));
        buffer3.automaton.minimize();
        return buffer3;
    }

    public void printBuffer(String string) {
        String string2 = Constants.TEMP_DIR + "/" + "Remmex" + "/" + "Buffers" + "/";
        String string3 = string2 + "buf" + string + ".dot";
        String string4 = string2 + "buf" + string + ".pdf";
        File file = new File(string3);
        String string5 = this.automaton.toDot();
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(string5);
            fileWriter.close();
            String string6 = "dot -Tpdf " + string3 + " -o " + string4;
            Runtime.getRuntime().exec(string6);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public int getNbStates() {
        return this.automaton.getNumberOfStates();
    }
}

