/*
 * Decompiled with CFR 0.152.
 */
package compiler;

import compiler.ConcretSyntax;
import compiler.TokenStream;
import compiler.syntaxblocs.Program;
import compiler.typecheck.StaticTypeCheck;
import exceptions.InputException;
import exceptions.SyntaxException;
import java.io.File;
import java.io.FileNotFoundException;

public class Compiler
implements Cloneable {
    private Program program;

    public Compiler() {
    }

    public Compiler(File file) throws FileNotFoundException, SyntaxException, InputException {
        this.program = this.compile(file);
    }

    public void display() {
        this.program.display();
    }

    public void checkTypes() throws InputException {
        StaticTypeCheck staticTypeCheck = new StaticTypeCheck(this.program);
        staticTypeCheck.checkTypes();
    }

    private Program compile(File file) throws FileNotFoundException, SyntaxException, InputException {
        TokenStream tokenStream = null;
        tokenStream = new TokenStream(file);
        ConcretSyntax concretSyntax = new ConcretSyntax(tokenStream);
        return concretSyntax.program();
    }

    public Object clone() {
        Compiler compiler;
        try {
            compiler = (Compiler)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("At least one of the subclasses ofCompiler does not implement cloneable");
        }
        compiler.program = this.program != null ? (Program)this.program.clone() : null;
        return compiler;
    }

    public boolean programIsNull() {
        return this.program == null;
    }

    public Program getProgram() {
        return (Program)this.program.clone();
    }
}

