/*
 * Decompiled with CFR 0.152.
 */
package compiler;

import compiler.Token;
import compiler.TokenStream;
import compiler.syntaxblocs.Assignment;
import compiler.syntaxblocs.Binary;
import compiler.syntaxblocs.Break;
import compiler.syntaxblocs.Declaration;
import compiler.syntaxblocs.Declarations;
import compiler.syntaxblocs.DoStatement;
import compiler.syntaxblocs.Expression;
import compiler.syntaxblocs.Identifier;
import compiler.syntaxblocs.IfStatement;
import compiler.syntaxblocs.Load;
import compiler.syntaxblocs.LoadVal;
import compiler.syntaxblocs.Lock;
import compiler.syntaxblocs.Mfence;
import compiler.syntaxblocs.Operator;
import compiler.syntaxblocs.Proctype;
import compiler.syntaxblocs.Proctypes;
import compiler.syntaxblocs.Program;
import compiler.syntaxblocs.Sequence;
import compiler.syntaxblocs.Sfence;
import compiler.syntaxblocs.Skip;
import compiler.syntaxblocs.Statement;
import compiler.syntaxblocs.Statements;
import compiler.syntaxblocs.Store;
import compiler.syntaxblocs.Type;
import compiler.syntaxblocs.Types;
import compiler.syntaxblocs.Unary;
import compiler.syntaxblocs.Unlock;
import compiler.syntaxblocs.Value;
import compiler.syntaxblocs.Variable;
import exceptions.InputException;
import exceptions.SyntaxException;
import java.util.Vector;

public class ConcretSyntax {
    private TokenStream input;
    private Token token;
    private static int nextId = 0;
    private Vector<Variable> globalVariableMap;
    private Vector<Variable> localVariableMap;
    private int currentLine;

    public ConcretSyntax(TokenStream tokenStream) {
        this.input = tokenStream;
        this.token = this.input.nextToken();
        this.globalVariableMap = new Vector();
        this.localVariableMap = new Vector();
        this.currentLine = 1;
    }

    public void syntaxError(String string, String string2) throws SyntaxException {
        throw new SyntaxException("Line number " + this.currentLine, "Error in method: " + string + "\nMessage: " + string2);
    }

    private void match(String string) throws SyntaxException {
        if (this.token.getValue().equals(string)) {
            this.currentLine = this.input.getCurrentLineNbParse();
            this.token = this.input.nextToken();
        } else {
            this.syntaxError("match", "found \"" + this.token.getValue() + "\", " + "requested \"" + string + "\"");
        }
    }

    public Program program() throws SyntaxException, InputException {
        Program program = new Program();
        program.setGlobalDeclarations(this.globalDeclarations());
        program.setInit(this.init());
        program.setProctypes(this.proctypes());
        return program;
    }

    private Declarations globalDeclarations() throws SyntaxException {
        Declarations declarations = new Declarations();
        while (this.token.getValue().equals("int") || this.token.getValue().equals("bool")) {
            this.declaration(declarations, true);
            this.match(";");
        }
        return declarations;
    }

    private void declaration(Declarations declarations, boolean bl) throws SyntaxException {
        Type type = this.type();
        this.variable(declarations, type, bl);
    }

    private Type type() throws SyntaxException {
        Type type = new Type();
        if (this.token.getValue().equals("int")) {
            type.setType(Types.INTEGER);
        } else if (this.token.getValue().equals("bool")) {
            type.setType(Types.BOOLEAN);
        } else {
            this.syntaxError("type", "token must be of type int or bool,\nfound " + this.token.getValue());
        }
        this.token = this.input.nextToken();
        return type;
    }

    private void variable(Declarations declarations, Type type, boolean bl) throws SyntaxException {
        Declaration declaration = null;
        if (this.token.getType().equals("Identifier")) {
            String string = this.token.getValue();
            this.token = this.input.nextToken();
            if (this.token.getValue().equals("[")) {
                Vector<Integer> vector = new Vector<Integer>();
                this.readDimensions(vector);
                declaration = new Declaration(type, vector, string);
            } else {
                Vector<Integer> vector = new Vector<Integer>();
                vector.add(new Integer(0));
                declaration = new Declaration(type, vector, string);
            }
        } else {
            this.syntaxError("variable", "Identifier needed, found " + this.token.getType());
        }
        if (this.token.getValue().equals("=")) {
            this.token = this.input.nextToken();
            if (this.token.getValue().equals("{")) {
                this.readValues(declaration);
            } else {
                if (type.getType() == Types.BOOLEAN) {
                    if (this.token.getValue().equals("true")) {
                        declaration.setValue(new Value(true), 0);
                    } else if (this.token.getValue().equals("false")) {
                        declaration.setValue(new Value(false), 0);
                    } else {
                        this.syntaxError("globalVariable", "true or false requested, found " + this.token.getValue());
                    }
                } else if (type.getType() == Types.INTEGER) {
                    if (this.isInteger(this.token.getValue())) {
                        declaration.setValue(new Value(new Integer(this.token.getValue())), 0);
                    } else {
                        this.syntaxError("variable", "integer value requested, found " + this.token.getValue());
                    }
                } else {
                    this.syntaxError("variable", "integer or boolean value requested, found " + this.token.getValue());
                }
                this.token = this.input.nextToken();
            }
        } else if (declaration != null) {
            declaration.initValues();
        } else {
            throw new InternalError("declaration MUST be not null!");
        }
        declarations.addDeclaration(declaration);
        if (bl) {
            this.globalVariableMap.add(declaration.getVariable());
        } else {
            this.localVariableMap.add(declaration.getVariable());
        }
    }

    private void readDimensions(Vector<Integer> vector) throws SyntaxException {
        while (this.token.getValue().equals("[")) {
            this.token = this.input.nextToken();
            if (!this.isInteger(this.token.getValue())) {
                this.syntaxError("readDimensions", "Integer value requested, found " + this.token.getValue());
            }
            vector.add(Integer.valueOf(this.token.getValue()));
            this.token = this.input.nextToken();
            this.match("]");
        }
    }

    private void readValues(Declaration declaration) throws SyntaxException {
        this.readValues(declaration, 0, declaration.getDimensions(), 0);
    }

    private int readValues(Declaration declaration, int n, int[] nArray, int n2) throws SyntaxException {
        int n3;
        this.match("{");
        if (n == nArray.length - 1) {
            for (n3 = 0; n3 < nArray[n]; ++n3) {
                Value value = this.readValue();
                declaration.setValue(value, n2);
                ++n2;
                this.token = this.input.nextToken();
                if (n3 >= nArray[n] - 1) continue;
                this.match(",");
            }
        } else {
            while (n3 < nArray[n]) {
                n2 = this.readValues(declaration, n + 1, nArray, n2);
                if (n3 < nArray[n] - 1) {
                    this.match(",");
                }
                ++n3;
            }
        }
        this.match("}");
        return n2;
    }

    public Value readValue() throws SyntaxException {
        Value value = null;
        if (this.token.getValue().equals("true")) {
            value = new Value(true);
        } else if (this.token.getValue().equals("false")) {
            value = new Value(false);
        } else if (this.isInteger(this.token.getValue())) {
            value = new Value(Integer.valueOf(this.token.getValue()));
        } else {
            this.syntaxError("readValue", "A boolean or integer value is needed\nfound: " + this.token.getValue());
        }
        return value;
    }

    private Proctype init() {
        Proctype proctype = new Proctype();
        return proctype;
    }

    private Proctypes proctypes() throws SyntaxException, InputException {
        Proctypes proctypes = new Proctypes();
        while (this.token.getValue().equals("proctype")) {
            nextId = 0;
            proctypes.addProctype(this.proctype());
            this.localVariableMap.clear();
        }
        return proctypes;
    }

    private Proctype proctype() throws SyntaxException, InputException {
        this.token = this.input.nextToken();
        if (this.token.getType().equals("Identifier")) {
            Proctype proctype = new Proctype();
            proctype.setName(this.token.getValue());
            this.token = this.input.nextToken();
            this.match("{");
            proctype.setLocalDeclarations(this.localDeclarations());
            proctype.setBody(this.body());
            this.match("}");
            return proctype;
        }
        this.syntaxError("proctype", "Identifier needed, found " + this.token.getType());
        return null;
    }

    private Declarations localDeclarations() throws SyntaxException {
        Declarations declarations = new Declarations();
        while (this.token.getValue().equals("int") || this.token.getValue().equals("bool")) {
            this.declaration(declarations, false);
            this.match(";");
        }
        return declarations;
    }

    private Statements body() throws SyntaxException, InputException {
        Statements statements = new Statements();
        while (!this.token.getValue().equals("}")) {
            statements.addStatement(this.statement());
        }
        return statements;
    }

    private Statement statement() throws SyntaxException, InputException {
        Statement statement = null;
        if (this.token.getValue().equals("if")) {
            statement = this.ifStatement();
        } else if (this.token.getValue().equals("do")) {
            statement = this.doStatement();
        } else if (this.token.getType().equals("Identifier")) {
            statement = this.assignmentStatement();
        } else if (this.token.getValue().equals("store")) {
            statement = this.storeStatement();
        } else if (this.token.getValue().equals("LOCK")) {
            statement = this.lock();
        } else if (this.token.getValue().equals("UNLOCK")) {
            statement = this.unlock();
        } else if (this.token.getValue().equals("MFENCE")) {
            statement = this.mfence();
        } else if (this.token.getValue().equals("SFENCE")) {
            statement = this.sfence();
        } else if (this.token.getType().equals("Keyword")) {
            if (this.token.getValue().equals("break")) {
                statement = new Break();
            } else if (this.token.getValue().equals("skip")) {
                statement = new Skip();
            }
            this.token = this.input.nextToken();
            this.match(";");
        } else {
            this.syntaxError("statement", "unknown statement: " + this.token.getValue());
        }
        return statement != null ? statement : null;
    }

    private IfStatement ifStatement() throws SyntaxException, InputException {
        this.match("if");
        IfStatement ifStatement = new IfStatement();
        while (this.token.getValue().equals("::")) {
            this.token = this.input.nextToken();
            Sequence sequence = this.sequence();
            ifStatement.addSequence(sequence);
        }
        this.match("fi");
        this.match(";");
        return ifStatement;
    }

    private DoStatement doStatement() throws SyntaxException, InputException {
        this.match("do");
        DoStatement doStatement = new DoStatement();
        while (this.token.getValue().equals("::")) {
            this.token = this.input.nextToken();
            Sequence sequence = this.sequence();
            doStatement.addSequence(sequence);
        }
        this.match("od");
        this.match(";");
        return doStatement;
    }

    private Statement assignmentStatement() throws SyntaxException, InputException {
        Assignment assignment = new Assignment(nextId++);
        if (this.token.getType().equals("Identifier")) {
            int n = this.localVariableMap.indexOf(new Variable(this.token.getValue()));
            if (n < 0) {
                throw new InputException("Line number " + this.currentLine, "Variable " + this.token.getValue() + " does not exists");
            }
            Identifier identifier = new Identifier();
            Variable variable = this.localVariableMap.get(n);
            identifier.setVariable(variable);
            this.token = this.input.nextToken();
            Expression[] expressionArray = this.readIndex(variable, nextId);
            identifier.setIndex(expressionArray);
            assignment.setIdentifier(identifier);
            this.match("=");
            assignment.setExpression(this.expression(nextId));
            this.match(";");
        }
        return assignment;
    }

    private Statement storeStatement() throws SyntaxException, InputException {
        this.match("store");
        Store store = new Store(nextId++);
        this.match("(");
        if (this.token.getType().equals("Identifier")) {
            int n = this.globalVariableMap.indexOf(new Variable(this.token.getValue()));
            if (n < 0) {
                throw new InputException("Line number " + this.currentLine, "variable " + this.token.getValue() + "does not exists");
            }
            Identifier identifier = new Identifier();
            Variable variable = this.globalVariableMap.get(n);
            identifier.setVariable(variable);
            this.token = this.input.nextToken();
            Expression[] expressionArray = this.readIndex(variable, nextId);
            identifier.setIndex(expressionArray);
            store.setIdentifier(identifier);
            this.match(",");
            store.setExpression(this.expression(nextId));
            this.match(")");
            this.match(";");
        } else {
            this.syntaxError("storeStatement", "Identifier needed, found " + this.token.getType());
        }
        return store;
    }

    private Expression[] readIndex(Variable variable, int n) throws SyntaxException, InputException {
        Expression[] expressionArray = null;
        int n2 = variable.getNbDimensions();
        int n3 = variable.getSize();
        if (n2 == 0) {
            return expressionArray;
        }
        expressionArray = new Expression[n2];
        if (n2 >= 2 || n2 == 1 && this.token.getValue().equals("[") && n3 != 1) {
            for (int i = 0; i < n2; ++i) {
                this.match("[");
                expressionArray[i] = this.expression(n);
                this.match("]");
            }
        } else {
            expressionArray[0] = new Value(0);
        }
        return expressionArray;
    }

    private Statement lock() throws SyntaxException {
        this.match("LOCK");
        Lock lock = new Lock(nextId++);
        return lock;
    }

    private Statement unlock() throws SyntaxException {
        this.match("UNLOCK");
        Unlock unlock = new Unlock(nextId++);
        return unlock;
    }

    private Statement mfence() throws SyntaxException {
        this.match("MFENCE");
        Mfence mfence = new Mfence(nextId++);
        return mfence;
    }

    private Statement sfence() throws SyntaxException {
        this.match("SFENCE");
        Sfence sfence = new Sfence(nextId++);
        return sfence;
    }

    private Sequence sequence() throws SyntaxException, InputException {
        Sequence sequence = new Sequence();
        Expression expression = this.expression(nextId++);
        this.match("->");
        Statements statements = new Statements();
        while (!(this.token.getValue().equals("od") || this.token.getValue().equals("fi") || this.token.getValue().equals("::"))) {
            statements.addStatement(this.statement());
        }
        sequence.setExpression(expression);
        sequence.setStatements(statements);
        return sequence;
    }

    private Expression expression(int n) throws SyntaxException, InputException {
        Expression expression = this.conjunction(n);
        while (this.token.getValue().equals("||")) {
            Binary binary = new Binary(n);
            binary.setTerm1(expression);
            binary.setOperator(new Operator(this.token.getValue()));
            this.token = this.input.nextToken();
            binary.setTerm2(this.conjunction(n));
            expression = binary;
        }
        return expression;
    }

    private Expression conjunction(int n) throws SyntaxException, InputException {
        Expression expression = this.relation(n);
        while (this.token.getValue().equals("&&")) {
            Binary binary = new Binary(n);
            binary.setTerm1(expression);
            binary.setOperator(new Operator(this.token.getValue()));
            this.token = this.input.nextToken();
            binary.setTerm2(this.relation(n));
            expression = binary;
        }
        return expression;
    }

    private Expression relation(int n) throws SyntaxException, InputException {
        Expression expression = this.addition(n);
        while (this.token.getValue().equals("<") || this.token.getValue().equals("<=") || this.token.getValue().equals(">") || this.token.getValue().equals(">=") || this.token.getValue().equals("==") || this.token.getValue().equals("!=")) {
            Binary binary = new Binary(n);
            binary.setTerm1(expression);
            binary.setOperator(new Operator(this.token.getValue()));
            this.token = this.input.nextToken();
            binary.setTerm2(this.addition(n));
            expression = binary;
        }
        return expression;
    }

    private Expression addition(int n) throws SyntaxException, InputException {
        Expression expression = this.term(n);
        while (this.token.getValue().equals("+") || this.token.getValue().equals("-")) {
            Binary binary = new Binary(n);
            binary.setTerm1(expression);
            binary.setOperator(new Operator(this.token.getValue()));
            this.token = this.input.nextToken();
            binary.setTerm2(this.term(n));
            expression = binary;
        }
        return expression;
    }

    private Expression term(int n) throws SyntaxException, InputException {
        Expression expression = this.negation(n);
        while (this.token.getValue().equals("*") || this.token.getValue().equals("/")) {
            Binary binary = new Binary(n);
            binary.setTerm1(expression);
            binary.setOperator(new Operator(this.token.getValue()));
            this.token = this.input.nextToken();
            binary.setTerm2(this.negation(n));
            expression = binary;
        }
        return expression;
    }

    private Expression negation(int n) throws SyntaxException, InputException {
        if (this.token.getValue().equals("!")) {
            Unary unary = new Unary(n);
            unary.setOperator(new Operator(this.token.getValue()));
            this.token = this.input.nextToken();
            unary.setTerm(this.factor(n));
            return unary;
        }
        return this.factor(n);
    }

    private Expression factor(int n) throws SyntaxException, InputException {
        Expression expression = null;
        if (this.token.getType().equals("Identifier")) {
            Identifier identifier = new Identifier();
            int n2 = this.localVariableMap.indexOf(new Variable(this.token.getValue()));
            Variable variable = this.localVariableMap.get(n2);
            identifier.setVariable(variable);
            Expression[] expressionArray = this.readIndex(variable, n);
            this.token = this.input.nextToken();
            identifier.setIndex(expressionArray);
            expression = identifier;
        } else if (this.token.getType().equals("Literal")) {
            Value value = null;
            if (this.isInteger(this.token.getValue())) {
                value = new Value(Integer.valueOf(this.token.getValue()));
            } else if (this.token.getValue().equals("true")) {
                value = new Value(true);
            } else if (this.token.getValue().equals("false")) {
                value = new Value(false);
            } else {
                this.syntaxError("factor", "Literal must be integer value, or true or false\nfound: " + this.token.getValue());
            }
            expression = value;
            this.token = this.input.nextToken();
        } else if (this.token.getType().equals("Keyword")) {
            if (this.token.getValue().equals("load")) {
                expression = this.load(n);
            } else if (this.token.getValue().equals("loadval")) {
                expression = this.loadval(n);
            } else {
                this.syntaxError("factor", "Keyword must be load or CAS\nfound " + this.token.getValue());
            }
        } else if (this.token.getValue().equals("(")) {
            this.token = this.input.nextToken();
            expression = this.expression(n);
            this.match(")");
        } else {
            this.syntaxError("factor", "unknown sequence, found " + this.token.getValue());
        }
        return expression;
    }

    private Load load(int n) throws SyntaxException, InputException {
        Load load = new Load(n);
        this.match("load");
        this.match("(");
        if (this.token.getType().equals("Identifier")) {
            int n2 = this.globalVariableMap.indexOf(new Variable(this.token.getValue()));
            if (n2 < 0) {
                throw new InputException("Line number " + this.currentLine, "variable " + this.token.getValue() + "does not exists");
            }
            Identifier identifier = new Identifier();
            Variable variable = this.globalVariableMap.get(n2);
            identifier.setVariable(variable);
            this.token = this.input.nextToken();
            Expression[] expressionArray = this.readIndex(variable, n);
            identifier.setIndex(expressionArray);
            load.setIdentifier(identifier);
            this.match(",");
            Expression expression = this.expression(n);
            load.setValue(expression);
            this.match(")");
        } else {
            this.syntaxError("load", "Identifier needed, found " + this.token.getType());
        }
        return load;
    }

    private LoadVal loadval(int n) throws SyntaxException, InputException {
        LoadVal loadVal = new LoadVal(n);
        this.match("loadval");
        this.match("(");
        if (this.token.getType().equals("Identifier")) {
            int n2 = this.globalVariableMap.indexOf(new Variable(this.token.getValue()));
            if (n2 < 0) {
                throw new InputException("Line number " + this.currentLine, "variable " + this.token.getValue() + "does not exists");
            }
            Identifier identifier = new Identifier();
            Variable variable = this.globalVariableMap.get(n2);
            identifier.setVariable(variable);
            this.token = this.input.nextToken();
            Expression[] expressionArray = this.readIndex(variable, n);
            identifier.setIndex(expressionArray);
            loadVal.setIdentifier(identifier);
            this.match(")");
        } else {
            this.syntaxError("loadval", "Identifier needed, found " + this.token.getType());
        }
        return loadVal;
    }

    private boolean isInteger(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if ('0' <= string.charAt(i) && '9' >= string.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

