/*
 * Decompiled with CFR 0.152.
 */
package compiler.syntaxblocs;

import compiler.syntaxblocs.Expression;
import compiler.syntaxblocs.Identifier;
import compiler.syntaxblocs.Output;
import compiler.syntaxblocs.Statement;
import compiler.syntaxblocs.Variable;

public class Assignment
extends Statement
implements Cloneable {
    private Expression expr = null;
    private int id;
    Identifier identifier;

    public Assignment(int n) {
        super("Assignment");
        this.id = n;
        this.identifier = null;
    }

    public void setIdentifier(Identifier identifier) {
        this.identifier = identifier;
    }

    public void setExpression(Expression expression) {
        this.expr = expression;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public void display(int n) {
        Output.display("Assignment: ", n);
        Output.newLine();
        Output.display(this.identifier.toString() + " = " + this.expr.display(), n + 1);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Assignment)) {
            return false;
        }
        Assignment assignment = (Assignment)object;
        if (this.id != assignment.id) {
            return false;
        }
        if (!assignment.identifier.equals(this.identifier)) {
            return false;
        }
        return assignment.expr.equals(this.expr);
    }

    @Override
    public int hashCode() {
        return this.id ^ this.identifier.hashCode();
    }

    public String toString() {
        return "Assignment";
    }

    @Override
    public String getName() {
        return "Assignment";
    }

    @Override
    public String display() {
        return new String(this.identifier.toString() + " = " + this.expr.display());
    }

    @Override
    public Object clone() {
        Assignment assignment = (Assignment)super.clone();
        assignment.expr = (Expression)this.expr.clone();
        assignment.identifier = (Identifier)this.identifier.clone();
        return assignment;
    }

    public Variable getLocalVariable() {
        return this.identifier.getVariable();
    }

    public Expression[] getLocalVariableIndex() {
        return this.identifier.getVariableIndex();
    }

    public Expression getExpression() {
        return (Expression)this.expr.clone();
    }
}

