/*
 * Decompiled with CFR 0.152.
 */
package compiler.syntaxblocs;

import compiler.syntaxblocs.Expression;
import compiler.syntaxblocs.ExpressionProtected;
import compiler.syntaxblocs.Operator;
import compiler.syntaxblocs.Output;
import compiler.syntaxblocs.Unary;

public class Binary
extends ExpressionProtected
implements Cloneable {
    private Operator op = null;
    private Expression term1 = null;
    private Expression term2 = null;
    private int id;

    public Binary(int n) {
        this.id = n;
    }

    public void setOperator(Operator operator) {
        this.op = operator;
    }

    public void setTerm1(Expression expression) {
        this.term1 = expression;
    }

    public void setTerm2(Expression expression) {
        this.term2 = expression;
    }

    @Override
    public void display(int n) {
        this.op.display(n);
        Output.newLine();
        this.term1.display(n + 1);
        Output.newLine();
        this.term2.display(n + 1);
    }

    @Override
    public String display() {
        String string = new String();
        string = this.term1 instanceof Binary || this.term1 instanceof Unary ? string + "(" + this.term1.display() + ")" : string + this.term1.display();
        string = string + " " + this.op.display() + " ";
        string = this.term2 instanceof Binary || this.term2 instanceof Unary ? string + "(" + this.term2.display() + ")" : string + this.term2.display();
        return string;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Binary)) {
            return false;
        }
        Binary binary = (Binary)object;
        if (this.id != binary.id) {
            return false;
        }
        if (!binary.op.equals(this.op)) {
            return false;
        }
        if (!binary.term1.equals(this.term1)) {
            return false;
        }
        return binary.term2.equals(this.term2);
    }

    @Override
    public int hashCode() {
        return this.id;
    }

    @Override
    public String toString() {
        return "Binary";
    }

    @Override
    public String getName() {
        return "Binary";
    }

    @Override
    public Object clone() {
        Binary binary = (Binary)super.clone();
        binary.op = (Operator)this.op.clone();
        binary.term1 = (Expression)this.term1.clone();
        binary.term2 = (Expression)this.term2.clone();
        return binary;
    }

    public Operator getOperator() {
        return (Operator)this.op.clone();
    }

    public Expression getExpression1() {
        return (Expression)this.term1.clone();
    }

    public Expression getExpression2() {
        return (Expression)this.term2.clone();
    }
}

