/*
 * Decompiled with CFR 0.152.
 */
package compiler.syntaxblocs;

import compiler.syntaxblocs.Types;

public class Type
implements Cloneable {
    private Types type;

    public Type(Types types) {
        this.type = types;
    }

    public Type() {
        this.type = Types.UNDEFINED;
    }

    public boolean isBool() {
        return this.type == Types.BOOLEAN;
    }

    public boolean isInteger() {
        return this.type == Types.INTEGER;
    }

    public boolean isUndefined() {
        return this.type == Types.UNDEFINED;
    }

    public void setType(Types types) {
        this.type = types;
    }

    public Types getType() {
        return this.type;
    }

    public String toString() {
        switch (this.type) {
            case BOOLEAN: {
                return "bool";
            }
            case INTEGER: {
                return "int";
            }
        }
        return "undefined";
    }

    public String display() {
        return this.toString();
    }

    public Object clone() {
        Type type;
        try {
            type = (Type)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("At least one of the subclasses ofType does not implement cloneable");
        }
        switch (this.type) {
            case BOOLEAN: {
                type.type = Types.BOOLEAN;
                break;
            }
            case INTEGER: {
                type.type = Types.INTEGER;
                break;
            }
            default: {
                type.type = Types.UNDEFINED;
            }
        }
        return type;
    }
}

