/*
 * Decompiled with CFR 0.152.
 */
package compiler.syntaxblocs;

import compiler.syntaxblocs.Expression;
import compiler.syntaxblocs.Output;
import compiler.syntaxblocs.Type;
import compiler.syntaxblocs.Types;

public class Value
extends Expression
implements Cloneable {
    private Type type;
    private int intValue;
    private boolean boolValue;

    public Value(int n) {
        this.type = new Type(Types.INTEGER);
        this.intValue = n;
    }

    public Value(boolean bl) {
        this.type = new Type(Types.BOOLEAN);
        this.boolValue = bl;
    }

    public Value() {
        this.type = new Type(Types.UNDEFINED);
    }

    public Value(Value value) {
        this.type = new Type(value.getType());
        this.intValue = value.getIntValue();
        this.boolValue = value.getBoolValue();
    }

    public Types getType() {
        return this.type.getType();
    }

    public int getIntValue() {
        return this.intValue;
    }

    public boolean getBoolValue() {
        return this.boolValue;
    }

    @Override
    public String toString() {
        return "Value";
    }

    @Override
    public String getName() {
        return "Value";
    }

    @Override
    public void display(int n) {
        if (n != -1) {
            // empty if block
        }
        if (this.type.isInteger()) {
            Output.display(Integer.toString(this.intValue), n);
        } else if (this.type.isBool()) {
            Output.display(Boolean.toString(this.boolValue), n);
        }
    }

    @Override
    public String display() {
        if (this.type.isInteger()) {
            return Integer.toString(this.intValue);
        }
        if (this.type.isBool()) {
            return Boolean.toString(this.boolValue);
        }
        return "undefined";
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Value)) {
            return false;
        }
        Value value = (Value)object;
        if (this.type.getType() != value.type.getType()) {
            return false;
        }
        if (this.intValue != value.intValue) {
            return false;
        }
        return this.boolValue == value.boolValue;
    }

    @Override
    public int hashCode() {
        throw new InternalError("No reason to need hash code of Value");
    }

    @Override
    public Object clone() {
        Value value = (Value)super.clone();
        value.type = (Type)this.type.clone();
        return value;
    }

    public static Value getDefaultValue(Type type) {
        if (type == new Type(Types.BOOLEAN)) {
            return new Value(false);
        }
        if (type == new Type(Types.INTEGER)) {
            return new Value(0);
        }
        return new Value();
    }
}

