/*
 * Decompiled with CFR 0.152.
 */
package compiler.syntaxblocs;

import compiler.syntaxblocs.Declaration;
import compiler.syntaxblocs.ExpressionProtected;
import compiler.syntaxblocs.Output;

public class Variable
extends ExpressionProtected
implements Cloneable {
    private String id;
    private int size;
    private Declaration decl;

    public Variable() {
    }

    public Variable(String string) {
        this.id = string;
        this.size = 1;
    }

    public Variable(String string, int n, Declaration declaration) {
        this.id = string;
        this.size = n;
        this.decl = declaration;
    }

    @Override
    public void display(int n) {
        Output.display(this.id, n);
    }

    public boolean isBool() {
        return this.decl.getType().isBool();
    }

    public boolean isInteger() {
        return this.decl.getType().isInteger();
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public String display() {
        return this.toString();
    }

    @Override
    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public String toString() {
        return this.id;
    }

    @Override
    public String getName() {
        return "Variable";
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Variable)) {
            return false;
        }
        Variable variable = (Variable)object;
        return this.id.equals(variable.id);
    }

    @Override
    public Object clone() {
        Variable variable = (Variable)super.clone();
        variable.id = new String(this.id);
        variable.decl = this.decl;
        return variable;
    }

    public int getIndexFromPosition(int[] nArray) {
        return this.decl.getIndexFromPosition(nArray);
    }

    public int getNbDimensions() {
        return this.decl.getNbDimensions();
    }

    public int[] getDimensions() {
        return this.decl.getDimensions();
    }
}

