/*
 * Decompiled with CFR 0.152.
 */
package compiler.typecheck;

import compiler.syntaxblocs.Assignment;
import compiler.syntaxblocs.Binary;
import compiler.syntaxblocs.Declaration;
import compiler.syntaxblocs.DoStatement;
import compiler.syntaxblocs.Expression;
import compiler.syntaxblocs.Identifier;
import compiler.syntaxblocs.IfStatement;
import compiler.syntaxblocs.Load;
import compiler.syntaxblocs.LoadVal;
import compiler.syntaxblocs.Operator;
import compiler.syntaxblocs.Proctype;
import compiler.syntaxblocs.Program;
import compiler.syntaxblocs.Sequence;
import compiler.syntaxblocs.Statement;
import compiler.syntaxblocs.Statements;
import compiler.syntaxblocs.Store;
import compiler.syntaxblocs.Type;
import compiler.syntaxblocs.Types;
import compiler.syntaxblocs.Unary;
import compiler.syntaxblocs.Value;
import compiler.syntaxblocs.Variable;
import exceptions.InputException;
import exceptions.TwoVariablesLoadedException;
import java.util.Iterator;
import java.util.TreeMap;

public class StaticTypeCheck {
    private Program program;
    private TreeMap<String, Type> globalMap;
    private TreeMap<String, Type> localMap;

    public StaticTypeCheck(Program program) throws InputException {
        this.program = program;
        this.globalMap = new TreeMap();
        this.localMap = new TreeMap();
        this.initGlobalMap();
    }

    public boolean checkTypes() throws InputException {
        Iterator<Proctype> iterator = this.program.getProctypesIter();
        while (iterator.hasNext()) {
            Proctype proctype = iterator.next();
            this.initLocalMap(proctype.getLocalDeclarationsIter());
            this.verify(proctype);
            this.clearLocalMap();
        }
        return true;
    }

    private void initGlobalMap() throws InputException {
        Iterator<Declaration> iterator = this.program.getGlobalDeclarationIter();
        while (iterator.hasNext()) {
            Declaration declaration = iterator.next();
            String string = declaration.toString();
            if (this.globalMap.containsKey(string)) {
                throw new InputException("Declaration error: two global variables with same name: \"" + string + "\"");
            }
            this.globalMap.put(string, declaration.getType());
            int n = declaration.getSize();
            for (int i = 0; i < n; ++i) {
                Value value = declaration.getValue(i);
                if (value == null) continue;
                if (this.verify(value)) {
                    if (value.getType() == declaration.getType().getType()) continue;
                    throw new InputException("Type error: global variable type not compatible with initial value: \"" + declaration.toString() + "\"");
                }
                throw new InputException("Type error: value of global Variable not correct: \"" + declaration.toString() + "\"");
            }
        }
    }

    private void initLocalMap(Iterator<Declaration> iterator) throws InputException {
        while (iterator.hasNext()) {
            Declaration declaration = iterator.next();
            String string = declaration.toString();
            if (this.localMap.containsKey(string)) {
                throw new InputException("Declaration error: two local variables with same name: \"" + string + "\"");
            }
            this.localMap.put(string, declaration.getType());
            int n = declaration.getSize();
            for (int i = 0; i < n; ++i) {
                Value value = declaration.getValue(i);
                if (value == null) continue;
                if (this.verify(value)) {
                    if (value.getType() == declaration.getType().getType()) continue;
                    throw new InputException("Type error: local variable type not compatible with initial value: \"" + declaration.toString() + "\"");
                }
                throw new InputException("Type error: value of local Variable not correct: \"" + declaration.toString() + "\"");
            }
        }
    }

    private void clearLocalMap() {
        this.localMap.clear();
    }

    private void verify(Proctype proctype) throws InputException {
        if (!this.verify(proctype.getStatements())) {
            this.throwInputException("Type error in proctype");
        }
    }

    private boolean verify(Statements statements) throws InputException {
        Iterator<Statement> iterator = statements.getStatementsIterator();
        while (iterator.hasNext()) {
            Statement statement = iterator.next();
            if (this.verify(statement)) continue;
            return false;
        }
        return true;
    }

    private boolean verify(Statement statement) throws InputException {
        boolean bl;
        boolean bl2;
        Expression expression;
        Variable variable;
        Identifier identifier;
        if (statement.getName().equals("Skip") || statement.getName().equals("Break") || statement.getName().equals("ClearBuffers") || statement.getName().equals("Lock") || statement.getName().equals("Unlock") || statement.getName().equals("Mfence") || statement.getName().equals("Sfence")) {
            return true;
        }
        if (statement.getName().equals("Assignment")) {
            Assignment assignment = (Assignment)statement;
            identifier = assignment.getIdentifier();
            variable = identifier.getVariable();
            expression = assignment.getExpression();
            boolean bl3 = this.localMap.containsKey(variable.toString());
            bl2 = this.verify(identifier);
            bl = this.verify(expression);
            if (bl3 && bl2 && bl && this.localMap.get(variable.toString()).getType() == this.typeOf(expression)) {
                return true;
            }
            this.throwInputException("Type error: assignment " + assignment.display());
        }
        if (statement.getName().equals("IfStatement")) {
            return this.verifySequences(((IfStatement)statement).getIfSequencesIterator());
        }
        if (statement.getName().equals("DoStatement")) {
            return this.verifySequences(((DoStatement)statement).getDoSequencesIterator());
        }
        if (statement.getName().equals("Store")) {
            Store store = (Store)statement;
            identifier = store.getIdentifier();
            variable = identifier.getVariable();
            expression = store.getExpression();
            bl2 = this.globalMap.containsKey(variable.toString());
            bl = this.verify(identifier);
            boolean bl4 = this.verify(expression);
            if (bl2 && bl && bl4 && this.globalMap.get(variable.toString()).getType() == this.typeOf(expression)) {
                return true;
            }
            this.throwInputException("Type error: store " + store.display());
        }
        this.throwInputException("unknown statement: " + statement.toString());
        return false;
    }

    private boolean verify(Expression expression) throws InputException {
        Cloneable cloneable;
        Cloneable cloneable2;
        Expression expression2;
        Expression expression3;
        if (expression.getName().equals("Value")) {
            return true;
        }
        if (expression.getName().equals("LocalVariable")) {
            this.throwInputException("Should never pass here");
        }
        if (expression.getName().equals("Identifier")) {
            Identifier identifier = (Identifier)expression;
            String string = identifier.toString();
            if (!this.localMap.containsKey(string) && !this.globalMap.containsKey(string)) {
                return false;
            }
            Expression[] expressionArray = identifier.getVariableIndex();
            for (int i = 0; i < expressionArray.length; ++i) {
                if (this.verify(expressionArray[i]) && Types.INTEGER == this.typeOf(expressionArray[i])) continue;
                return false;
            }
            return true;
        }
        if (expression.getName().equals("Binary")) {
            expression3 = (Binary)expression;
            expression2 = ((Binary)expression3).getExpression1();
            cloneable2 = ((Binary)expression3).getExpression2();
            cloneable = ((Binary)expression3).getOperator();
            if (!this.verify(expression2) || !this.verify((Expression)cloneable2)) {
                this.throwInputException("Type error: binary" + ((Binary)expression3).display());
            }
            if (((Operator)cloneable).arithmeticOp() || ((Operator)cloneable).relationOp()) {
                if (this.typeOf(expression2) == Types.INTEGER && this.typeOf((Expression)cloneable2) == Types.INTEGER) {
                    return true;
                }
                this.throwInputException("Type error: binary " + ((Binary)expression3).display());
            }
            if (((Operator)cloneable).boolOp()) {
                if (this.typeOf(expression2) == Types.BOOLEAN && this.typeOf((Expression)cloneable2) == Types.BOOLEAN) {
                    if (!this.oneSingleVarLoaded(expression2, (Expression)cloneable2)) {
                        this.throwInputException("Only one shared variable can be loaded in a single boolean operation! " + ((Binary)expression3).display());
                    }
                    return true;
                }
                this.throwInputException("Type error: binary" + ((Binary)expression3).display());
            }
        }
        if (expression.getName().equals("Unary")) {
            expression3 = (Unary)expression;
            expression2 = ((Unary)expression3).getExpression();
            cloneable2 = ((Unary)expression3).getOperator();
            if (this.typeOf(expression2) == Types.BOOLEAN && this.verify(expression2) && ((Operator)cloneable2).unaryOp()) {
                if (!this.oneSingleVarLoaded(expression2)) {
                    this.throwInputException("Only one shared variable can be loaded in a single boolean operation! " + ((Unary)expression3).display());
                }
                if (!expression2.getName().equals("Load")) {
                    try {
                        cloneable = this.varLoaded(expression2);
                        if (cloneable != null) {
                            this.throwInputException("A load might only be directly be preceded by a negation, not be contained in an expression preceded by a negation: " + ((Unary)expression3).display());
                        }
                    }
                    catch (TwoVariablesLoadedException twoVariablesLoadedException) {
                        throw new InternalError("Should never reach this line");
                    }
                }
                return true;
            }
            this.throwInputException("Type error: unary" + ((Unary)expression3).display());
        }
        if (expression.getName().equals("Load")) {
            expression3 = (Load)expression;
            expression2 = ((Load)expression3).getIdentifier();
            cloneable2 = ((Identifier)expression2).getVariable();
            cloneable = ((Load)expression3).getExpression();
            if (!this.globalMap.containsKey(((Variable)cloneable2).toString())) {
                this.throwInputException("Type error: load" + ((Load)expression3).display());
            }
            if (!this.verify(expression2)) {
                this.throwInputException("Type error: load" + ((Load)expression3).display());
            }
            if (this.globalMap.get(((Variable)cloneable2).toString()).getType() == this.typeOf((Expression)cloneable) && this.verify((Expression)cloneable)) {
                return true;
            }
            this.throwInputException("Type error: load" + ((Load)expression3).display());
        }
        if (expression.getName().equals("LoadVal")) {
            expression3 = (LoadVal)expression;
            expression2 = ((LoadVal)expression3).getIdentifier();
            cloneable2 = ((Identifier)expression2).getVariable();
            if (!this.globalMap.containsKey(((Variable)cloneable2).toString())) {
                this.throwInputException("Type error: loadVal" + ((LoadVal)expression3).display());
            }
            if (!this.verify(expression2)) {
                this.throwInputException("Type error: load" + ((LoadVal)expression3).display());
            }
            return true;
        }
        this.throwInputException("Type error: unkown error");
        return false;
    }

    private Types typeOf(Expression expression) {
        Object object;
        Expression expression2;
        if (expression.getName().equals("Value")) {
            return ((Value)expression).getType();
        }
        if (expression.getName().equals("Identifier")) {
            expression2 = (Identifier)expression;
            object = ((Identifier)expression2).toString();
            if (!this.localMap.containsKey(object) && !this.globalMap.containsKey(object)) {
                return Types.UNDEFINED;
            }
            if (this.localMap.containsKey(object)) {
                return this.localMap.get(object).getType();
            }
            if (this.globalMap.containsKey(object)) {
                return this.globalMap.get(object).getType();
            }
        }
        if (expression.getName().equals("Binary")) {
            expression2 = (Binary)expression;
            object = ((Binary)expression2).getOperator();
            if (((Operator)object).arithmeticOp()) {
                return Types.INTEGER;
            }
            if (((Operator)object).relationOp() || ((Operator)object).boolOp()) {
                return Types.BOOLEAN;
            }
            return Types.UNDEFINED;
        }
        if (expression.getName().equals("Unary")) {
            if (((Unary)expression).getOperator().unaryOp()) {
                return Types.BOOLEAN;
            }
            return Types.UNDEFINED;
        }
        if (expression.getName().equals("Load")) {
            return Types.BOOLEAN;
        }
        if (expression.getName().equals("LoadVal")) {
            expression2 = (LoadVal)expression;
            object = ((LoadVal)expression2).getIdentifier();
            Variable variable = ((Identifier)object).getVariable();
            return this.globalMap.get(variable.toString()).getType();
        }
        if (expression.getName().equals("Cas")) {
            return Types.BOOLEAN;
        }
        return Types.UNDEFINED;
    }

    private boolean verifySequences(Iterator<Sequence> iterator) throws InputException {
        boolean bl = true;
        while (iterator.hasNext()) {
            Sequence sequence = iterator.next();
            Expression expression = sequence.getExpression();
            Statements statements = sequence.getStatements();
            if (this.verify(expression) && this.typeOf(expression) == Types.BOOLEAN && this.verify(statements)) continue;
            bl = false;
        }
        return bl;
    }

    private void throwInputException(String string) throws InputException {
        throw new InputException(string);
    }

    private boolean oneSingleVarLoaded(Expression expression, Expression expression2) throws InputException {
        try {
            Identifier identifier = this.varLoaded(expression);
            Identifier identifier2 = this.varLoaded(expression2);
            if (identifier != null && identifier2 != null && !identifier.equals(identifier2)) {
                return false;
            }
        }
        catch (TwoVariablesLoadedException twoVariablesLoadedException) {
            return false;
        }
        return true;
    }

    private boolean oneSingleVarLoaded(Expression expression) throws InputException {
        try {
            Identifier identifier = this.varLoaded(expression);
        }
        catch (TwoVariablesLoadedException twoVariablesLoadedException) {
            return false;
        }
        return true;
    }

    private Identifier varLoaded(Expression expression) throws InputException, TwoVariablesLoadedException {
        if (expression.getName().equals("Value")) {
            return null;
        }
        if (expression.getName().equals("LocalVariable")) {
            this.throwInputException("Should never pass here");
        }
        if (expression.getName().equals("Identifier")) {
            Identifier identifier = (Identifier)expression;
            String string = identifier.toString();
            if (this.localMap.containsKey(string)) {
                return null;
            }
            return identifier;
        }
        if (expression.getName().equals("Binary")) {
            Binary binary = (Binary)expression;
            Expression expression2 = binary.getExpression1();
            Expression expression3 = binary.getExpression2();
            Identifier identifier = this.varLoaded(expression2);
            Identifier identifier2 = this.varLoaded(expression3);
            if (identifier == null || identifier2 == null) {
                return identifier != null ? identifier : identifier2;
            }
            if (!identifier.equals(identifier2)) {
                throw new TwoVariablesLoadedException(expression + " loaded two variables in a single expression, which is forbidden!");
            }
            return identifier;
        }
        if (expression.getName().equals("Unary")) {
            Unary unary = (Unary)expression;
            Expression expression4 = unary.getExpression();
            Identifier identifier = this.varLoaded(expression4);
            return identifier;
        }
        if (expression.getName().equals("Load")) {
            Load load = (Load)expression;
            Identifier identifier = load.getIdentifier();
            return identifier;
        }
        if (expression.getName().equals("LoadVal")) {
            LoadVal loadVal = (LoadVal)expression;
            Identifier identifier = loadVal.getIdentifier();
            return identifier;
        }
        return null;
    }
}

