/*
 * Decompiled with CFR 0.152.
 */
package controlgraph;

import buffer.Buffer;
import compiler.syntaxblocs.Declaration;
import compiler.syntaxblocs.Declarations;
import compiler.syntaxblocs.Instruction;
import compiler.syntaxblocs.Statement;
import controlgraph.ControlGraphs;
import controlgraph.Expression;
import controlgraph.Identifier;
import controlgraph.Node;
import controlgraph.Transition;
import controlgraph.Variable;
import controlgraph.actions.MfenceStatement;
import controlgraph.actions.SfenceStatement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public class ControlGraph {
    private Vector<Node> nodes = new Vector();
    private HashSet<Integer> initialNodes = new HashSet();
    private Vector<Variable> localVariables = new Vector();
    private Vector<Variable> initialVariableValues = new Vector();
    private HashMap<Integer, Integer> controlLoc2NodeNb = new HashMap();
    private HashMap<Transition, Vector<Instruction>> transitions2ProgramCode;
    private HashSet<Variable> loadedVars;
    private int nbProcess;
    private int nextNodeId = 0;
    private ControlGraphs cGs;

    public ControlGraph(Declarations declarations, int n, ControlGraphs controlGraphs) {
        this.nbProcess = n;
        this.transitions2ProgramCode = new HashMap();
        this.loadedVars = new HashSet();
        this.cGs = controlGraphs;
        this.initLocalVariables(declarations);
    }

    public void mapControlLoc2NodeNb() {
        for (int i = 0; i < this.nodes.size(); ++i) {
            this.controlLoc2NodeNb.put(new Integer(this.nodes.elementAt(i).getNbNode()), new Integer(i));
        }
    }

    public int getNbProcess() {
        return this.nbProcess;
    }

    public int getNbLocalVars() {
        return this.localVariables.size();
    }

    public Variable getLocalVariableAt(int n) {
        return this.localVariables.elementAt(n);
    }

    public void addLoadedVar(Variable variable) {
        this.loadedVars.add(variable);
    }

    public HashSet<Variable> getLoadedVars() {
        return this.loadedVars;
    }

    public Variable getInitialLocalVariableAt(int n) {
        return this.initialVariableValues.elementAt(n);
    }

    public Variable getLocalVariable(String string) {
        for (int i = 0; i < this.localVariables.size(); ++i) {
            if (!this.localVariables.elementAt(i).getName().equals(string)) continue;
            return this.localVariables.elementAt(i);
        }
        return null;
    }

    public String toDot() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<Node> iterator = this.nodes.iterator();
        stringBuffer.append("digraph B {");
        stringBuffer.append('\n');
        stringBuffer.append("nodesep=0.7");
        stringBuffer.append('\n');
        stringBuffer.append("initial [shape=plaintext,label=\"\"];\n");
        stringBuffer.append("initial -> 0").append("\n");
        while (iterator.hasNext()) {
            Node node = iterator.next();
            if (node.isFalseNode()) continue;
            stringBuffer.append(node.toDot());
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public String toDot(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<Node> iterator = this.nodes.iterator();
        stringBuffer.append("digraph B" + Integer.toString(n) + " {");
        stringBuffer.append('\n');
        stringBuffer.append("nodesep=0.7");
        stringBuffer.append('\n');
        stringBuffer.append("initial [shape=plaintext,label=\"\"];\n");
        stringBuffer.append("initial -> 0").append("\n");
        while (iterator.hasNext()) {
            Node node = iterator.next();
            if (node.isFalseNode()) continue;
            stringBuffer.append(node.toDot());
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public Node addNode() {
        Node node = new Node(this.nextNodeId);
        ++this.nextNodeId;
        this.nodes.add(node);
        return node;
    }

    public int getNodesSize() {
        return this.nodes.size();
    }

    public Node getNode(int n) {
        if (this.getNodesSize() <= n) {
            // empty if block
        }
        return this.nodes.elementAt(n);
    }

    public Node getControlLocationNode(int n) {
        if (this.controlLoc2NodeNb.containsKey(new Integer(n))) {
            return this.nodes.elementAt(this.controlLoc2NodeNb.get(new Integer(n)));
        }
        throw new InternalError("Should never pass here: control location: " + n + " not in controlGraph");
    }

    public Iterator<Integer> getInitialNodesIterator() {
        return this.initialNodes.iterator();
    }

    public Iterator<Node> getNodesIterator() {
        return this.nodes.iterator();
    }

    public void setInitial(int n) {
        if (this.getNodesSize() <= n) {
            // empty if block
        }
        this.initialNodes.add(new Integer(n));
    }

    public void addTransition(int n, int n2) {
    }

    public void addTransition(Transition transition, int n) {
        if (this.getNodesSize() <= n) {
            // empty if block
        }
        if (this.getNodesSize() <= transition.getTargetNode().getNbNode()) {
            // empty if block
        }
        this.nodes.elementAt(n).addTransition(transition);
    }

    private void initLocalVariables(Declarations declarations) {
        if (declarations == null) {
            return;
        }
        Iterator<Declaration> iterator = declarations.iterator();
        while (iterator.hasNext()) {
            Declaration declaration = iterator.next();
            String string = declaration.getName();
            for (int i = 0; i < declaration.getSize(); ++i) {
                Variable variable;
                String string2 = string + "(" + i + ")";
                if (declaration.getType().isBool()) {
                    variable = new Variable(this.localVariables.size(), declaration.getValue(i).getBoolValue(), string2);
                } else if (declaration.getType().isInteger()) {
                    variable = new Variable(this.localVariables.size(), declaration.getValue(i).getIntValue(), string2);
                } else {
                    throw new InternalError("Should never pass here: Variable must be initialized");
                }
                this.localVariables.add(variable);
                this.initialVariableValues.add((Variable)variable.clone());
            }
        }
    }

    public void removeNode(Node node) {
        int n = this.nodes.indexOf(node);
        this.nodes.setElementAt(new Node(), n);
    }

    public Variable getLocalVar(compiler.syntaxblocs.Variable variable) {
        String string = variable.toString();
        for (Variable variable2 : this.localVariables) {
            if (!variable2.getName().equals(string)) continue;
            return variable2;
        }
        throw new InternalError("Should never pass here: local variable \"" + string + "\" does not exists");
    }

    public void setLocalVar(int n, int n2) {
        this.localVariables.elementAt(n).setValue(n2);
    }

    public void setLocalVar(int n, boolean bl) {
        this.localVariables.elementAt(n).setValue(bl);
    }

    public void setLocalVar(int n, boolean bl, int n2) {
        this.localVariables.elementAt(n2).setValue(n);
        this.localVariables.elementAt(n2).setValue(bl);
    }

    public void addInstructions2ProgramCode(Transition transition, Instruction instruction) {
        if (this.transitions2ProgramCode.containsKey(transition)) {
            Vector<Instruction> vector = this.transitions2ProgramCode.get(transition);
            if (instruction instanceof Statement) {
                Statement statement = (Statement)instruction;
                if (!vector.contains(statement)) {
                    vector.add(statement);
                }
            } else {
                compiler.syntaxblocs.Expression expression = (compiler.syntaxblocs.Expression)instruction;
                if (!vector.contains(expression)) {
                    vector.add(expression);
                }
            }
        } else {
            Vector<Instruction> vector = new Vector<Instruction>();
            vector.add(instruction);
            this.transitions2ProgramCode.put(transition, vector);
        }
    }

    public boolean deleteUseLessNodes() {
        this.removeStatesWithNoPred();
        HashSet<Node> hashSet = new HashSet<Node>();
        Iterator<Integer> iterator = this.initialNodes.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Integer n = iterator.next();
            Node node = this.nodes.elementAt(n);
            LinkedList<Node> linkedList = new LinkedList<Node>();
            linkedList.add(node);
            while (!linkedList.isEmpty()) {
                Object object;
                node = (Node)linkedList.removeFirst();
                if (hashSet.contains(node)) continue;
                hashSet.add(node);
                if (node.getNbSuccessors() == 1 && ((Transition)(object = node.getTransitionsIterator().next())).getLabel().equals("true")) {
                    Node node2 = ((Transition)object).getTargetNode();
                    node.merge(node2);
                    if (node.getNbPred() == 0 && node.getNbNode() != 0) {
                        this.nodes.remove(node);
                    }
                    if (node2.getNbPred() == 0 && node2.getNbNode() != 0) {
                        this.nodes.remove(node2);
                    }
                    bl = true;
                }
                object = node.getTransitionsIterator();
                while (object.hasNext()) {
                    linkedList.add(((Transition)object.next()).getTargetNode());
                }
            }
        }
        return bl;
    }

    public boolean matchStates() {
        boolean bl = true;
        boolean bl2 = false;
        this.removeStatesWithNoPred();
        for (int i = 0; i < this.nodes.size(); ++i) {
            Node node = this.nodes.elementAt(i);
            for (int j = i + 1; j < this.nodes.size(); ++j) {
                Transition transition;
                Object object;
                bl = true;
                Node node2 = this.nodes.elementAt(j);
                if (node.getNbPred() == 0 && node.getNbNode() != 0 || node2.getNbNode() == 0 && node2.getNbNode() != 0 || node.getNbSuccessors() != node2.getNbSuccessors()) continue;
                Iterator<Transition> iterator = node.getTransitionsIterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (node2.containsTransitionAt(((Transition)object).getTargetNode().getNbNode(), ((Transition)object).getLabel())) continue;
                    bl = false;
                }
                if (!bl) continue;
                object = node2.getBackTransitionsIterator();
                while (object.hasNext()) {
                    transition = (Transition)object.next();
                    object.remove();
                    transition.setTargetNode(node);
                    node.addBackTransition(transition);
                    node.incrementNbPred();
                    node2.decrementNbPred();
                }
                object = node2.getTransitionsIterator();
                while (object.hasNext()) {
                    transition = object.next();
                    Node node3 = transition.getTargetNode();
                    node3.removeBackTransition(transition);
                }
                this.nodes.remove(node2);
                bl2 = true;
            }
        }
        return bl2;
    }

    public void removeStatesWithNoPred() {
        Iterator<Node> iterator = this.nodes.iterator();
        while (iterator.hasNext()) {
            Node node = iterator.next();
            if (node.isFalseNode() || node.getNbNode() == 0 || node.getNbPred() != 0) continue;
            iterator.remove();
        }
    }

    public Transition putMfence(Transition transition) {
        Node node = transition.getTargetNode();
        Node node2 = this.addNode();
        transition.setTargetNode(node2);
        node2.addBackTransition(transition);
        node2.incrementNbPred();
        node.removeBackTransition(transition);
        Transition transition2 = new Transition(node2, node, "Mfence", this.nbProcess, this, 4, new MfenceStatement(this));
        node2.addTransition(transition2);
        node.addBackTransition(transition2);
        this.controlLoc2NodeNb.put(new Integer(node2.getNbNode()), new Integer(this.controlLoc2NodeNb.size()));
        return transition2;
    }

    public Transition putSfence(Transition transition) {
        Node node = transition.getSourceNode();
        Node node2 = this.addNode();
        Transition transition2 = new Transition(node, node2, "Sfence", this.nbProcess, this, 14, new SfenceStatement(this));
        transition.setSourceNode(node2);
        node2.incrementNbPred();
        node2.addBackTransition(transition2);
        node2.addTransition(transition);
        node.removeTransition(transition);
        node.addTransition(transition2);
        this.controlLoc2NodeNb.put(new Integer(node2.getNbNode()), new Integer(this.controlLoc2NodeNb.size()));
        return transition2;
    }

    public Transition removeMfenceTransition(Transition transition) {
        Node node = transition.getSourceNode();
        Node node2 = transition.getTargetNode();
        if (node.getBackTransitions().size() != 1) {
            throw new InternalError("number of backtransitions of a source state of mfence must be 1, but is " + node.getBackTransitions().size());
        }
        Transition transition2 = node.getBackTransitions().firstElement();
        transition2.setTargetNode(node2);
        node2.removeBackTransition(transition);
        node2.addBackTransition(transition2);
        return transition2;
    }

    public Transition removeSfenceTransition(Transition transition) {
        Node node = transition.getSourceNode();
        Node node2 = transition.getTargetNode();
        if (node2.getTransitions().size() != 1) {
            throw new InternalError("number of transitions of a destination state of sfence must be 1, but is " + node2.getTransitions().size());
        }
        Transition transition2 = node2.getTransitions().firstElement();
        node.removeTransition(transition);
        node.addTransition(transition2);
        transition2.setSourceNode(node);
        return transition2;
    }

    public void reinsertMfenceOperation(Transition transition, Transition transition2) {
        Node node = transition.getTargetNode();
        Node node2 = transition2.getSourceNode();
        Node node3 = transition2.getTargetNode();
        if (!node.equals(node3)) {
            System.out.println("should be the same target nodes");
        }
        transition.setTargetNode(node2);
        node.removeBackTransition(transition);
        node.addBackTransition(transition2);
    }

    public void reinsertSfenceOperation(Transition transition, Transition transition2) {
        Node node = transition.getSourceNode();
        Node node2 = transition2.getSourceNode();
        Node node3 = transition2.getTargetNode();
        if (!node.equals(node2)) {
            System.out.println("should be the same source nodes");
        }
        transition.setSourceNode(node3);
        node.removeTransition(transition);
        node.addTransition(transition2);
    }

    public void confirmMfenceRemoval(Transition transition) {
        this.removeNode(transition.getSourceNode());
    }

    public void confirmSfenceRemoval(Transition transition) {
        this.removeNode(transition.getTargetNode());
    }

    public void setGlobalVar(int n, int n2, boolean bl) {
        this.cGs.setGlobalVar(n, bl, n2);
    }

    public Variable getVariable(Identifier identifier) {
        int n;
        int[] nArray = identifier.getDimensions();
        Expression[] expressionArray = identifier.getIndexExpressions();
        int n2 = nArray.length;
        int n3 = 0;
        for (n = 0; n < n2 - 1; ++n) {
            n3 += nArray[n] * expressionArray[n].evaluateInt((Buffer)null);
        }
        return identifier.getVariable(n3 += expressionArray[n].evaluateInt((Buffer)null));
    }
}

