/*
 * Decompiled with CFR 0.152.
 */
package controlgraph;

import buffer.Buffer;
import compiler.syntaxblocs.Assignment;
import compiler.syntaxblocs.Binary;
import compiler.syntaxblocs.Declaration;
import compiler.syntaxblocs.Declarations;
import compiler.syntaxblocs.DoStatement;
import compiler.syntaxblocs.IfStatement;
import compiler.syntaxblocs.Load;
import compiler.syntaxblocs.LoadVal;
import compiler.syntaxblocs.Operator;
import compiler.syntaxblocs.Proctype;
import compiler.syntaxblocs.Program;
import compiler.syntaxblocs.Sequence;
import compiler.syntaxblocs.Statement;
import compiler.syntaxblocs.Statements;
import compiler.syntaxblocs.Store;
import compiler.syntaxblocs.Types;
import compiler.syntaxblocs.Unary;
import compiler.syntaxblocs.Value;
import controlgraph.ControlGraph;
import controlgraph.Expression;
import controlgraph.Identifier;
import controlgraph.Node;
import controlgraph.Transition;
import controlgraph.Variable;
import controlgraph.actions.Add;
import controlgraph.actions.And;
import controlgraph.actions.Assign;
import controlgraph.actions.Div;
import controlgraph.actions.EQ;
import controlgraph.actions.LD;
import controlgraph.actions.LDDIFF;
import controlgraph.actions.LDV;
import controlgraph.actions.LE;
import controlgraph.actions.LT;
import controlgraph.actions.LockStatement;
import controlgraph.actions.MfenceStatement;
import controlgraph.actions.Mul;
import controlgraph.actions.NE;
import controlgraph.actions.Not;
import controlgraph.actions.Or;
import controlgraph.actions.ST;
import controlgraph.actions.SfenceStatement;
import controlgraph.actions.Sub;
import controlgraph.actions.UnlockStatement;
import controlgraph.actions.Val;
import java.io.File;
import java.io.FileWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import modelchecker.Memory;
import modelchecker.MemoryVariable;
import modelchecker.Process;
import options.Constants;
import options.Options;

public class ControlGraphs {
    private Program program;
    private Vector<ControlGraph> controlGraphs;
    private Vector<Variable> globalVariables;
    private Vector<Variable> initialVariableValues;

    public ControlGraphs(Program program) {
        this.program = program;
        this.controlGraphs = new Vector();
        this.globalVariables = new Vector();
        this.initialVariableValues = new Vector();
    }

    public void createControlGraphs() {
        Iterator<Proctype> iterator = this.program.getProctypesIter();
        Declarations declarations = this.program.getGlobalDeclarations();
        int n = 0;
        this.initGlobalVariables(declarations);
        Options.setNbGlobalVars(this.globalVariables.size());
        while (iterator.hasNext()) {
            Proctype proctype = iterator.next();
            Declarations declarations2 = proctype.getLocalDeclarations();
            ControlGraph controlGraph = new ControlGraph(declarations2, n, this);
            this.createControlGraph(proctype.getStatements(), controlGraph, n);
            this.controlGraphs.add(controlGraph);
            ++n;
        }
    }

    private void initGlobalVariables(Declarations declarations) {
        if (declarations == null) {
            return;
        }
        Iterator<Declaration> iterator = declarations.iterator();
        while (iterator.hasNext()) {
            Declaration declaration = iterator.next();
            String string = declaration.getName();
            for (int i = 0; i < declaration.getSize(); ++i) {
                Variable variable;
                String string2 = string + "(" + i + ")";
                if (declaration.getType().isBool()) {
                    variable = new Variable(this.globalVariables.size(), declaration.getValue(i).getBoolValue(), string2);
                } else if (declaration.getType().isInteger()) {
                    variable = new Variable(this.globalVariables.size(), declaration.getValue(i).getIntValue(), string2);
                } else {
                    throw new InternalError("Should never pass here: Global Variable must be initialized");
                }
                this.globalVariables.add(variable);
                this.initialVariableValues.add((Variable)variable.clone());
            }
        }
    }

    private void createControlGraph(Statements statements, ControlGraph controlGraph, int n) {
        Iterator<Statement> iterator = statements.getStatementsIterator();
        Node node = controlGraph.addNode();
        controlGraph.setInitial(0);
        while (iterator.hasNext()) {
            Node node2;
            Statement statement = iterator.next();
            node = node2 = this.handleStatement(statement, controlGraph, node, n, null);
        }
    }

    private Node handleStatement(Statement statement, ControlGraph controlGraph, Node node, int n, Node node2) {
        if (statement.getName().equals("Assignment")) {
            Node node3 = controlGraph.addNode();
            Assignment assignment = (Assignment)statement;
            Identifier identifier = this.getIdentifier(assignment.getIdentifier(), controlGraph);
            Expression expression = this.expression(assignment.getExpression(), controlGraph);
            Assign assign = new Assign(identifier, expression, controlGraph);
            Transition transition = expression.containsLoad() != -1 ? new Transition(node, node3, "Assignment", n, controlGraph, 2, assign) : new Transition(node, node3, "Assignment", n, controlGraph, 5, assign);
            controlGraph.addInstructions2ProgramCode(transition, statement);
            node3.incrementNbPred();
            node3.addBackTransition(transition);
            node.addTransition(transition);
            return node3;
        }
        if (statement.getName().equals("Break")) {
            Node node4 = controlGraph.addNode();
            Transition transition = new Transition(node, node4, "true", n, controlGraph, 5, new Val(true, controlGraph));
            controlGraph.addInstructions2ProgramCode(transition, statement);
            node4.incrementNbPred();
            node.addTransition(transition);
            node4.addBackTransition(transition);
            return node4;
        }
        if (statement.getName().equals("DoStatement")) {
            Node node5 = node;
            Node node6 = controlGraph.addNode();
            DoStatement doStatement = (DoStatement)statement;
            Iterator<Sequence> iterator = doStatement.getDoSequencesIterator();
            while (iterator.hasNext()) {
                node5 = node;
                Sequence sequence = iterator.next();
                compiler.syntaxblocs.Expression expression = sequence.getExpression();
                Expression expression2 = this.expression(expression, controlGraph);
                Node node7 = controlGraph.addNode();
                int n2 = expression2.type() == 21 ? 13 : (expression2.containsLoad() == -1 ? 5 : 1);
                Transition transition = new Transition(node5, node7, "do_cond", n, controlGraph, n2, expression2);
                controlGraph.addInstructions2ProgramCode(transition, expression);
                node7.addBackTransition(transition);
                node5.addTransition(transition);
                node7.incrementNbPred();
                node5 = node7;
                Statements statements = sequence.getStatements();
                Iterator<Statement> iterator2 = statements.getStatementsIterator();
                boolean bl = false;
                while (iterator2.hasNext()) {
                    Statement statement2 = iterator2.next();
                    if (statement2.getName().equals("Break")) {
                        bl = true;
                        transition = new Transition(node5, node6, "true", n, controlGraph, 5, new Val(true, controlGraph));
                        controlGraph.addInstructions2ProgramCode(transition, statement2);
                        node6.incrementNbPred();
                        node5.addTransition(transition);
                        node6.addBackTransition(transition);
                        break;
                    }
                    node5 = node7 = this.handleStatement(statement2, controlGraph, node5, n, node6);
                }
                if (bl) continue;
                transition = new Transition(node5, node, "true", n, controlGraph, 5, new Val(true, controlGraph));
                node.incrementNbPred();
                node5.addTransition(transition);
                node.addBackTransition(transition);
            }
            return node6;
        }
        if (statement.getName().equals("IfStatement")) {
            Node node8 = node;
            Node node9 = controlGraph.addNode();
            IfStatement ifStatement = (IfStatement)statement;
            Iterator<Sequence> iterator = ifStatement.getIfSequencesIterator();
            while (iterator.hasNext()) {
                node8 = node;
                Sequence sequence = iterator.next();
                compiler.syntaxblocs.Expression expression = sequence.getExpression();
                Expression expression3 = this.expression(expression, controlGraph);
                Node node10 = controlGraph.addNode();
                int n3 = expression3.type() == 21 ? 13 : (expression3.containsLoad() == -1 ? 5 : 1);
                Transition transition = new Transition(node8, node10, "true", n, controlGraph, n3, expression3);
                controlGraph.addInstructions2ProgramCode(transition, expression);
                node10.incrementNbPred();
                node8.addTransition(transition);
                node10.addBackTransition(transition);
                node8 = node10;
                Statements statements = sequence.getStatements();
                Iterator<Statement> iterator3 = statements.getStatementsIterator();
                boolean bl = false;
                while (iterator3.hasNext()) {
                    Statement statement3 = iterator3.next();
                    if (statement3.getName().equals("Break")) {
                        bl = true;
                        transition = new Transition(node8, node2, "true", n, controlGraph, 5, new Val(true, controlGraph));
                        controlGraph.addInstructions2ProgramCode(transition, statement3);
                        node2.incrementNbPred();
                        node8.addTransition(transition);
                        node2.addBackTransition(transition);
                        break;
                    }
                    node8 = node10 = this.handleStatement(statement3, controlGraph, node8, n, node2);
                }
                if (bl) continue;
                transition = new Transition(node8, node9, "true", n, controlGraph, 5, new Val(true, controlGraph));
                node9.incrementNbPred();
                node8.addTransition(transition);
                node9.addBackTransition(transition);
            }
            return node9;
        }
        if (statement.getName().equals("Skip")) {
            Node node11 = controlGraph.addNode();
            Transition transition = new Transition(node, node11, "true", n, controlGraph, 5, new Val(true, controlGraph));
            controlGraph.addInstructions2ProgramCode(transition, statement);
            node11.addBackTransition(transition);
            node11.incrementNbPred();
            node.addTransition(transition);
            return node11;
        }
        if (statement.getName().equals("Store")) {
            Node node12 = controlGraph.addNode();
            Store store = (Store)statement;
            Identifier identifier = this.getIdentifier(store.getIdentifier(), controlGraph);
            Expression expression = this.expression(store.getExpression(), controlGraph);
            ST sT = new ST(identifier, expression, controlGraph);
            Transition transition = new Transition(node, node12, "store", n, controlGraph, 0, sT);
            if (Options.getMemoryModel() == 2 && Options.getExplorationMode() == 2) {
                sT.setTransition(transition);
            }
            controlGraph.addInstructions2ProgramCode(transition, statement);
            node12.incrementNbPred();
            node.addTransition(transition);
            node12.addBackTransition(transition);
            return node12;
        }
        if (statement.getName().equals("Lock")) {
            Node node13 = controlGraph.addNode();
            Transition transition = new Transition(node, node13, "Lock", n, controlGraph, 6, new LockStatement(controlGraph));
            controlGraph.addInstructions2ProgramCode(transition, statement);
            node13.addBackTransition(transition);
            node13.incrementNbPred();
            node.addTransition(transition);
            return node13;
        }
        if (statement.getName().equals("Unlock")) {
            Node node14 = controlGraph.addNode();
            Transition transition = new Transition(node, node14, "Unlock", n, controlGraph, 7, new UnlockStatement(controlGraph));
            controlGraph.addInstructions2ProgramCode(transition, statement);
            node14.addBackTransition(transition);
            node14.incrementNbPred();
            node.addTransition(transition);
            return node14;
        }
        if (statement.getName().equals("Mfence")) {
            Node node15 = controlGraph.addNode();
            Transition transition = new Transition(node, node15, "Mfence", n, controlGraph, 4, new MfenceStatement(controlGraph));
            controlGraph.addInstructions2ProgramCode(transition, statement);
            node15.addBackTransition(transition);
            node15.incrementNbPred();
            node.addTransition(transition);
            return node15;
        }
        if (statement.getName().equals("Sfence")) {
            Node node16 = controlGraph.addNode();
            Transition transition = new Transition(node, node16, "Sfence", n, controlGraph, 14, new SfenceStatement(controlGraph));
            controlGraph.addInstructions2ProgramCode(transition, statement);
            node16.addBackTransition(transition);
            node16.incrementNbPred();
            node.addTransition(transition);
            return node16;
        }
        throw new InternalError("Should never pass here: unknown statement: " + statement.getName());
    }

    private Identifier getIdentifier(compiler.syntaxblocs.Identifier identifier, ControlGraph controlGraph) {
        int n;
        int n2 = identifier.getNbDimensions();
        int n3 = identifier.getSize();
        Expression[] expressionArray = new Expression[n2];
        compiler.syntaxblocs.Expression[] expressionArray2 = identifier.getVariableIndex();
        Variable[] variableArray = new Variable[n3];
        String string = identifier.getVariable().toString();
        for (n = 0; n < n3; ++n) {
            Variable variable = this.getGlobalVariable(string + "(" + n + ")");
            if (variable != null) {
                variableArray[n] = variable;
                continue;
            }
            variable = this.getLocalVariable(string + "(" + n + ")", controlGraph);
            if (variable != null) {
                variableArray[n] = variable;
                continue;
            }
            throw new InternalError("Should never pass here: variable " + string + "(" + n + ")" + " not found");
        }
        for (n = 0; n < n2; ++n) {
            expressionArray[n] = this.expression(expressionArray2[n], controlGraph);
        }
        Identifier identifier2 = new Identifier(identifier.getVariableName(), identifier.getVariable().isBool(), identifier.getDimensions(), n3, variableArray, expressionArray, controlGraph);
        return identifier2;
    }

    public void setLocalVar(int n, boolean bl, int n2, int n3) {
        this.controlGraphs.elementAt(n2).setLocalVar(n, bl, n3);
    }

    public void setGlobalVar(int n, boolean bl, int n2) {
        this.globalVariables.elementAt(n2).setValue(bl);
        this.globalVariables.elementAt(n2).setValue(n);
    }

    public void setGlobalVar(int n, int n2) {
        this.globalVariables.elementAt(n).setValue(n2);
    }

    public void setGlobalVar(int n, boolean bl) {
        this.globalVariables.elementAt(n).setValue(bl);
    }

    public Variable getGlobalVar(int n) {
        return this.globalVariables.elementAt(n);
    }

    private Variable getGlobalVariable(String string) {
        for (Variable variable : this.globalVariables) {
            if (!variable.getName().equals(string)) continue;
            return variable;
        }
        return null;
    }

    private Variable getLocalVariable(String string, ControlGraph controlGraph) {
        return controlGraph.getLocalVariable(string);
    }

    private Expression expression(compiler.syntaxblocs.Expression expression, ControlGraph controlGraph) {
        if (expression.getName().equals("Binary")) {
            Binary binary = (Binary)expression;
            Expression expression2 = this.expression(binary.getExpression1(), controlGraph);
            Expression expression3 = this.expression(binary.getExpression2(), controlGraph);
            String string = binary.getOperator().getOperatorString();
            if (string.equals("<=")) {
                LE lE = new LE(expression2, expression3, controlGraph);
                return lE;
            }
            if (string.equals("<")) {
                LT lT = new LT(expression2, expression3, controlGraph);
                return lT;
            }
            if (string.equals("==")) {
                EQ eQ = new EQ(expression2, expression3, controlGraph);
                return eQ;
            }
            if (string.equals(">")) {
                LT lT = new LT(expression3, expression2, controlGraph);
                return lT;
            }
            if (string.equals(">=")) {
                LE lE = new LE(expression3, expression2, controlGraph);
                return lE;
            }
            if (string.equals("+")) {
                Add add = new Add(expression2, expression3, controlGraph);
                return add;
            }
            if (string.equals("-")) {
                Sub sub = new Sub(expression2, expression3, controlGraph);
                return sub;
            }
            if (string.equals("*")) {
                Mul mul = new Mul(expression2, expression3, controlGraph);
                return mul;
            }
            if (string.equals("/")) {
                Div div = new Div(expression2, expression3, controlGraph);
                return div;
            }
            if (string.equals("!")) {
                throw new InternalError("Should never pass here: ! is not a binary operator");
            }
            if (string.equals("!=")) {
                NE nE = new NE(expression2, expression3, controlGraph);
                return nE;
            }
            if (string.equals("&&")) {
                And and = new And(expression2, expression3, controlGraph);
                return and;
            }
            if (string.equals("||")) {
                Or or = new Or(expression2, expression3, controlGraph);
                return or;
            }
            throw new InternalError("Should never pass here: unknown binary: " + binary.display());
        }
        if (expression.getName().equals("Load")) {
            Load load = (Load)expression;
            Identifier identifier = this.getIdentifier(load.getIdentifier(), controlGraph);
            Expression expression4 = this.expression(load.getExpression(), controlGraph);
            LD lD = new LD(identifier, expression4, controlGraph);
            for (Variable variable : identifier.getVariables()) {
                controlGraph.addLoadedVar(variable);
            }
            return lD;
        }
        if (expression.getName().equals("LoadVal")) {
            LoadVal loadVal = (LoadVal)expression;
            Identifier identifier = this.getIdentifier(loadVal.getIdentifier(), controlGraph);
            LDV lDV = new LDV(identifier, controlGraph);
            for (Variable variable : identifier.getVariables()) {
                controlGraph.addLoadedVar(variable);
            }
            return lDV;
        }
        if (expression.getName().equals("Identifier")) {
            return this.getIdentifier((compiler.syntaxblocs.Identifier)expression, controlGraph);
        }
        if (expression.getName().equals("Unary")) {
            Unary unary = (Unary)expression;
            Expression expression5 = this.expression(unary.getExpression(), controlGraph);
            Operator operator = unary.getOperator();
            if (operator.getOperatorString().equals("!")) {
                if (unary.getExpression().getName().equals("Load")) {
                    LD lD = (LD)expression5;
                    LDDIFF lDDIFF = new LDDIFF(lD, controlGraph);
                    return lDDIFF;
                }
                Not not = new Not(expression5, controlGraph);
                return not;
            }
        } else if (expression.getName().equals("Value")) {
            Value value = (Value)expression;
            Val val = value.getType() == Types.BOOLEAN ? new Val(value.getBoolValue(), controlGraph) : new Val(value.getIntValue(), controlGraph);
            return val;
        }
        throw new InternalError("Should never pass here: unknown expression type: " + expression.getName());
    }

    public void printDotFiles() {
        for (int i = 0; i < this.controlGraphs.size(); ++i) {
            String string = "P" + Integer.toString(i);
            this.printToDotFile(string, i);
        }
    }

    private void printToDotFile(String string, int n) {
        String string2 = Constants.TEMP_DIR + Constants.SEPARATOR + "Remmex" + Constants.SEPARATOR;
        String string3 = string2 + string + ".dot";
        String string4 = string2 + string + ".pdf";
        File file = new File(string3);
        ControlGraph controlGraph = this.controlGraphs.elementAt(n);
        controlGraph.removeStatesWithNoPred();
        String string5 = controlGraph.toDot(n);
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(string5);
            fileWriter.close();
            String string6 = Options.getDotCommand() + " -Tpdf " + string3 + " -o " + string4;
            Runtime.getRuntime().exec(string6);
        }
        catch (Exception exception) {
            System.out.println("Output writing not successfull");
            System.out.println(exception);
        }
    }

    public void deleteUseLessNodes() {
        for (ControlGraph controlGraph : this.controlGraphs) {
            if (controlGraph.deleteUseLessNodes()) {
                while (controlGraph.deleteUseLessNodes()) {
                }
            }
            controlGraph.mapControlLoc2NodeNb();
        }
    }

    public Memory initMemory() {
        Memory memory = new Memory(this.initialVariableValues.size());
        for (int i = 0; i < this.initialVariableValues.size(); ++i) {
            Variable variable = this.initialVariableValues.elementAt(i);
            MemoryVariable memoryVariable = variable.isBool() ? new MemoryVariable(variable.getBoolValue(), variable.getId()) : new MemoryVariable(variable.getIntValue(), variable.getId());
            memory.setMemory(memoryVariable);
        }
        return memory;
    }

    public Process[] initProcesses() {
        Process[] processArray = new Process[this.controlGraphs.size()];
        for (int i = 0; i < this.controlGraphs.size(); ++i) {
            ControlGraph controlGraph = this.controlGraphs.elementAt(i);
            processArray[i] = new Process(i, controlGraph.getNbLocalVars(), controlGraph);
            HashSet<MemoryVariable> hashSet = new HashSet<MemoryVariable>();
            HashSet<Variable> hashSet2 = controlGraph.getLoadedVars();
            if (hashSet2 != null) {
                for (Variable variable : hashSet2) {
                    MemoryVariable memoryVariable = variable.isBool() ? new MemoryVariable(variable.getBoolValue(), variable.getId()) : new MemoryVariable(variable.getIntValue(), variable.getId());
                    hashSet.add(memoryVariable);
                }
            }
            processArray[i].setLoadedVars(hashSet);
            MemoryVariable[] memoryVariableArray = new MemoryVariable[controlGraph.getNbLocalVars()];
            for (int j = 0; j < controlGraph.getNbLocalVars(); ++j) {
                Variable variable = controlGraph.getInitialLocalVariableAt(j);
                MemoryVariable memoryVariable = variable.isBool() ? new MemoryVariable(variable.getBoolValue(), variable.getId()) : new MemoryVariable(variable.getIntValue(), variable.getId());
                memoryVariableArray[j] = memoryVariable;
            }
            processArray[i].setLocalVars(memoryVariableArray);
        }
        return processArray;
    }

    public Buffer[] initBuffer(int n) {
        int n2;
        if (n == 1) {
            n2 = this.controlGraphs.size();
        } else if (n == 2) {
            n2 = this.controlGraphs.size() * this.globalVariables.size();
        } else {
            throw new InternalError("Should never pass here: Error initializing buffers");
        }
        Buffer[] bufferArray = new Buffer[n2];
        for (int i = 0; i < n2; ++i) {
            bufferArray[i] = new Buffer();
        }
        return bufferArray;
    }

    public Iterator<ControlGraph> getControlGraphIterator() {
        return this.controlGraphs.iterator();
    }

    public ControlGraph getControlGraph(int n) {
        if (n < this.controlGraphs.size()) {
            return this.controlGraphs.elementAt(n);
        }
        return null;
    }

    public int getGlobalVariableNumber() {
        return this.globalVariables.size();
    }
}

