/*
 * Decompiled with CFR 0.152.
 */
package controlgraph;

import controlgraph.Transition;
import java.util.Iterator;
import java.util.Vector;

public class Node {
    private int nbPred;
    private int nbNode;
    private Vector<Transition> transitions;
    private Vector<Transition> backTransitions;

    public Node(int n) {
        this.transitions = new Vector();
        this.backTransitions = new Vector();
        this.nbNode = n;
        this.nbPred = 0;
    }

    public Node() {
        this.nbNode = -1;
    }

    public boolean isFalseNode() {
        return this.nbNode == -1;
    }

    public void addTransition(Transition transition) {
        this.transitions.add(transition);
    }

    public void addBackTransition(Transition transition) {
        this.backTransitions.add(transition);
    }

    public void incrementNbPred() {
        ++this.nbPred;
    }

    public void decrementNbPred() {
        if (this.nbPred == 0) {
            // empty if block
        }
        --this.nbPred;
    }

    public int getNbPred() {
        return this.nbPred;
    }

    public int getNbNode() {
        return this.nbNode;
    }

    public int getNbSuccessors() {
        return this.transitions.size();
    }

    public String toDot() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<Transition> iterator = this.transitions.iterator();
        while (iterator.hasNext()) {
            String string = new String();
            string = string + this.nbNode + " -> ";
            Transition transition = iterator.next();
            string = string + transition.getTargetNode().getNbNode() + " [label=\"";
            string = string + transition.getLabel() + "\"]";
            string = string + '\n';
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public Iterator<Transition> getTransitionsIterator() {
        if (this.transitions != null) {
            return this.transitions.iterator();
        }
        throw new InternalError("Node Transition Iterator = null");
    }

    public Iterator<Transition> getBackTransitionsIterator() {
        return this.backTransitions.iterator();
    }

    public void removeTransition(Transition transition) {
        this.transitions.removeElement(transition);
    }

    public void removeBackTransition(Transition transition) {
        this.backTransitions.remove(transition);
    }

    public boolean containsTransitionAt(int n, String string) {
        for (Transition transition : this.transitions) {
            if (transition.getTargetNode().getNbNode() != n || !transition.getLabel().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean containsBackTransitionAt(int n, String string) {
        for (Transition transition : this.backTransitions) {
            if (transition.getSourceNode().getNbNode() != n || !transition.getLabel().equals(string)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "Node " + Integer.toString(this.nbNode);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Node)) {
            return false;
        }
        Node node = (Node)object;
        return node.nbNode == this.nbNode;
    }

    public int hashCode() {
        return this.nbNode;
    }

    public void merge(Node node) {
        if (this.nbNode == node.nbNode) {
            return;
        }
        if (this.nbNode < node.nbNode) {
            Transition transition;
            node.nbPred = 0;
            this.transitions.clear();
            Iterator<Transition> iterator = node.transitions.iterator();
            while (iterator.hasNext()) {
                transition = iterator.next();
                transition.setSourceNode(this);
                this.transitions.add(transition);
                iterator.remove();
            }
            iterator = node.backTransitions.iterator();
            while (iterator.hasNext()) {
                transition = iterator.next();
                Node node2 = transition.getSourceNode();
                if (node2 == this) continue;
                iterator.remove();
                transition.setTargetNode(this);
                this.backTransitions.add(transition);
            }
        } else {
            Transition transition;
            this.nbPred = 0;
            this.transitions.clear();
            Iterator<Transition> iterator = node.backTransitions.iterator();
            while (iterator.hasNext()) {
                transition = iterator.next();
                if (transition.getSourceNode() != this) continue;
                iterator.remove();
            }
            iterator = this.backTransitions.iterator();
            while (iterator.hasNext()) {
                transition = iterator.next();
                iterator.remove();
                transition.setTargetNode(node);
                node.addBackTransition(transition);
            }
        }
    }

    public Vector<Transition> getBackTransitions() {
        return this.backTransitions;
    }

    public Vector<Transition> getTransitions() {
        return this.transitions;
    }
}

