/*
 * Decompiled with CFR 0.152.
 */
package controlgraph;

import buffer.Buffer;
import controlgraph.Action;
import controlgraph.ControlGraph;
import controlgraph.Node;
import java.util.Vector;

public class Transition
implements Cloneable {
    private Node sourceNode;
    private Node targetNode;
    private String label;
    private int nbProcess;
    private ControlGraph cG;
    private int type;
    private Action action;
    private boolean atomicFlag = false;
    private static final int m = 1103515245;
    private static final int b = 12345;

    public Transition() {
        this.sourceNode = null;
        this.targetNode = null;
        this.label = new String();
        this.nbProcess = -1;
        this.cG = null;
        this.action = null;
        this.atomicFlag = false;
    }

    public Transition(Node node, Node node2, String string, int n, ControlGraph controlGraph, int n2, Action action) {
        this.sourceNode = node;
        this.targetNode = node2;
        this.label = new String(string);
        this.nbProcess = n;
        this.cG = controlGraph;
        this.type = n2;
        this.action = action;
        this.atomicFlag = false;
    }

    public void setAtomicFlag(boolean bl) {
        this.atomicFlag = bl;
    }

    public boolean getAtomicFlag() {
        return this.atomicFlag;
    }

    public void setControlGraph(ControlGraph controlGraph) {
        this.cG = controlGraph;
    }

    public ControlGraph getControlGraph() {
        return this.cG;
    }

    public Action getAction() {
        return this.action;
    }

    public String toString() {
        if (this.sourceNode != null && this.targetNode != null && this.label != null) {
            return this.sourceNode.getNbNode() + " -" + this.action.toString() + "> " + this.targetNode.getNbNode();
        }
        return new String();
    }

    public String getLabelGlobalDot() {
        if (this.label != null) {
            return "p" + this.nbProcess + ": " + this.action.evaluatedString();
        }
        return "p" + this.nbProcess;
    }

    public int getNbProcess() {
        return this.nbProcess;
    }

    public Node getTargetNode() {
        return this.targetNode;
    }

    public Node getSourceNode() {
        return this.sourceNode;
    }

    public String getLabel() {
        return this.action.toString();
    }

    public void setTargetNode(Node node) {
        this.targetNode = node;
    }

    public void setSourceNode(Node node) {
        this.sourceNode = node;
    }

    public void setNbProcess(int n) {
        this.nbProcess = n;
    }

    public int getType() {
        return this.type;
    }

    public int hashCode() {
        int n = this.nbProcess;
        n = n * 1103515245 + 12345 + this.sourceNode.getNbNode();
        n = n * 1103515245 + 12345 + this.targetNode.getNbNode();
        n = n * 1103515245 + 12345 + this.action.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Transition)) {
            return false;
        }
        Transition transition = (Transition)object;
        if (this.nbProcess != transition.nbProcess) {
            return false;
        }
        if (this.sourceNode.getNbNode() != transition.sourceNode.getNbNode()) {
            return false;
        }
        if (this.targetNode.getNbNode() != transition.targetNode.getNbNode()) {
            return false;
        }
        return this.action.equals(transition.action);
    }

    public Object clone() {
        Transition transition;
        try {
            transition = (Transition)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("At least one of the subclasses ofTransition does not implement cloneable");
        }
        transition.action = (Action)this.action.clone();
        return transition;
    }

    public boolean isTrue(Buffer buffer) {
        return this.action.isTrue(buffer);
    }

    public boolean isTrue(Vector<Buffer> vector) {
        return this.action.isTrue(vector);
    }

    public void apply(Buffer buffer) {
        this.action.apply(buffer);
    }

    public int containsLoad() {
        return this.action.containsLoad();
    }

    public boolean containsLoadAt(int n) {
        return this.action.containsLoadAt(n);
    }

    public int type() {
        return this.action.type();
    }

    public boolean bufferModified() {
        return this.action.bufferModified();
    }
}

