/*
 * Decompiled with CFR 0.152.
 */
package controlgraph;

import controlgraph.Identifier;

public class Variable
implements Cloneable {
    private final boolean isBool;
    private int intValue = 0;
    private boolean boolValue = false;
    private final int id;
    private Identifier identifier = null;
    private String varName = null;

    private Variable(int n, String string, boolean bl) {
        this.id = n;
        this.varName = string;
        this.isBool = bl;
    }

    public Variable(int n, int n2, String string) {
        this(n, string, false);
        this.intValue = n2;
    }

    public Variable(int n, boolean bl, String string) {
        this(n, string, true);
        this.boolValue = bl;
    }

    public void setValue(int n) {
        if (this.isBool) {
            throw new InternalError("Can't set an intValue to a bool variable");
        }
        this.intValue = n;
    }

    public void setValue(boolean bl) {
        if (!this.isBool) {
            throw new InternalError("Can't set a boolean value to an int variable");
        }
        this.boolValue = bl;
    }

    public void setIdentifier(Identifier identifier) {
        this.identifier = identifier;
    }

    public boolean isBool() {
        return this.isBool;
    }

    public boolean getBoolValue() {
        if (!this.isBool) {
            throw new InternalError("Can't get a boolean value of an int variable");
        }
        return this.boolValue;
    }

    public int getIntValue() {
        if (this.isBool) {
            throw new InternalError("Can't get an int value of a boolean variable");
        }
        return this.intValue;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.varName;
    }

    public String toString() {
        return this.getName();
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public Object clone() {
        Variable variable;
        try {
            variable = (Variable)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("At least one sub-class of Variabledoes not support cloneable");
        }
        variable.identifier = this.identifier;
        variable.varName = new String(this.varName);
        return variable;
    }
}

