/*
 * Decompiled with CFR 0.152.
 */
package controlgraph.actions;

import buffer.Buffer;
import buffer.BufferStoreContent;
import controlgraph.Action;
import controlgraph.ControlGraph;
import controlgraph.Expression;
import controlgraph.Identifier;
import controlgraph.Variable;
import controlgraph.actions.LDV;
import java.util.Vector;

public class Assign
extends Action {
    private Identifier identifier;
    private Expression expression;
    private Variable lV;

    public Assign(Identifier identifier, Expression expression, ControlGraph controlGraph) {
        super(new String(identifier.getName() + "=" + expression.toString()), controlGraph);
        this.identifier = identifier;
        this.expression = expression;
        this.lV = null;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setLV(Variable variable) {
        this.lV = variable;
    }

    public void setLV(int n) {
        this.lV = this.identifier.getVariable(n);
    }

    public void setLV(int[] nArray) {
        this.lV = this.identifier.getVariable(nArray);
    }

    @Override
    public void apply(Buffer buffer) {
        this.lV = this.cG.getVariable(this.identifier);
        if (this.lV.isBool()) {
            this.lV.setValue(this.expression.evaluateBool(buffer));
        } else {
            this.lV.setValue(this.expression.evaluateInt(buffer));
        }
    }

    public void apply(BufferStoreContent bufferStoreContent) {
        this.lV = this.cG.getVariable(this.identifier);
        if (this.lV.isBool()) {
            this.lV.setValue(bufferStoreContent.boolValue());
        } else {
            this.lV.setValue(bufferStoreContent.intValue());
        }
    }

    @Override
    public int containsLoad() {
        return this.expression.containsLoad();
    }

    @Override
    public Object clone() {
        Assign assign = (Assign)super.clone();
        assign.identifier = (Identifier)this.identifier.clone();
        assign.expression = (Expression)this.expression.clone();
        if (this.lV != null) {
            assign.lV = (Variable)this.lV.clone();
        }
        return assign;
    }

    @Override
    public String evaluatedString() {
        return new String(this.lV.toString() + "=" + this.expression.evaluatedString());
    }

    @Override
    public boolean containsLoadAt(int n) {
        return this.expression.containsLoadAt(n);
    }

    @Override
    public boolean isTrue(Buffer buffer) {
        return true;
    }

    @Override
    public int type() {
        return 5;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public int loadsVar() {
        return ((LDV)this.expression).getVarId();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Assign)) {
            return false;
        }
        Assign assign = (Assign)object;
        if (!this.identifier.equals(assign.identifier)) {
            return false;
        }
        return this.expression.equals(assign.expression);
    }

    @Override
    public boolean isTrue(Vector<Buffer> vector) {
        return true;
    }

    @Override
    public int hashCode() {
        int n = this.lV != null ? this.lV.getId() : this.identifier.getName().hashCode();
        n = n * 1103515245 + 12345 + this.expression.hashCode();
        return n;
    }

    @Override
    public boolean bufferModified() {
        return this.expression.bufferModified();
    }
}

