/*
 * Decompiled with CFR 0.152.
 */
package controlgraph.actions;

import buffer.Buffer;
import controlgraph.ControlGraph;
import controlgraph.Expression;
import java.util.Vector;

public class Div
extends Expression {
    private Expression term1;
    private Expression term2;

    public Div(Expression expression, Expression expression2, ControlGraph controlGraph) {
        super(new String("(" + expression.toString() + "/" + expression2.toString()) + ")", controlGraph);
        this.term1 = expression;
        this.term2 = expression2;
    }

    @Override
    public boolean evaluateBool(Buffer buffer) {
        throw new InternalError("Div is not a boolean expression");
    }

    @Override
    public boolean isTrue(Buffer buffer) {
        return true;
    }

    @Override
    public int evaluateInt(Buffer buffer) {
        return this.term1.evaluateInt(buffer) / this.term2.evaluateInt(buffer);
    }

    @Override
    public int containsLoad() {
        return -1;
    }

    @Override
    public boolean containsLoadAt(int n) {
        return false;
    }

    @Override
    public Object clone() {
        Div div = (Div)super.clone();
        div.term1 = (Expression)this.term1.clone();
        div.term2 = (Expression)this.term2.clone();
        return div;
    }

    @Override
    public String evaluatedString() {
        return new String("(" + this.term1.evaluatedString() + "/" + this.term2.evaluatedString() + ")");
    }

    @Override
    public int type() {
        return 20;
    }

    @Override
    public void apply(Buffer buffer) {
        throw new InternalError("Div cannot be applied");
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Div)) {
            return false;
        }
        Div div = (Div)object;
        if (!this.term1.equals(div.term1)) {
            return false;
        }
        return this.term2.equals(div.term2);
    }

    @Override
    public boolean isTrue(Vector<Buffer> vector) {
        throw new InternalError("Div cannot be checked for truth using several buffers");
    }

    @Override
    public int evaluateInt(Vector<Buffer> vector) {
        throw new InternalError("Div cannot be evaluated using several buffers");
    }

    @Override
    public boolean evaluateBool(Vector<Buffer> vector) {
        throw new InternalError("Div cannot be evaluated using several buffers");
    }

    @Override
    public int hashCode() {
        return this.term1.hashCode() ^ this.term2.hashCode();
    }

    @Override
    public boolean bufferModified() {
        return false;
    }
}

