/*
 * Decompiled with CFR 0.152.
 */
package controlgraph.actions;

import buffer.Buffer;
import buffer.BufferStoreContent;
import controlgraph.ControlGraph;
import controlgraph.Expression;
import controlgraph.Identifier;
import controlgraph.Transition;
import controlgraph.Variable;
import java.util.Vector;

public class LD
extends Expression {
    private Identifier identifier;
    private Variable lV;
    private Expression expression;
    private Transition t;
    private boolean bufferModified = false;

    public LD(Identifier identifier, Expression expression, ControlGraph controlGraph) {
        super(new String("Load(" + identifier.toString() + "," + expression.toString() + ")"), controlGraph);
        this.identifier = identifier;
        this.expression = expression;
    }

    @Override
    public boolean bufferModified() {
        return this.bufferModified;
    }

    public void setBufferModified(boolean bl) {
        this.bufferModified = bl;
    }

    public Variable getGlobalVariable() {
        if (this.lV != null) {
            return this.lV;
        }
        throw new InternalError("Variable must be initialized before");
    }

    public void setTransition(Transition transition) {
        this.t = transition;
    }

    public Transition getTransition() {
        return this.t;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setLV(Variable variable) {
        this.lV = variable;
    }

    public void setLV(int n) {
        this.lV = this.identifier.getVariable(n);
    }

    public void setLV(int[] nArray) {
        this.lV = this.identifier.getVariable(nArray);
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public int evaluateInt(Buffer buffer) {
        throw new InternalError("LD is not integer, but boolean");
    }

    @Override
    public boolean isTrue(Buffer buffer) {
        return this.evaluateBool(buffer);
    }

    @Override
    public boolean evaluateBool(Buffer buffer) {
        this.lV = this.cG.getVariable(this.identifier);
        if (this.lV.isBool()) {
            return this.evaluate4Bool(buffer);
        }
        return this.evaluate4Int(buffer);
    }

    private boolean evaluate4Bool(Buffer buffer) {
        BufferStoreContent bufferStoreContent;
        Buffer buffer2;
        boolean bl = this.expression.evaluateBool(buffer);
        boolean bl2 = false;
        if (this.lV.getBoolValue() == bl) {
            bl2 = true;
        }
        this.bufferModified = !(buffer2 = buffer.getCorrespondingBuffer(bufferStoreContent = new BufferStoreContent(this.lV.getId(), this.lV.isBool(), bl, 0, this.lV.getName(), null), bl2)).isEmpty() && !buffer.equals(buffer2);
        buffer.setAutomaton(buffer2.getAutomaton());
        return !buffer.isEmpty();
    }

    private boolean evaluate4Int(Buffer buffer) {
        BufferStoreContent bufferStoreContent;
        Buffer buffer2;
        int n = this.expression.evaluateInt(buffer);
        boolean bl = false;
        if (this.lV.getIntValue() == n) {
            bl = true;
        }
        this.bufferModified = !(buffer2 = buffer.getCorrespondingBuffer(bufferStoreContent = new BufferStoreContent(this.lV.getId(), this.lV.isBool(), false, n, this.lV.getName(), null), bl)).isEmpty() && !buffer.equals(buffer2);
        buffer.setAutomaton(buffer2.getAutomaton());
        return !buffer.isEmpty();
    }

    @Override
    public int containsLoad() {
        return this.lV == null ? 1000 : this.lV.getId();
    }

    @Override
    public boolean containsLoadAt(int n) {
        if (this.lV == null) {
            throw new InternalError("must initialize variable before");
        }
        return this.lV.getId() == n;
    }

    @Override
    public Object clone() {
        LD lD = (LD)super.clone();
        lD.identifier = (Identifier)this.identifier.clone();
        lD.expression = (Expression)this.expression.clone();
        if (this.lV != null) {
            lD.lV = (Variable)this.lV.clone();
        }
        return lD;
    }

    @Override
    public String evaluatedString() {
        return new String("Load(" + this.lV.toString() + "," + this.expression.evaluatedString() + ")");
    }

    @Override
    public int type() {
        return 20;
    }

    @Override
    public void apply(Buffer buffer) {
        throw new InternalError("Load cannot be applied");
    }

    public int getVarId() {
        this.lV = this.cG.getVariable(this.identifier);
        return this.lV.getId();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof LD)) {
            return false;
        }
        LD lD = (LD)object;
        if (!this.identifier.equals(lD.identifier)) {
            return false;
        }
        return this.expression.equals(lD.expression);
    }

    @Override
    public boolean isTrue(Vector<Buffer> vector) {
        throw new InternalError("Load cannot be checked for truth using several buffers");
    }

    @Override
    public int evaluateInt(Vector<Buffer> vector) {
        throw new InternalError("LD cannot be evaluated using several buffers");
    }

    @Override
    public boolean evaluateBool(Vector<Buffer> vector) {
        this.lV = this.cG.getVariable(this.identifier);
        Buffer buffer = vector.elementAt(this.lV.getId());
        if (this.lV.isBool()) {
            return this.evaluate4Bool(buffer);
        }
        return this.evaluate4Int(buffer);
    }

    @Override
    public int hashCode() {
        int n = this.lV != null ? this.lV.getId() : this.identifier.getName().hashCode();
        n = n * 1103515245 + 12345 + this.expression.hashCode();
        return n;
    }
}

