/*
 * Decompiled with CFR 0.152.
 */
package controlgraph.actions;

import buffer.Buffer;
import controlgraph.ControlGraph;
import controlgraph.Expression;
import java.util.Vector;

public class NE
extends Expression {
    Expression term1;
    Expression term2;

    public NE(Expression expression, Expression expression2, ControlGraph controlGraph) {
        super(new String(expression.toString() + "!=" + expression2.toString()), controlGraph);
        this.term1 = expression;
        this.term2 = expression2;
    }

    @Override
    public boolean evaluateBool(Buffer buffer) {
        return this.term1.evaluateInt(buffer) != this.term2.evaluateInt(buffer);
    }

    @Override
    public boolean isTrue(Buffer buffer) {
        return this.evaluateBool(buffer);
    }

    @Override
    public int evaluateInt(Buffer buffer) {
        throw new InternalError("NE is not integer");
    }

    @Override
    public int containsLoad() {
        return -1;
    }

    @Override
    public boolean containsLoadAt(int n) {
        return false;
    }

    @Override
    public Object clone() {
        NE nE = (NE)super.clone();
        nE.term1 = (Expression)this.term1.clone();
        nE.term2 = (Expression)this.term2.clone();
        return nE;
    }

    @Override
    public String evaluatedString() {
        return new String(this.term1.evaluatedString() + "!=" + this.term2.evaluatedString());
    }

    @Override
    public int type() {
        return 21;
    }

    @Override
    public void apply(Buffer buffer) {
        throw new InternalError("NE cannot be applied");
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof NE)) {
            return false;
        }
        NE nE = (NE)object;
        if (!this.term1.equals(nE.term1)) {
            return false;
        }
        return this.term2.equals(nE.term2);
    }

    @Override
    public boolean isTrue(Vector<Buffer> vector) {
        return this.evaluateBool(vector);
    }

    @Override
    public int evaluateInt(Vector<Buffer> vector) {
        throw new InternalError("NE cannot be evaluated integer");
    }

    @Override
    public boolean evaluateBool(Vector<Buffer> vector) {
        return this.term1.evaluateInt(vector) != this.term2.evaluateInt(vector);
    }

    @Override
    public int hashCode() {
        return this.term1.hashCode() ^ this.term2.hashCode();
    }

    @Override
    public boolean bufferModified() {
        return false;
    }
}

