/*
 * Decompiled with CFR 0.152.
 */
package controlgraph.actions;

import buffer.Buffer;
import controlgraph.ControlGraph;
import controlgraph.Expression;
import java.util.Vector;

public class Or
extends Expression {
    private Expression term1;
    private Expression term2;

    public Or(Expression expression, Expression expression2, ControlGraph controlGraph) {
        super(new String("(" + expression.toString() + "||" + expression2.toString()) + ")", controlGraph);
        this.term1 = expression;
        this.term2 = expression2;
    }

    @Override
    public int evaluateInt(Buffer buffer) {
        throw new InternalError("Or is not integer");
    }

    @Override
    public boolean isTrue(Buffer buffer) {
        Buffer buffer2 = (Buffer)buffer.clone();
        Buffer buffer3 = (Buffer)buffer.clone();
        boolean bl = this.term1.evaluateBool(buffer2);
        boolean bl2 = this.term2.evaluateBool(buffer3);
        buffer.setAutomaton(Buffer.unionAutomaton(buffer2, buffer3));
        return bl || bl2;
    }

    @Override
    public boolean evaluateBool(Buffer buffer) {
        return this.isTrue(buffer);
    }

    @Override
    public int containsLoad() {
        if (this.term1.containsLoad() != -1) {
            return this.term1.containsLoad();
        }
        return this.term2.containsLoad();
    }

    @Override
    public boolean containsLoadAt(int n) {
        return this.term1.containsLoadAt(n) || this.term2.containsLoadAt(n);
    }

    @Override
    public Object clone() {
        Or or = (Or)super.clone();
        or.term1 = (Expression)this.term1.clone();
        or.term2 = (Expression)this.term2.clone();
        return or;
    }

    @Override
    public String evaluatedString() {
        return new String("(" + this.term1.evaluatedString() + "||" + this.term2.evaluatedString() + ")");
    }

    @Override
    public int type() {
        return 21;
    }

    @Override
    public void apply(Buffer buffer) {
        throw new InternalError("Or cannot be applied");
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Or)) {
            return false;
        }
        Or or = (Or)object;
        if (!this.term1.equals(or.term1)) {
            return false;
        }
        return this.term2.equals(or.term2);
    }

    @Override
    public boolean isTrue(Vector<Buffer> vector) {
        return this.evaluateBool(vector);
    }

    @Override
    public int evaluateInt(Vector<Buffer> vector) {
        throw new InternalError("Or cannot be evaluated integer");
    }

    @Override
    public boolean evaluateBool(Vector<Buffer> vector) {
        Vector<Buffer> vector2 = new Vector<Buffer>();
        Vector<Buffer> vector3 = new Vector<Buffer>();
        for (Buffer buffer : vector) {
            vector2.add((Buffer)buffer.clone());
            vector3.add((Buffer)buffer.clone());
        }
        boolean bl = this.term1.evaluateBool(vector2);
        boolean bl2 = this.term2.evaluateBool(vector3);
        for (int i = 0; i < vector.size(); ++i) {
            Buffer buffer;
            buffer = vector2.elementAt(i);
            Buffer buffer2 = vector3.elementAt(i);
            vector.elementAt(i).setAutomaton(Buffer.unionAutomaton(buffer, buffer2));
        }
        return bl || bl2;
    }

    @Override
    public int hashCode() {
        return this.term1.hashCode() ^ this.term2.hashCode();
    }

    @Override
    public boolean bufferModified() {
        return this.term1.bufferModified() || this.term2.bufferModified();
    }
}

