/*
 * Decompiled with CFR 0.152.
 */
package controlgraph.actions;

import buffer.Buffer;
import controlgraph.ControlGraph;
import controlgraph.Expression;
import java.util.Vector;

public class Sub
extends Expression {
    Expression term1;
    Expression term2;

    public Sub(Expression expression, Expression expression2, ControlGraph controlGraph) {
        super(new String("(" + expression.toString() + "-" + expression2.toString()) + ")", controlGraph);
        this.term1 = expression;
        this.term2 = expression2;
    }

    @Override
    public boolean evaluateBool(Buffer buffer) {
        throw new InternalError("Sub is not a boolean expression");
    }

    @Override
    public boolean isTrue(Buffer buffer) {
        return true;
    }

    @Override
    public int evaluateInt(Buffer buffer) {
        return this.term1.evaluateInt(buffer) - this.term2.evaluateInt(buffer);
    }

    @Override
    public int containsLoad() {
        return -1;
    }

    @Override
    public boolean containsLoadAt(int n) {
        return false;
    }

    @Override
    public Object clone() {
        Sub sub = (Sub)super.clone();
        sub.term1 = (Expression)this.term1.clone();
        sub.term2 = (Expression)this.term2.clone();
        return sub;
    }

    @Override
    public String evaluatedString() {
        return new String("(" + this.term1.evaluatedString() + "-" + this.term2.evaluatedString() + ")");
    }

    @Override
    public int type() {
        return 20;
    }

    @Override
    public void apply(Buffer buffer) {
        throw new InternalError("Sub cannot be applied");
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Sub)) {
            return false;
        }
        Sub sub = (Sub)object;
        if (!this.term1.equals(sub.term1)) {
            return false;
        }
        return this.term2.equals(sub.term2);
    }

    @Override
    public boolean isTrue(Vector<Buffer> vector) {
        throw new InternalError("Sub cannot be checked for truth using several buffers");
    }

    @Override
    public int evaluateInt(Vector<Buffer> vector) {
        return this.evaluateInt((Buffer)null);
    }

    @Override
    public boolean evaluateBool(Vector<Buffer> vector) {
        throw new InternalError("Sub cannot be evaluated using several buffers");
    }

    @Override
    public int hashCode() {
        return this.term1.hashCode() ^ this.term2.hashCode();
    }

    @Override
    public boolean bufferModified() {
        return false;
    }
}

