/*
 * Decompiled with CFR 0.152.
 */
package controlgraph.actions;

import buffer.Buffer;
import controlgraph.ControlGraph;
import controlgraph.Expression;
import java.util.Vector;

public class Val
extends Expression {
    private boolean isBool;
    private int intValue;
    private boolean boolValue;

    public Val(boolean bl, ControlGraph controlGraph) {
        super(Boolean.toString(bl), controlGraph);
        this.isBool = true;
        this.boolValue = bl;
        this.intValue = 0;
    }

    public Val(int n, ControlGraph controlGraph) {
        super(Integer.toString(n), controlGraph);
        this.isBool = false;
        this.boolValue = false;
        this.intValue = n;
    }

    @Override
    public boolean evaluateBool(Buffer buffer) {
        if (this.isBool) {
            return this.boolValue;
        }
        throw new InternalError("IntValue is not a boolean expression");
    }

    @Override
    public boolean isTrue(Buffer buffer) {
        if (this.isBool) {
            return this.boolValue;
        }
        return this.intValue == 0;
    }

    @Override
    public int evaluateInt(Buffer buffer) {
        if (!this.isBool) {
            return this.intValue;
        }
        throw new InternalError("BoolValue is not an integer expression");
    }

    @Override
    public int containsLoad() {
        return -1;
    }

    @Override
    public boolean containsLoadAt(int n) {
        return false;
    }

    @Override
    public Object clone() {
        Val val = (Val)super.clone();
        val.boolValue = this.boolValue;
        val.intValue = this.intValue;
        val.isBool = this.isBool;
        return val;
    }

    @Override
    public void apply(Buffer buffer) {
        throw new InternalError("Val cannot be applied");
    }

    @Override
    public String evaluatedString() {
        return this.toString();
    }

    @Override
    public int type() {
        return 20;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Val)) {
            return false;
        }
        Val val = (Val)object;
        if (this.isBool != val.isBool) {
            return false;
        }
        if (this.boolValue != val.boolValue) {
            return false;
        }
        return this.intValue == val.intValue;
    }

    @Override
    public boolean isTrue(Vector<Buffer> vector) {
        return this.evaluateBool(vector);
    }

    @Override
    public int evaluateInt(Vector<Buffer> vector) {
        return this.evaluateInt((Buffer)null);
    }

    @Override
    public boolean evaluateBool(Vector<Buffer> vector) {
        return this.evaluateBool((Buffer)null);
    }

    @Override
    public int hashCode() {
        return this.isBool ? (this.boolValue ? 1 : 0) : this.intValue;
    }

    @Override
    public boolean bufferModified() {
        return false;
    }
}

