/*
 * Decompiled with CFR 0.152.
 */
package modelchecker;

import buffer.BufferStoreContent;
import controlgraph.ControlGraphs;
import controlgraph.Transition;
import controlgraph.Variable;
import java.io.File;
import java.io.FileWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import modelchecker.ErrorState;
import modelchecker.Explorer;
import modelchecker.LockGlobal;
import modelchecker.Memory;
import modelchecker.MemoryVariable;
import modelchecker.Process;
import options.Constants;
import options.Options;

public abstract class AbstractState
implements Cloneable {
    protected Memory memory;
    protected Process[] processes;
    protected LockGlobal lock;
    protected Vector<AbstractState> succ = null;
    protected AbstractState pred;
    private static volatile int countErrors = 0;
    protected static volatile int countDeadlocks = 0;
    protected volatile int nbDeadlock = -1;
    protected volatile AbstractState equalState = null;
    protected volatile HashSet<Transition> sleepSet;
    protected Transition tFollowed = null;
    protected int advancedProcess = Integer.MIN_VALUE;
    protected int operationType = -1;
    protected int stateType = 4;
    protected BufferStoreContent bSC = null;
    protected int nbGlobalState;
    protected String text;
    protected boolean errorFlag = false;
    protected boolean deadlockFlag = false;
    protected boolean errorTraceState = false;
    protected boolean possibleNoErrorEnding = false;
    protected int errorDistance = -1;
    protected AbstractState succToErrorStateMinimalDistance = null;
    protected static int commitCounter = 0;
    protected static int otherCounter = 0;
    protected boolean fromDelayFlag = false;

    public abstract int hashCode();

    public abstract int setStateNumbersAntText(int var1, boolean var2);

    protected abstract boolean computeErrorTraces();

    protected abstract String dotNodeTextErrorTraces();

    protected abstract void printCurrentTrace();

    public AbstractState(AbstractState abstractState, Memory memory, Process[] processArray) {
        this.memory = memory;
        this.processes = processArray;
        this.pred = abstractState;
        this.sleepSet = new HashSet();
        this.lock = new LockGlobal();
        this.errorFlag = false;
        this.deadlockFlag = false;
        this.nbDeadlock = -1;
        this.fromDelayFlag = false;
    }

    public void setFromDelayFlag(boolean bl) {
        this.fromDelayFlag = bl;
    }

    public boolean getFromDelayFlag() {
        return this.fromDelayFlag;
    }

    public int getOperationType() {
        return this.operationType;
    }

    public HashSet<Transition> getSleepSet() {
        return this.sleepSet;
    }

    public void addToSleepSet(Transition transition) {
        this.sleepSet.add(transition);
    }

    public void removeFromSleepSet(Collection<Transition> collection) {
        this.sleepSet.removeAll(collection);
    }

    public BufferStoreContent getBufferStoreContent() {
        return this.bSC;
    }

    public Memory getMemory() {
        return this.memory;
    }

    public Process[] getProcesses() {
        return this.processes;
    }

    public void setEqualState(AbstractState abstractState) {
        this.equalState = abstractState;
    }

    public AbstractState getEqualState() {
        return this.equalState;
    }

    public int getAdvancedProc() {
        return this.advancedProcess;
    }

    public void addSuccessor(AbstractState abstractState) {
        if (this.succ == null) {
            this.succ = new Vector();
        }
        this.succ.add(abstractState);
    }

    public void setStateType(int n) {
        this.stateType = n;
    }

    public void setOperationFlag(int n) {
        this.operationType = n;
    }

    public Object clone() {
        AbstractState abstractState;
        try {
            abstractState = (AbstractState)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("At least one subclass of AbstractStatedoes not implement Cloneable");
        }
        abstractState.processes = new Process[this.processes.length];
        for (int i = 0; i < this.processes.length; ++i) {
            abstractState.processes[i] = (Process)this.processes[i].clone();
        }
        abstractState.memory = (Memory)this.memory.clone();
        if (this.succ != null) {
            abstractState.succ = new Vector();
            Iterator<AbstractState> iterator = this.succ.iterator();
            while (iterator.hasNext()) {
                abstractState.succ.add(iterator.next());
            }
        }
        abstractState.pred = this.pred;
        if (this.bSC != null) {
            abstractState.bSC = (BufferStoreContent)this.bSC.clone();
        }
        if (this.equalState != null) {
            abstractState.equalState = this.equalState;
        }
        abstractState.lock = (LockGlobal)this.lock.clone();
        if (this.tFollowed != null) {
            abstractState.tFollowed = (Transition)this.tFollowed.clone();
        }
        this.errorFlag = false;
        this.deadlockFlag = false;
        this.nbDeadlock = -1;
        return abstractState;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AbstractState)) {
            return false;
        }
        AbstractState abstractState = (AbstractState)object;
        if (this.processes.length != abstractState.processes.length) {
            return false;
        }
        if (!this.lock.equals(abstractState.lock)) {
            return false;
        }
        if (!this.memory.equals(abstractState.memory)) {
            return false;
        }
        for (int i = 0; i < this.processes.length; ++i) {
            if (this.processes[i].equals(abstractState.processes[i])) continue;
            return false;
        }
        return true;
    }

    protected void printStackTrace() {
        String string = "(";
        for (int i = 0; i < this.processes.length; ++i) {
            string = string + this.processes[i].getControlLocation();
            string = string + ",";
        }
        string = string + this.memory.printMemory() + ")";
        System.out.println(string);
        if (this.pred != null) {
            this.pred.printStackTrace();
        }
    }

    protected boolean isInT(Transition transition, HashSet<Transition> hashSet, HashSet<Transition> hashSet2) {
        if (hashSet == null) {
            return !hashSet2.contains(transition);
        }
        if (!hashSet.contains(transition)) {
            return false;
        }
        return !hashSet2.contains(transition);
    }

    protected boolean includedOrEqual() {
        return this.stateType == 2 || this.stateType == 1 || this.stateType == 3;
    }

    protected void removeTransitions(int n, HashSet<Transition> hashSet) {
        Iterator<Transition> iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Transition transition = iterator.next();
            if (transition.getNbProcess() != n) continue;
            iterator.remove();
        }
    }

    protected void removeLoadTransitions(int n, HashSet<Transition> hashSet) {
        Iterator<Transition> iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Transition transition = iterator.next();
            if (transition.getNbProcess() != n || transition.containsLoad() == -1) continue;
            iterator.remove();
        }
    }

    protected void pushGlobalMem2ControlGraphsMem(ControlGraphs controlGraphs) {
        int n = this.memory.getNbVars();
        for (int i = 0; i < n; ++i) {
            MemoryVariable memoryVariable = this.memory.getMemoryVariableAt(i);
            if (memoryVariable.isBool()) {
                controlGraphs.setGlobalVar(i, memoryVariable.boolValue());
                continue;
            }
            controlGraphs.setGlobalVar(i, memoryVariable.intValue());
        }
    }

    protected Memory popGlobalMemFromControlGraphsMem(ControlGraphs controlGraphs) {
        int n = this.memory.getNbVars();
        Memory memory = new Memory(n);
        for (int i = 0; i < n; ++i) {
            Variable variable = controlGraphs.getGlobalVar(i);
            MemoryVariable memoryVariable = variable.isBool() ? new MemoryVariable(variable.getBoolValue(), variable.getId()) : new MemoryVariable(variable.getIntValue(), variable.getId());
            memory.setMemory(memoryVariable);
        }
        return memory;
    }

    public AbstractState getPredecessor() {
        return this.pred;
    }

    public int getGlobalStateNb() {
        return this.nbGlobalState;
    }

    public void globalDot() {
        String string = "digraph Global {\n";
        string = string + "initial -> 0\n";
        string = string + "initial [shape=plaintext, label=\"\"];\n";
        string = string + this.dotNodeText();
        string = string + "}";
        File file = new File(Constants.TEMP_DIR + Constants.SEPARATOR + "Remmex" + Constants.SEPARATOR + "global.dot");
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(string);
            fileWriter.close();
            String string2 = Options.getDotCommand() + " -Tpdf " + Constants.TEMP_DIR + Constants.SEPARATOR + "Remmex" + Constants.SEPARATOR + "global.dot " + "-o " + Constants.TEMP_DIR + Constants.SEPARATOR + "Remmex" + Constants.SEPARATOR + "global.pdf";
            Runtime.getRuntime().exec(string2);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public String dotNodeText() {
        String string = this.nbGlobalState + " [label=\"" + this.text + "\"";
        if (this.stateType == 2 || this.stateType == 3 || this.stateType == 1) {
            string = string + ",shape=box";
        }
        if (this.errorFlag || this.deadlockFlag) {
            string = string + ",style=filled,color=red";
        }
        string = string + "];\n";
        if (this.succ != null) {
            for (AbstractState abstractState : this.succ) {
                if (abstractState == null) continue;
                string = string + this.nbGlobalState + " -> " + abstractState.getGlobalStateNb();
                if (Options.getExplorationMode() != 0) {
                    // empty if block
                }
                if (abstractState.tFollowed != null) {
                    string = string + " [label = \"" + abstractState.tFollowed.getLabelGlobalDot() + "\"]";
                }
                string = string + "\n";
                string = string + abstractState.dotNodeText();
            }
        }
        return string;
    }

    public boolean isErrorState() {
        for (ErrorState errorState : Explorer.errorStates) {
            if (!errorState.isErrorState(this)) continue;
            ++countErrors;
            this.errorFlag = true;
            return true;
        }
        return false;
    }

    public static int getNbErrors() {
        return countErrors;
    }

    public static int getNbDeadlocks() {
        return countDeadlocks;
    }

    public void printErrorTraces() {
        this.computeErrorTraces();
        this.globalDotErrorTraces();
    }

    public void globalDotErrorTraces() {
        String string;
        if (countErrors == 0) {
            string = "digraph Global {}";
        } else {
            string = "digraph Global {\n";
            string = string + "initial -> 0\n";
            string = string + "initial [shape=plaintext, label=\"\"];\n";
            string = string + this.dotNodeTextErrorTraces();
            string = string + "}";
        }
        File file = new File("/tmp/Remmex/global_error_traces.dot");
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(string);
            fileWriter.close();
            String string2 = "dot -Tpdf /tmp/Remmex/global_error_traces.dot -o /tmp/Remmex/global_error_traces.pdf";
            Runtime.getRuntime().exec(string2);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public static void resetErrorCounting() {
        countErrors = 0;
        countDeadlocks = 0;
    }

    public String currentTraceDot() {
        int n;
        int n2 = 0;
        AbstractState abstractState = this;
        while (abstractState.pred != null) {
            abstractState = abstractState.pred;
            ++n2;
        }
        abstractState = this;
        String string = "digraph Global {\n";
        string = string + "initial -> 0\n";
        string = string + "initial [shape=plaintext, label=\"\"];\n";
        string = string + n2 + " [label=\"(";
        for (n = 0; n < this.processes.length; ++n) {
            string = string + this.processes[n].getControlLocation();
            string = string + ",";
        }
        string = string + this.memory.printMemory() + ")\"]\n";
        while (abstractState.pred != null) {
            Transition transition = abstractState.tFollowed;
            abstractState = abstractState.pred;
            int n3 = n2--;
            string = string + n2 + " -> " + n3;
            string = string + " [label = \"" + transition.getLabelGlobalDot() + "\"];\n";
            string = string + n2 + " [label=\"(";
            for (n = 0; n < this.processes.length; ++n) {
                string = string + abstractState.processes[n].getControlLocation();
                string = string + ",";
            }
            string = string + abstractState.memory.printMemory() + ")\"]\n";
        }
        string = string + "}";
        return string;
    }
}

