/*
 * Decompiled with CFR 0.152.
 */
package modelchecker;

import controlgraph.ControlGraph;
import controlgraph.ControlGraphs;
import controlgraph.Transition;
import exceptions.MfenceException;
import exceptions.SfenceException;
import java.util.Vector;
import modelchecker.AbstractState;
import modelchecker.ErrorState;
import modelchecker.MyHashSet;
import modelchecker.MyStack;
import options.Options;

public abstract class Explorer {
    protected ControlGraphs controlGraphs;
    protected AbstractState initialState = null;
    protected MyHashSet<AbstractState> hashTable;
    protected MyStack<AbstractState> stack;
    private long startTime;
    private long lastPrintInfoTime;
    private long endTime;
    protected int maxDepth = 0;
    protected int currDepth = 0;
    private static long totalTime;
    private static int nbIterations;
    private static int insertedMFences;
    private static int insertedSFences;
    private static int removedMFences;
    private static int removedSFences;
    protected volatile int nbStatesStored = 0;
    protected volatile int nbStatesVisited = 0;
    protected static Vector<ErrorState> errorStates;
    protected static Vector<Transition> insertedFences;

    public abstract void storeState(AbstractState var1);

    public abstract AbstractState visited(AbstractState var1);

    public abstract boolean contains(AbstractState var1);

    public abstract void removeState(AbstractState var1);

    protected abstract void DFS() throws MfenceException, Exception;

    public abstract void finish();

    public Explorer(Vector<Vector<Integer>> vector) {
        errorStates.clear();
        for (Vector<Integer> vector2 : vector) {
            int n = vector2.size() - 1;
            int[] nArray = new int[n];
            int n2 = vector2.elementAt(0);
            for (int i = 1; i < vector2.size(); ++i) {
                nArray[i - 1] = vector2.elementAt(i);
            }
            ErrorState errorState = new ErrorState(n2, nArray);
            errorStates.add(errorState);
        }
    }

    public boolean explore() throws Exception {
        try {
            this.lastPrintInfoTime = this.startTime = System.currentTimeMillis();
            this.DFS();
        }
        catch (MfenceException mfenceException) {
            ++nbIterations;
            boolean bl = false;
            return bl;
        }
        catch (SfenceException sfenceException) {
            ++nbIterations;
            boolean bl = false;
            return bl;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            this.endTime = System.currentTimeMillis();
            totalTime += this.endTime - this.startTime;
        }
        return true;
    }

    public static void setInsertedMfences(int n) {
        insertedMFences = n;
    }

    public static void setInsertedSfences(int n) {
        insertedSFences = n;
    }

    public static void setRemovedMfences(int n) {
        removedMFences = n;
    }

    public static void setRemovedSfences(int n) {
        removedSFences = n;
    }

    public static void clearInsertedFences() {
        insertedFences.clear();
    }

    public static Vector<Transition> getInsertedFences() {
        return insertedFences;
    }

    public static void addInsertedFence(Transition transition) {
        insertedFences.add(transition);
    }

    public static void removeInsertedFence(Transition transition) {
        insertedFences.remove(transition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryToRemoveMfence(Transition transition) throws Exception {
        boolean bl;
        Transition transition2;
        ControlGraph controlGraph;
        block8: {
            int n = transition.getNbProcess();
            controlGraph = this.controlGraphs.getControlGraph(n);
            transition2 = controlGraph.removeMfenceTransition(transition);
            bl = true;
            try {
                this.startTime = System.currentTimeMillis();
                this.DFS();
            }
            catch (Exception exception) {
                if (exception.getMessage() != null && exception.getMessage().equals("First Error")) {
                    bl = false;
                    break block8;
                }
                throw exception;
            }
            finally {
                this.endTime = System.currentTimeMillis();
                totalTime += this.endTime - this.startTime;
            }
        }
        if (bl) {
            controlGraph.confirmMfenceRemoval(transition);
        } else {
            controlGraph.reinsertMfenceOperation(transition2, transition);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryToRemoveSfence(Transition transition) throws Exception {
        boolean bl;
        Transition transition2;
        ControlGraph controlGraph;
        block8: {
            int n = transition.getNbProcess();
            controlGraph = this.controlGraphs.getControlGraph(n);
            transition2 = controlGraph.removeSfenceTransition(transition);
            bl = true;
            try {
                this.startTime = System.currentTimeMillis();
                this.DFS();
            }
            catch (Exception exception) {
                if (exception.getMessage() != null && exception.getMessage().equals("First Error")) {
                    bl = false;
                    break block8;
                }
                throw exception;
            }
            finally {
                this.endTime = System.currentTimeMillis();
                totalTime += this.endTime - this.startTime;
            }
        }
        if (bl) {
            controlGraph.confirmSfenceRemoval(transition);
        } else {
            controlGraph.reinsertSfenceOperation(transition2, transition);
        }
        return bl;
    }

    public static void resetTotalTime() {
        totalTime = 0L;
    }

    public static void resetIterations() {
        nbIterations = 0;
    }

    protected void printInfo() {
        if (this.nbStatesVisited % 100 == 0 && this.nbStatesVisited != 0 && Options.getVerbose()) {
            if (this.maxDepth < this.currDepth) {
                this.maxDepth = this.currDepth;
            }
            this.endTime = System.currentTimeMillis();
            if (this.endTime - this.lastPrintInfoTime < 1000L) {
                return;
            }
            this.lastPrintInfoTime = this.endTime;
            int n = new Long(this.endTime - this.startTime).intValue();
            System.out.println("nb states: visited: " + this.nbStatesVisited + " stored: " + this.nbStatesStored + " - max Depth: " + this.maxDepth + " - " + "curr Depth: " + this.currDepth + " - " + "state per sec: " + this.nbStatesVisited * 1000 / n);
        }
    }

    public void printStats() {
        System.out.println("Nb States stored (this iteration): " + this.nbStatesStored);
        System.out.println("Nb States visited (this iteration): " + this.nbStatesVisited);
        System.out.println("Exploration Time (this iteration): " + (this.endTime - this.startTime) + " ms");
        System.out.println("Total Time: " + totalTime + " ms");
        if (Options.getExplorationMode() == 2) {
            System.out.println("Number of Iterations to get safe program: " + nbIterations);
            System.out.println("Number of Mfences inserted: " + insertedMFences);
            System.out.println("Number of Sfences inserted: " + insertedSFences);
            if (Options.getMaximalPermissive()) {
                System.out.println("Number of removed (Mfences inserted): " + removedMFences);
                System.out.println("Number of removed (Sfences inserted): " + removedSFences);
            }
        }
        System.out.println("Max depth reached: " + this.maxDepth);
        if (Options.getProperty() == 0) {
            System.out.println("Number of errors found: " + AbstractState.getNbErrors());
        } else if (Options.getProperty() == 1) {
            System.out.println("Number of deadlocks found: " + AbstractState.countDeadlocks);
        }
        System.out.println();
    }

    protected void incrementCommitCounter() {
        ++AbstractState.commitCounter;
    }

    protected void incrementOtherOpsCounter() {
        ++AbstractState.otherCounter;
    }

    public static boolean isPartialErrorStateProcess(AbstractState abstractState, int n) {
        if (errorStates == null) {
            return false;
        }
        for (ErrorState errorState : errorStates) {
            if (!errorState.isPartialErrorState(abstractState, n)) continue;
            return true;
        }
        return false;
    }

    static {
        nbIterations = 0;
        insertedMFences = 0;
        insertedSFences = 0;
        removedMFences = 0;
        removedSFences = 0;
        errorStates = new Vector();
        insertedFences = new Vector();
    }
}

