/*
 * Decompiled with CFR 0.152.
 */
package modelchecker;

import java.util.Arrays;
import modelchecker.MemoryVariable;

public class Memory
implements Cloneable {
    private MemoryVariable[] globalVars;
    private final int nbVars;

    public Memory(int n) {
        this.nbVars = n;
        this.globalVars = new MemoryVariable[n];
    }

    public int getNbVars() {
        return this.nbVars;
    }

    public void setMemory(MemoryVariable[] memoryVariableArray) {
        if (this.globalVars.length != memoryVariableArray.length) {
            throw new InternalError("size error in global memory");
        }
        for (int i = 0; i < this.globalVars.length; ++i) {
            this.globalVars[i] = (MemoryVariable)memoryVariableArray[i].clone();
        }
    }

    public void setMemory(MemoryVariable memoryVariable) {
        this.globalVars[memoryVariable.getVarId()] = (MemoryVariable)memoryVariable.clone();
    }

    public void setMemory(int n, boolean bl, int n2, boolean bl2) {
        this.globalVars[n].setValue(bl2);
        this.globalVars[n].setValue(n2);
    }

    public Object clone() {
        Memory memory;
        try {
            memory = (Memory)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("At least one subclass of Memorydoes not implement Cloneable");
        }
        memory.globalVars = new MemoryVariable[this.globalVars.length];
        for (int i = 0; i < this.globalVars.length; ++i) {
            memory.globalVars[i] = this.globalVars[i] != null ? (MemoryVariable)this.globalVars[i].clone() : null;
        }
        return memory;
    }

    public int hashCode() {
        return Arrays.hashCode(this.globalVars);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Memory)) {
            return false;
        }
        Memory memory = (Memory)object;
        for (int i = 0; i < this.globalVars.length; ++i) {
            if (this.globalVars[i] == null && memory.globalVars[i] != null || this.globalVars[i] != null && memory.globalVars[i] == null) {
                return false;
            }
            if (this.globalVars[i] == null && memory.globalVars[i] == null || this.globalVars[i].equals(memory.globalVars[i])) continue;
            return false;
        }
        return true;
    }

    public MemoryVariable getMemoryVariableAt(int n) {
        return this.globalVars[n];
    }

    public String printMemory() {
        String string = new String();
        for (int i = 0; i < this.globalVars.length; ++i) {
            string = string + this.globalVars[i].printVariable();
            if (i >= this.globalVars.length - 1) continue;
            string = string + ",";
        }
        return string;
    }
}

