/*
 * Decompiled with CFR 0.152.
 */
package modelchecker.sc;

import controlgraph.ControlGraphs;
import java.util.Iterator;
import java.util.Vector;
import modelchecker.AbstractState;
import modelchecker.Explorer;
import modelchecker.Memory;
import modelchecker.MyHashSet;
import modelchecker.MyStack;
import modelchecker.Process;
import modelchecker.sc.SCState;
import options.Options;

public class SCExplorer
extends Explorer {
    public SCExplorer(ControlGraphs controlGraphs, Vector<Vector<Integer>> vector) {
        super(vector);
        this.controlGraphs = controlGraphs;
        this.stack = new MyStack();
        this.hashTable = new MyHashSet();
        this.initExploration();
    }

    public void initExploration() {
        Memory memory = this.controlGraphs.initMemory();
        Process[] processArray = this.controlGraphs.initProcesses();
        this.initialState = new SCState(null, memory, processArray);
        this.stack.push(this.initialState);
    }

    @Override
    public void storeState(AbstractState abstractState) {
        ++this.nbStatesStored;
        this.hashTable.add(abstractState);
    }

    @Override
    public boolean contains(AbstractState abstractState) {
        return this.hashTable.contains(abstractState);
    }

    @Override
    public AbstractState visited(AbstractState abstractState) {
        if (this.hashTable.contains(abstractState)) {
            return this.hashTable.get(abstractState);
        }
        return null;
    }

    @Override
    public void removeState(AbstractState abstractState) {
        this.hashTable.remove(abstractState);
        --this.nbStatesStored;
    }

    public int getNbStates() {
        return this.hashTable.size();
    }

    @Override
    protected void DFS() throws Exception {
        SCState sCState = (SCState)this.stack.peek();
        AbstractState abstractState = null;
        this.printInfo();
        abstractState = this.visited(sCState);
        if (abstractState != null) {
            sCState.setEqualState(abstractState);
            sCState.setStateType(2);
            ++this.nbStatesVisited;
            this.stack.pop();
            return;
        }
        this.storeState(sCState);
        ++this.nbStatesVisited;
        Vector<AbstractState> vector = sCState.computeSuccessors(this.controlGraphs);
        if (Options.getProperty() == 0 && sCState.isErrorState()) {
            if (Options.getExplorationMode() == 0) {
                throw new Exception("First Error");
            }
            if (Options.getExplorationMode() == 2) {
                throw new InternalError("no error correction in SC");
            }
        } else if (Options.getProperty() == 1 && sCState.check4Deadlock(this.controlGraphs) && (Options.getExplorationMode() == 0 || Options.getExplorationMode() == 2)) {
            throw new Exception("First Error");
        }
        sCState.removeDisabledSucc();
        this.removeDisabledSucc(vector);
        for (AbstractState abstractState2 : vector) {
            this.stack.push(abstractState2);
            this.currDepth = this.stack.size();
            if (this.maxDepth < this.currDepth) {
                this.maxDepth = this.currDepth;
            }
            this.DFS();
        }
        this.stack.pop();
    }

    private void removeDisabledSucc(Vector<AbstractState> vector) {
        Iterator<AbstractState> iterator = vector.iterator();
        while (iterator.hasNext()) {
            AbstractState abstractState = iterator.next();
            if (abstractState != null) continue;
            iterator.remove();
        }
    }

    @Override
    public void finish() {
        this.printStates();
    }

    public void printStates() {
        this.initialState.setStateNumbersAntText(0, false);
        this.initialState.globalDot();
    }
}

