/*
 * Decompiled with CFR 0.152.
 */
package modelchecker.sc;

import buffer.Buffer;
import buffer.BufferStoreContent;
import controlgraph.ControlGraphs;
import controlgraph.Node;
import controlgraph.Transition;
import controlgraph.actions.Assign;
import controlgraph.actions.LDV;
import controlgraph.actions.ST;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import modelchecker.AbstractState;
import modelchecker.Memory;
import modelchecker.MemoryVariable;
import modelchecker.Process;

public class SCState
extends AbstractState {
    ControlGraphs controlGraphs;

    public SCState(AbstractState abstractState, Memory memory, Process[] processArray) {
        super(abstractState, memory, processArray);
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        return object instanceof SCState;
    }

    @Override
    public int hashCode() {
        return this.memory.hashCode() ^ Arrays.hashCode(this.processes) ^ this.lock.hashCode();
    }

    public String toString() {
        this.text = this.nbGlobalState + ": (";
        for (int i = 0; i < this.processes.length; ++i) {
            this.text = this.text + this.processes[i].getControlLocation();
            this.text = this.text + ",";
        }
        this.text = this.text + this.memory.printMemory() + ")";
        return this.text;
    }

    public Vector<AbstractState> computeSuccessors(ControlGraphs controlGraphs) {
        this.controlGraphs = controlGraphs;
        this.succ = new Vector();
        Transition transition = null;
        SCState sCState = null;
        for (int i = 0; i < this.processes.length; ++i) {
            Node node = this.processes[i].getCurrentNode();
            Iterator<Transition> iterator = node.getTransitionsIterator();
            while (iterator.hasNext()) {
                transition = iterator.next();
                sCState = this.computeSuccessor(transition, i);
                this.succ.add(sCState);
            }
        }
        return this.succ;
    }

    public void removeDisabledSucc() {
        Iterator iterator = this.succ.iterator();
        while (iterator.hasNext()) {
            AbstractState abstractState = (AbstractState)iterator.next();
            if (abstractState != null) continue;
            iterator.remove();
        }
    }

    private SCState computeSuccessor(Transition transition, int n) {
        SCState sCState = null;
        switch (transition.getType()) {
            case 0: {
                sCState = this.store(transition, n);
                break;
            }
            case 5: {
                sCState = this.local(transition, n);
                break;
            }
            case 1: {
                sCState = this.load(transition, n);
                break;
            }
            case 13: {
                sCState = this.boolOp(transition, n);
                break;
            }
            case 2: {
                sCState = this.loadVal(transition, n);
                break;
            }
            case 3: {
                throw new InternalError("no commits in SC");
            }
            case 6: {
                sCState = this.lock(transition, n);
                break;
            }
            case 7: {
                sCState = this.unlock(transition, n);
                break;
            }
            case 4: {
                sCState = this.mfence(transition, n);
                break;
            }
            case 14: {
                sCState = this.sfence(transition, n);
                break;
            }
            default: {
                throw new InternalError("something special to happen - " + transition.getType());
            }
        }
        return sCState;
    }

    private SCState local(Transition transition, int n) {
        SCState sCState = (SCState)this.clone();
        sCState.processes[n].pushLocalMem2ControlGraphMem();
        if (!transition.isTrue((Buffer)null)) {
            return null;
        }
        if (transition.getAction().type() != 20) {
            transition.apply(null);
        }
        sCState.processes[n].setControlLocation(transition.getTargetNode().getNbNode());
        sCState.processes[n].popLocalMemFromControlGraphMem();
        sCState.bSC = null;
        sCState.pred = this;
        sCState.succ = null;
        sCState.advancedProcess = n;
        sCState.tFollowed = transition;
        sCState.operationType = 5;
        return sCState;
    }

    private SCState load(Transition transition, int n) {
        if (this.lock.locked() != n && this.lock.locked() != -1) {
            return null;
        }
        SCState sCState = (SCState)this.clone();
        Buffer buffer = this.emptyBuffer();
        sCState.processes[n].pushLocalMem2ControlGraphMem();
        this.pushGlobalMem2ControlGraphsMem(this.controlGraphs);
        if (!transition.isTrue(buffer)) {
            return null;
        }
        sCState.processes[n].setControlLocation(transition.getTargetNode().getNbNode());
        sCState.bSC = null;
        sCState.pred = this;
        sCState.succ = null;
        sCState.advancedProcess = n;
        sCState.tFollowed = transition;
        sCState.operationType = 1;
        return sCState;
    }

    private SCState store(Transition transition, int n) {
        if (this.lock.locked() != n && this.lock.locked() != -1) {
            return null;
        }
        SCState sCState = (SCState)this.clone();
        Buffer buffer = this.emptyBuffer();
        this.pushGlobalMem2ControlGraphsMem(this.controlGraphs);
        sCState.processes[n].pushLocalMem2ControlGraphMem();
        ST sT = (ST)transition.getAction();
        transition.apply(buffer);
        sCState.processes[n].setControlLocation(transition.getTargetNode().getNbNode());
        BufferStoreContent bufferStoreContent = sT.getStoreContent(buffer);
        sCState.memory.setMemory(bufferStoreContent.getId(), bufferStoreContent.isBool(), bufferStoreContent.intValue(), bufferStoreContent.boolValue());
        sCState.bSC = bufferStoreContent;
        sCState.pred = this;
        sCState.succ = null;
        sCState.advancedProcess = n;
        sCState.tFollowed = transition;
        sCState.operationType = 0;
        return sCState;
    }

    private SCState loadVal(Transition transition, int n) {
        SCState sCState = null;
        if (this.lock.locked() != n && this.lock.locked() != -1) {
            return sCState;
        }
        BufferStoreContent bufferStoreContent = null;
        sCState = (SCState)this.clone();
        int n2 = ((Assign)transition.getAction()).loadsVar();
        MemoryVariable memoryVariable = sCState.memory.getMemoryVariableAt(n2);
        LDV lDV = (LDV)((Assign)transition.getAction()).getExpression();
        bufferStoreContent = new BufferStoreContent(n2, memoryVariable.isBool(), memoryVariable.boolValue(), memoryVariable.intValue(), lDV.getGlobalVariable().getName(), null);
        sCState.processes[n].pushLocalMem2ControlGraphMem();
        this.pushGlobalMem2ControlGraphsMem(this.controlGraphs);
        ((Assign)transition.getAction()).apply(bufferStoreContent);
        sCState.processes[n].popLocalMemFromControlGraphMem();
        sCState.processes[n].setControlLocation(transition.getTargetNode().getNbNode());
        sCState.bSC = null;
        sCState.pred = this;
        sCState.succ = null;
        sCState.advancedProcess = n;
        sCState.tFollowed = transition;
        sCState.operationType = 2;
        return sCState;
    }

    private SCState boolOp(Transition transition, int n) {
        SCState sCState = (SCState)this.clone();
        sCState.processes[n].pushLocalMem2ControlGraphMem();
        this.pushGlobalMem2ControlGraphsMem(this.controlGraphs);
        if (!transition.isTrue(this.emptyBuffer())) {
            return null;
        }
        if (transition.containsLoad() != -1 && this.lock.locked() != n && this.lock.locked() != -1) {
            return null;
        }
        sCState.processes[n].setControlLocation(transition.getTargetNode().getNbNode());
        sCState.bSC = null;
        sCState.pred = this;
        sCState.succ = null;
        sCState.advancedProcess = n;
        sCState.tFollowed = transition;
        sCState.operationType = 13;
        return sCState;
    }

    private SCState lock(Transition transition, int n) {
        SCState sCState = null;
        if (this.lock.locked() != -1 && this.lock.locked() != n) {
            return null;
        }
        sCState = (SCState)this.clone();
        sCState.processes[n].setControlLocation(transition.getTargetNode().getNbNode());
        sCState.lock.getLock(n);
        sCState.bSC = null;
        sCState.pred = this;
        sCState.succ = null;
        sCState.advancedProcess = n;
        sCState.tFollowed = transition;
        sCState.operationType = 6;
        return sCState;
    }

    private SCState unlock(Transition transition, int n) {
        if (this.lock.locked() != n && this.lock.locked() != -1) {
            return null;
        }
        SCState sCState = (SCState)this.clone();
        sCState.processes[n].setControlLocation(transition.getTargetNode().getNbNode());
        sCState.bSC = null;
        sCState.pred = this;
        sCState.succ = null;
        sCState.advancedProcess = n;
        sCState.tFollowed = transition;
        sCState.operationType = 7;
        sCState.lock.releaseLock();
        return sCState;
    }

    private SCState mfence(Transition transition, int n) {
        SCState sCState = (SCState)this.clone();
        sCState.processes[n].setControlLocation(transition.getTargetNode().getNbNode());
        sCState.bSC = null;
        sCState.pred = this;
        sCState.succ = null;
        sCState.advancedProcess = n;
        sCState.tFollowed = transition;
        sCState.operationType = 14;
        return sCState;
    }

    private SCState sfence(Transition transition, int n) {
        SCState sCState = (SCState)this.clone();
        sCState.processes[n].setControlLocation(transition.getTargetNode().getNbNode());
        sCState.bSC = null;
        sCState.pred = this;
        sCState.succ = null;
        sCState.advancedProcess = n;
        sCState.tFollowed = transition;
        sCState.operationType = 14;
        return sCState;
    }

    private Buffer emptyBuffer() {
        return new Buffer();
    }

    @Override
    public int setStateNumbersAntText(int n, boolean bl) {
        this.nbGlobalState = n++;
        this.text = this.nbGlobalState + ": (";
        for (int i = 0; i < this.processes.length; ++i) {
            this.text = this.text + this.processes[i].getControlLocation();
            this.text = this.text + ",";
        }
        this.text = this.text + this.memory.printMemory() + ")";
        if (this.stateType == 2) {
            this.text = this.text + " -- eq: " + this.equalState.getGlobalStateNb();
        }
        if (this.succ != null) {
            for (AbstractState abstractState : this.succ) {
                if (abstractState == null) continue;
                n = abstractState.setStateNumbersAntText(n, bl);
            }
        }
        return n;
    }

    @Override
    protected boolean computeErrorTraces() {
        boolean bl = false;
        if (this.stateType == 0) {
            for (AbstractState abstractState : this.succ) {
                if (!((SCState)abstractState).computeErrorTraces()) continue;
                bl = true;
            }
        } else if (this.stateType == 2) {
            bl = ((SCState)this.equalState).errorTraceState;
        }
        this.errorTraceState = bl || this.errorFlag;
        return this.errorTraceState;
    }

    @Override
    public String dotNodeTextErrorTraces() {
        if (!this.errorTraceState) {
            return "";
        }
        String string = this.nbGlobalState + " [label=\"" + this.text + "\"";
        if (this.stateType == 2 || this.stateType == 3 || this.stateType == 1) {
            string = string + ",shape=box";
        }
        if (this.errorFlag) {
            string = string + ",style=filled,color=red";
            System.out.println("error state nb: " + this.nbGlobalState);
            this.printStackTrace();
            System.out.println();
        }
        string = string + "];\n";
        if (this.succ != null) {
            for (AbstractState abstractState : this.succ) {
                if (!((SCState)abstractState).errorTraceState) continue;
                string = string + this.nbGlobalState + " -> " + abstractState.getGlobalStateNb();
                if (((SCState)abstractState).tFollowed != null) {
                    string = string + " [label = \"" + ((SCState)abstractState).tFollowed.getLabelGlobalDot() + "\"]";
                }
                string = string + "\n";
                string = string + ((SCState)abstractState).dotNodeTextErrorTraces();
            }
        }
        if (this.equalState != null && ((SCState)this.equalState).errorTraceState) {
            string = string + this.nbGlobalState + " -> " + this.equalState.getGlobalStateNb();
            string = string + " [label = \"equals\"]";
            string = string + "\n";
        }
        return string;
    }

    @Override
    protected void printCurrentTrace() {
    }

    public boolean check4Deadlock(ControlGraphs controlGraphs) {
        if (this.succ.size() == 0) {
            return false;
        }
        for (AbstractState abstractState : this.succ) {
            if (abstractState == null) continue;
            return false;
        }
        this.deadlockFlag = true;
        this.nbDeadlock = ++AbstractState.countDeadlocks;
        return true;
    }
}

