/*
 * Decompiled with CFR 0.152.
 */
package modelchecker.tso;

import buffer.Buffer;
import buffer.BufferContent;
import buffer.BufferStoreContent;
import controlgraph.Action;
import controlgraph.ControlGraphs;
import controlgraph.Expression;
import controlgraph.Node;
import controlgraph.Transition;
import controlgraph.actions.Assign;
import controlgraph.actions.Commit;
import controlgraph.actions.LD;
import controlgraph.actions.LDDIFF;
import controlgraph.actions.LDV;
import controlgraph.actions.ST;
import exceptions.NoRelaxationException;
import exceptions.SuffixException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import modelchecker.AbstractState;
import modelchecker.Memory;
import modelchecker.MemoryVariable;
import modelchecker.Process;
import modelchecker.TransitionAndSuccessor;
import modelchecker.tso.TsoExplorer;
import options.Options;

public class TsoState
extends AbstractState
implements Cloneable {
    private Buffer[] buffers;
    private Vector<AbstractState> includedIn = null;
    private Vector<AbstractState> includingOrEquals = null;
    private boolean bufferCleared = false;
    private ControlGraphs controlGraphs;
    private Vector<Vector<Transition>> delay = new Vector();
    private boolean cycleFlag = false;
    private TsoState cycleFrom = null;
    private int cycleType = 0;
    private int cycleProcess = -1;
    private Buffer suffixCycle = null;
    private boolean reducedBuffer = false;
    private boolean TSORelaxation = false;

    public TsoState(AbstractState abstractState, Memory memory, Process[] processArray, Buffer[] bufferArray) {
        super(abstractState, memory, processArray);
        this.buffers = bufferArray;
    }

    public String toString() {
        this.text = this.nbGlobalState + ": (";
        for (int i = 0; i < this.processes.length; ++i) {
            this.text = this.text + this.processes[i].getControlLocation();
            this.text = this.text + ",";
        }
        this.text = this.text + this.memory.printMemory() + ")";
        return this.text;
    }

    public void setBufferClearedFlag(boolean bl) {
        this.bufferCleared = bl;
    }

    public void addIncludingOrEqualState(AbstractState abstractState) {
        if (this.includingOrEquals == null) {
            this.includingOrEquals = new Vector();
        }
        this.includingOrEquals.add(abstractState);
    }

    public boolean emptyBuffers() {
        return this.bufferCleared;
    }

    public void setIncludingVector(Vector<AbstractState> vector) {
        this.includedIn = vector;
    }

    public Vector<TransitionAndSuccessor> computeT(ControlGraphs controlGraphs, Vector<Transition> vector) throws SuffixException {
        Vector<TransitionAndSuccessor> vector2 = new Vector<TransitionAndSuccessor>();
        this.controlGraphs = controlGraphs;
        for (Transition transition : vector) {
            Vector<TsoState> vector3 = this.computeSuccessor(transition, transition.getNbProcess());
            if (vector3 == null) continue;
            for (TsoState tsoState : vector3) {
                vector2.add(new TransitionAndSuccessor(transition, tsoState));
            }
        }
        this.removeDisabledTransitions(vector2);
        return vector2;
    }

    public Vector<TransitionAndSuccessor> computeT(ControlGraphs controlGraphs) throws SuffixException {
        Vector<TransitionAndSuccessor> vector = new Vector<TransitionAndSuccessor>();
        this.controlGraphs = controlGraphs;
        this.computeTransitionsAndSuccessors(vector);
        if (Options.getProperty() == 1) {
            this.check4Deadlock(vector);
        }
        this.computePersistentSet(vector);
        this.removeDisabledTransitions(vector);
        return vector;
    }

    public Vector<TransitionAndSuccessor> computeEnabled(ControlGraphs controlGraphs) throws SuffixException {
        Vector<TransitionAndSuccessor> vector = new Vector<TransitionAndSuccessor>();
        this.controlGraphs = controlGraphs;
        this.computeTransitionsAndSuccessors(vector);
        if (Options.getProperty() == 1) {
            this.check4Deadlock(vector);
        }
        this.removeDisabledTransitions(vector);
        return vector;
    }

    private void computeTransitionsAndSuccessors(Vector<TransitionAndSuccessor> vector) throws SuffixException {
        Object object;
        Iterator<TsoState> iterator;
        int n;
        Vector<TsoState> vector2 = null;
        Transition transition = null;
        for (n = 0; n < this.processes.length; ++n) {
            iterator = this.processes[n].getCurrentNode();
            object = ((Node)((Object)iterator)).getTransitionsIterator();
            while (object.hasNext()) {
                transition = object.next();
                vector2 = this.computeSuccessor(transition, n);
                if (vector2 == null) continue;
                for (TsoState tsoState : vector2) {
                    vector.add(new TransitionAndSuccessor(transition, tsoState));
                }
            }
        }
        for (n = 0; n < this.buffers.length; ++n) {
            iterator = (Iterator<TsoState>)this.buffers[n].getOutTransitionsFromInit();
            if (iterator == null) continue;
            object = this.processes[n].getCurrentNode();
            for (Iterator<TsoState> iterator2 : iterator) {
                BufferStoreContent bufferStoreContent = BufferContent.getStoreContent(iterator2);
                Commit commit = new Commit(this.processes[n], bufferStoreContent, this.controlGraphs.getControlGraph(n));
                commit.setNbPossibleCommits(((Iterator<TsoState>)iterator).length);
                transition = new Transition((Node)object, (Node)object, "Commit", n, null, 3, commit);
                vector2 = this.computeSuccessor(transition, n);
                for (TsoState tsoState : vector2) {
                    vector.add(new TransitionAndSuccessor(transition, tsoState));
                }
            }
        }
    }

    private Vector<TsoState> computeSuccessor(Transition transition, int n) throws SuffixException {
        Vector<TsoState> vector;
        switch (transition.getType()) {
            case 3: {
                vector = this.commit(transition, n);
                break;
            }
            case 0: {
                vector = this.store(transition, n);
                break;
            }
            case 5: {
                vector = this.local(transition, n);
                break;
            }
            case 1: {
                vector = this.load(transition, n);
                break;
            }
            case 6: {
                vector = this.lock(transition, n);
                break;
            }
            case 7: {
                vector = this.unlock(transition, n);
                break;
            }
            case 4: {
                vector = this.mfence(transition, n);
                break;
            }
            case 14: {
                vector = this.sfence(transition, n);
                break;
            }
            case 13: {
                vector = this.boolOp(transition, n);
                break;
            }
            case 2: {
                vector = this.loadVal(transition, n);
                break;
            }
            default: {
                throw new InternalError("something special to happen - " + transition.getType());
            }
        }
        for (TsoState tsoState : vector) {
            if (tsoState != null) {
                tsoState.cycleFlag = false;
                tsoState.cycleFrom = null;
                tsoState.cycleType = 0;
                tsoState.suffixCycle = null;
                tsoState.cycleProcess = -1;
                tsoState.errorFlag = false;
                tsoState.delay.clear();
                tsoState.equalState = null;
                if (tsoState.includedIn != null) {
                    tsoState.includedIn.clear();
                }
                tsoState.fromDelayFlag = false;
                tsoState.stateType = 4;
            }
            if (tsoState == null) continue;
            tsoState.cycleDetection(tsoState.advancedProcess);
        }
        return vector;
    }

    private Vector<TsoState> commit(Transition transition, int n) {
        Vector<TsoState> vector = new Vector<TsoState>();
        TsoState tsoState = (TsoState)this.clone();
        Buffer buffer = tsoState.buffers[n];
        Commit commit = (Commit)transition.getAction();
        BufferStoreContent bufferStoreContent = commit.getBufferStoreContent();
        if (!buffer.checkPossibleCommit(BufferContent.getChar(bufferStoreContent))) {
            vector.add(null);
            return vector;
        }
        this.pushGlobalMem2ControlGraphsMem(this.controlGraphs);
        tsoState.processes[n].pushLocalMem2ControlGraphMem();
        transition.apply(buffer);
        if (buffer.isEmpty() || this.lock.locked() != n && this.lock.locked() != -1) {
            vector.add(null);
            return vector;
        }
        tsoState.memory.setMemory(bufferStoreContent.getId(), bufferStoreContent.isBool(), bufferStoreContent.intValue(), bufferStoreContent.boolValue());
        tsoState.bSC = null;
        tsoState.pred = this;
        tsoState.succ = null;
        tsoState.advancedProcess = n;
        tsoState.tFollowed = transition;
        tsoState.operationType = 3;
        tsoState.reducedBuffer = false;
        vector.add(tsoState);
        return vector;
    }

    private Vector<TsoState> store(Transition transition, int n) {
        Vector<TsoState> vector = new Vector<TsoState>();
        TsoState tsoState = (TsoState)this.clone();
        Buffer buffer = tsoState.buffers[n];
        this.pushGlobalMem2ControlGraphsMem(this.controlGraphs);
        tsoState.processes[n].pushLocalMem2ControlGraphMem();
        ST sT = (ST)transition.getAction();
        BufferStoreContent bufferStoreContent = sT.getStoreContent(buffer);
        transition.apply(buffer);
        tsoState.processes[n].setControlLocation(transition.getTargetNode().getNbNode());
        tsoState.bSC = bufferStoreContent;
        tsoState.pred = this;
        tsoState.succ = null;
        tsoState.advancedProcess = n;
        tsoState.tFollowed = transition;
        tsoState.operationType = 0;
        tsoState.reducedBuffer = false;
        vector.add(tsoState);
        return vector;
    }

    private Vector<TsoState> local(Transition transition, int n) {
        Vector<TsoState> vector = new Vector<TsoState>();
        TsoState tsoState = (TsoState)this.clone();
        tsoState.processes[n].pushLocalMem2ControlGraphMem();
        if (!transition.isTrue((Buffer)null)) {
            vector.add(null);
            return vector;
        }
        if (transition.getAction().type() != 20) {
            transition.apply(null);
        }
        tsoState.processes[n].setControlLocation(transition.getTargetNode().getNbNode());
        tsoState.processes[n].popLocalMemFromControlGraphMem();
        tsoState.bSC = null;
        tsoState.pred = this;
        tsoState.succ = null;
        tsoState.advancedProcess = n;
        tsoState.tFollowed = transition;
        tsoState.operationType = 5;
        tsoState.reducedBuffer = false;
        vector.add(tsoState);
        return vector;
    }

    private Vector<TsoState> load(Transition transition, int n) {
        Vector<TsoState> vector = new Vector<TsoState>();
        TsoState tsoState = (TsoState)this.clone();
        Buffer buffer = tsoState.buffers[n];
        tsoState.processes[n].pushLocalMem2ControlGraphMem();
        this.pushGlobalMem2ControlGraphsMem(this.controlGraphs);
        if (!transition.isTrue(buffer) || this.lock.locked() != n && this.lock.locked() != -1) {
            vector.add(null);
            return vector;
        }
        if (!this.buffers[n].isEmptyString()) {
            tsoState.TSORelaxation = true;
        }
        tsoState.processes[n].setControlLocation(transition.getTargetNode().getNbNode());
        tsoState.bSC = null;
        tsoState.pred = this;
        tsoState.succ = null;
        tsoState.advancedProcess = n;
        tsoState.tFollowed = transition;
        tsoState.operationType = 1;
        Action action = transition.getAction();
        if (action instanceof LD) {
            tsoState.reducedBuffer = ((LD)transition.getAction()).bufferModified();
        } else if (action instanceof LDDIFF) {
            tsoState.reducedBuffer = ((LDDIFF)transition.getAction()).bufferModified();
        }
        vector.add(tsoState);
        return vector;
    }

    private Vector<TsoState> loadVal(Transition transition, int n) {
        Vector<TsoState> vector = new Vector<TsoState>();
        if (this.lock.locked() != n && this.lock.locked() != -1) {
            vector.add(null);
            return vector;
        }
        TsoState tsoState = (TsoState)this.clone();
        BufferStoreContent bufferStoreContent = null;
        boolean bl = false;
        int n2 = ((Assign)transition.getAction()).loadsVar();
        Vector<BufferStoreContent> vector2 = tsoState.buffers[n].prepareLoadBuffer(n2);
        if (vector2.size() == 0) {
            throw new InternalError("Impossible");
        }
        if (vector2.lastElement() == null) {
            vector2.removeElementAt(vector2.size() - 1);
            MemoryVariable memoryVariable = tsoState.memory.getMemoryVariableAt(n2);
            LDV cloneable = (LDV)((Assign)transition.getAction()).getExpression();
            bufferStoreContent = new BufferStoreContent(n2, memoryVariable.isBool(), memoryVariable.boolValue(), memoryVariable.intValue(), cloneable.getGlobalVariable().getName(), null);
            if (!vector2.contains(bufferStoreContent)) {
                vector2.add(bufferStoreContent);
            }
            bl = true;
        }
        for (BufferStoreContent bufferStoreContent2 : vector2) {
            tsoState = (TsoState)this.clone();
            tsoState.processes[n].pushLocalMem2ControlGraphMem();
            this.pushGlobalMem2ControlGraphsMem(this.controlGraphs);
            ((Assign)transition.getAction()).apply(bufferStoreContent2);
            if (!this.buffers[n].isEmptyString()) {
                tsoState.TSORelaxation = true;
            }
            tsoState.processes[n].popLocalMemFromControlGraphMem();
            tsoState.processes[n].setControlLocation(transition.getTargetNode().getNbNode());
            Buffer buffer = tsoState.buffers[n];
            tsoState.buffers[n] = bl && bufferStoreContent2.equals(bufferStoreContent) ? tsoState.buffers[n].getCorrespondingBuffer(bufferStoreContent2, true) : tsoState.buffers[n].getCorrespondingBuffer(bufferStoreContent2, false);
            tsoState.bSC = null;
            tsoState.pred = this;
            tsoState.succ = null;
            tsoState.advancedProcess = n;
            tsoState.tFollowed = transition;
            tsoState.operationType = 2;
            LDV lDV = (LDV)((Assign)transition.getAction()).getExpression();
            if (buffer.equals(tsoState.buffers[n])) {
                tsoState.reducedBuffer = false;
                lDV.setBufferModified(false);
            } else {
                tsoState.reducedBuffer = true;
                lDV.setBufferModified(true);
            }
            vector.add(tsoState);
        }
        return vector;
    }

    private Vector<TsoState> lock(Transition transition, int n) {
        Vector<TsoState> vector = new Vector<TsoState>();
        if (this.lock.locked() != -1 && this.lock.locked() != n) {
            vector.add(null);
            return vector;
        }
        TsoState tsoState = (TsoState)this.clone();
        tsoState.processes[n].setControlLocation(transition.getTargetNode().getNbNode());
        tsoState.lock.getLock(n);
        tsoState.bSC = null;
        tsoState.pred = this;
        tsoState.succ = null;
        tsoState.advancedProcess = n;
        tsoState.tFollowed = transition;
        tsoState.operationType = 6;
        tsoState.reducedBuffer = false;
        vector.add(tsoState);
        return vector;
    }

    private Vector<TsoState> mfence(Transition transition, int n) {
        Vector<TsoState> vector = new Vector<TsoState>();
        TsoState tsoState = (TsoState)this.clone();
        if (!tsoState.buffers[n].acceptsEmptyString()) {
            vector.add(null);
            return vector;
        }
        tsoState.reducedBuffer = tsoState.buffers[n].resetBuffer();
        tsoState.processes[n].setControlLocation(transition.getTargetNode().getNbNode());
        tsoState.bSC = null;
        tsoState.pred = this;
        tsoState.succ = null;
        tsoState.advancedProcess = n;
        tsoState.tFollowed = transition;
        tsoState.operationType = 4;
        vector.add(tsoState);
        return vector;
    }

    private Vector<TsoState> sfence(Transition transition, int n) {
        Vector<TsoState> vector = new Vector<TsoState>();
        TsoState tsoState = (TsoState)this.clone();
        tsoState.processes[n].setControlLocation(transition.getTargetNode().getNbNode());
        tsoState.bSC = null;
        tsoState.pred = this;
        tsoState.succ = null;
        tsoState.advancedProcess = n;
        tsoState.tFollowed = transition;
        tsoState.operationType = 14;
        tsoState.reducedBuffer = false;
        vector.add(tsoState);
        return vector;
    }

    private Vector<TsoState> unlock(Transition transition, int n) {
        Vector<TsoState> vector = new Vector<TsoState>();
        TsoState tsoState = (TsoState)this.clone();
        if (this.lock.locked() != n && this.lock.locked() != -1 || !tsoState.buffers[n].acceptsEmptyString()) {
            vector.add(null);
            return vector;
        }
        tsoState.reducedBuffer = tsoState.buffers[n].resetBuffer();
        tsoState.processes[n].setControlLocation(transition.getTargetNode().getNbNode());
        tsoState.bSC = null;
        tsoState.pred = this;
        tsoState.succ = null;
        tsoState.advancedProcess = n;
        tsoState.tFollowed = transition;
        tsoState.operationType = 7;
        tsoState.lock.releaseLock();
        vector.add(tsoState);
        return vector;
    }

    private Vector<TsoState> boolOp(Transition transition, int n) {
        Vector<TsoState> vector = new Vector<TsoState>();
        TsoState tsoState = (TsoState)this.clone();
        Buffer buffer = tsoState.buffers[n];
        tsoState.processes[n].pushLocalMem2ControlGraphMem();
        this.pushGlobalMem2ControlGraphsMem(this.controlGraphs);
        if (!transition.isTrue(buffer)) {
            vector.add(null);
            return vector;
        }
        if (transition.containsLoad() != -1 && this.lock.locked() != n && this.lock.locked() != -1) {
            vector.add(null);
            return vector;
        }
        if (transition.containsLoad() != -1) {
            if (!this.buffers[n].isEmptyString()) {
                tsoState.TSORelaxation = true;
            }
            tsoState.reducedBuffer = transition.bufferModified();
        }
        tsoState.processes[n].setControlLocation(transition.getTargetNode().getNbNode());
        tsoState.bSC = null;
        tsoState.pred = this;
        tsoState.succ = null;
        tsoState.advancedProcess = n;
        tsoState.tFollowed = transition;
        tsoState.operationType = 13;
        vector.add(tsoState);
        return vector;
    }

    private boolean cycleDetection(int n) throws SuffixException {
        BufferStoreContent bufferStoreContent;
        if (this.cycleStopCondition(this, n)) {
            return false;
        }
        Buffer buffer = new Buffer();
        Vector<Buffer> vector = new Vector<Buffer>();
        BufferStoreContent[] bufferStoreContentArray = new BufferStoreContent[this.getMemory().getNbVars()];
        for (int i = 0; i < bufferStoreContentArray.length; ++i) {
            bufferStoreContentArray[i] = null;
        }
        if (this.getOperationType() == 0 && this.advancedProcess == n && (bufferStoreContent = this.getBufferStoreContent()) != null) {
            if (bufferStoreContentArray[bufferStoreContent.getId()] == null) {
                bufferStoreContentArray[bufferStoreContent.getId()] = bufferStoreContent;
            }
            buffer.addStore(bufferStoreContent);
        }
        TsoState tsoState = (TsoState)this.pred;
        while (tsoState != null) {
            int n2 = this.cycleSimilar(tsoState, n, bufferStoreContentArray, vector, buffer);
            switch (n2) {
                case 2: {
                    return true;
                }
                case 0: {
                    return false;
                }
            }
            if (this.cycleStopCondition(tsoState, n)) {
                return false;
            }
            if (tsoState.advancedProcess == n) {
                Buffer buffer2;
                if (!tsoState.cycleFlag || tsoState.cycleFlag && tsoState.cycleProcess != n) {
                    buffer2 = Buffer.getUnionStar(vector);
                    buffer = Buffer.getConcatenation(buffer2, buffer);
                    vector.clear();
                    if (tsoState.tFollowed.getType() == 0) {
                        buffer.addStoreBefore(tsoState.bSC);
                        BufferStoreContent bufferStoreContent2 = tsoState.bSC;
                        if (bufferStoreContent2 != null && bufferStoreContentArray[bufferStoreContent2.getId()] == null) {
                            bufferStoreContentArray[bufferStoreContent2.getId()] = bufferStoreContent2;
                        }
                    }
                    tsoState = (TsoState)tsoState.pred;
                    continue;
                }
                if (!tsoState.cycleFlag || tsoState.cycleProcess != n) continue;
                if (tsoState.cycleType == 2) {
                    vector.add(tsoState.suffixCycle);
                } else {
                    vector.add(tsoState.suffixCycle);
                    buffer2 = Buffer.getUnionStar(vector);
                    vector.clear();
                    buffer = Buffer.getConcatenation(buffer2, buffer);
                }
                tsoState = tsoState.cycleFrom;
                continue;
            }
            tsoState = (TsoState)tsoState.pred;
        }
        return false;
    }

    private boolean cycleStopCondition(TsoState tsoState, int n) {
        if (tsoState.advancedProcess != n) {
            return false;
        }
        Transition transition = tsoState.tFollowed;
        int n2 = transition.getType();
        if (n2 == 3 || n2 == 4 || n2 == 6 || n2 == 7) {
            return true;
        }
        if ((n2 == 1 || n2 == 2) && tsoState.reducedBuffer) {
            return true;
        }
        return n2 == 13 && tsoState.reducedBuffer;
    }

    private int cycleSimilar(TsoState tsoState, int n, BufferStoreContent[] bufferStoreContentArray, Vector<Buffer> vector, Buffer buffer) throws SuffixException {
        if (!this.memory.equals(tsoState.memory)) {
            return 1;
        }
        for (int i = 0; i < this.processes.length; ++i) {
            if (!this.processes[i].equals(tsoState.processes[i])) {
                return 1;
            }
            if (i == n || this.buffers[i].equals(tsoState.buffers[i])) continue;
            return 1;
        }
        Buffer buffer2 = this.buffers[n];
        Buffer buffer3 = tsoState.buffers[n];
        Memory memory = this.memory;
        Memory memory2 = tsoState.memory;
        boolean bl = false;
        if (!buffer2.strongLoadEquivalent(buffer3, memory, memory2, bufferStoreContentArray)) {
            return 1;
        }
        bl = true;
        Buffer buffer4 = Buffer.getUnionStar(vector);
        buffer4 = Buffer.getConcatenation(buffer4, buffer);
        if (bl) {
            if (tsoState.checkStrongParallel(n, bufferStoreContentArray)) {
                this.cycleFlag = true;
                this.cycleFrom = tsoState;
                this.cycleProcess = n;
                this.cycleType = 2;
                this.suffixCycle = buffer4;
                buffer2.setAutomaton(tsoState.makeStrongCycle(buffer4, n).getAutomaton());
            } else {
                this.cycleFlag = true;
                this.cycleFrom = tsoState;
                this.cycleProcess = n;
                this.cycleType = 3;
                this.suffixCycle = buffer4;
                buffer2.makeWeakCycleWithSuffix(buffer3, buffer4, 0);
            }
        } else {
            return 1;
        }
        return 2;
    }

    private Buffer makeStrongCycle(Buffer buffer, int n) {
        Buffer buffer2 = new Buffer();
        Vector<Buffer> vector = new Vector<Buffer>();
        vector.add(buffer);
        TsoState tsoState = this;
        while (tsoState != null) {
            if (tsoState.cycleFlag && tsoState.cycleProcess == n && tsoState.cycleType == 2) {
                vector.add((Buffer)tsoState.suffixCycle.clone());
                tsoState = tsoState.cycleFrom;
                continue;
            }
            if (tsoState.cycleFlag && tsoState.cycleProcess == n && tsoState.cycleType == 3) {
                vector.add((Buffer)tsoState.suffixCycle.clone());
                buffer2 = (Buffer)tsoState.cycleFrom.buffers[n].clone();
                break;
            }
            buffer2 = (Buffer)tsoState.buffers[n].clone();
        }
        Buffer buffer3 = Buffer.getUnionStar(vector);
        buffer2 = Buffer.getConcatenation(buffer2, buffer3);
        return buffer2;
    }

    private void computePersistentSet(Vector<TransitionAndSuccessor> vector) {
        Vector<TransitionAndSuccessor> vector2 = new Vector<TransitionAndSuccessor>();
        vector2.addAll(vector);
        Vector<TransitionAndSuccessor> vector3 = new Vector<TransitionAndSuccessor>();
        this.look4LocalProvisioTransition(vector, vector3);
        if (vector3.size() == 1) {
            this.computePersistentSet(vector, vector3);
            if (this.onlyLocals(vector3)) {
                vector.clear();
                vector.addAll(vector3);
            } else {
                vector.clear();
                vector.addAll(vector2);
            }
        } else {
            if (this.onlyLocalTransitions(vector)) {
                vector.clear();
                return;
            }
            if (this.noCommits(vector)) {
                Iterator<TransitionAndSuccessor> iterator = vector.iterator();
                while (iterator.hasNext()) {
                    TransitionAndSuccessor transitionAndSuccessor = iterator.next();
                    int n = transitionAndSuccessor.getTransition().getType();
                    if (n != 3) continue;
                    iterator.remove();
                }
            }
        }
    }

    private void look4LocalProvisioTransition(Vector<TransitionAndSuccessor> vector, Vector<TransitionAndSuccessor> vector2) {
        Iterator<TransitionAndSuccessor> iterator = vector.iterator();
        while (iterator.hasNext()) {
            TransitionAndSuccessor transitionAndSuccessor = iterator.next();
            int n = transitionAndSuccessor.getTransition().getType();
            if (n != 5 && n != 0 || n == 13 && transitionAndSuccessor.getTransition().getAction().containsLoad() != -1 || transitionAndSuccessor.getAbstractState() == null || Options.getProperty() != 1 && (Options.getProperty() != 0 || !this.proviso(transitionAndSuccessor) || TsoExplorer.isPartialErrorStateProcess(this, transitionAndSuccessor.getTransition().getNbProcess()) && (Options.getExplorationMode() == 2 || Options.getExplorationMode() == 1 || Options.getExplorationMode() == 0))) continue;
            vector2.add(transitionAndSuccessor);
            iterator.remove();
            return;
        }
    }

    private void computePersistentSet(Vector<TransitionAndSuccessor> vector, Vector<TransitionAndSuccessor> vector2) {
        block0: for (TransitionAndSuccessor transitionAndSuccessor : vector) {
            Transition transition = transitionAndSuccessor.getTransition();
            for (TransitionAndSuccessor transitionAndSuccessor2 : vector2) {
                if (this.independent(transition, transitionAndSuccessor2.getTransition())) continue;
                vector2.add(transitionAndSuccessor);
                continue block0;
            }
        }
    }

    private boolean onlyLocals(Vector<TransitionAndSuccessor> vector) {
        for (TransitionAndSuccessor transitionAndSuccessor : vector) {
            int n = transitionAndSuccessor.getTransition().getType();
            if (n != 5 && n != 0 && n != 6) {
                return false;
            }
            if (TsoExplorer.isPartialErrorStateProcess(this, transitionAndSuccessor.getTransition().getNbProcess()) && Options.getProperty() == 0 && (Options.getExplorationMode() == 2 || Options.getExplorationMode() == 1 || Options.getExplorationMode() == 0)) {
                return false;
            }
            if (n != 13 || transitionAndSuccessor.getTransition().getAction().containsLoad() == -1) continue;
            return false;
        }
        return true;
    }

    private boolean onlyLocalTransitions(Vector<TransitionAndSuccessor> vector) {
        TransitionAndSuccessor transitionAndSuccessor;
        int n;
        Iterator<TransitionAndSuccessor> iterator = vector.iterator();
        while (iterator.hasNext() && (n = (transitionAndSuccessor = iterator.next()).getTransition().getType()) != 3) {
            if (n != 5 && n != 0) {
                return false;
            }
            if (TsoExplorer.isPartialErrorStateProcess(this, transitionAndSuccessor.getTransition().getNbProcess()) && Options.getProperty() == 0 && (Options.getExplorationMode() == 2 || Options.getExplorationMode() == 1 || Options.getExplorationMode() == 0)) {
                return false;
            }
            if (n != 13 || transitionAndSuccessor.getTransition().getAction().containsLoad() == -1) continue;
            return false;
        }
        return true;
    }

    private boolean noCommits(Vector<TransitionAndSuccessor> vector) {
        TransitionAndSuccessor transitionAndSuccessor;
        int n;
        Iterator<TransitionAndSuccessor> iterator = vector.iterator();
        while (iterator.hasNext() && (n = (transitionAndSuccessor = iterator.next()).getTransition().getType()) != 3) {
            if (n == 5 && n == 0 && (n != 13 || transitionAndSuccessor.getTransition().getAction().containsLoad() == -1)) continue;
            return false;
        }
        return true;
    }

    private boolean proviso(TransitionAndSuccessor transitionAndSuccessor) {
        Transition transition = transitionAndSuccessor.getTransition();
        TsoState tsoState = (TsoState)transitionAndSuccessor.getAbstractState();
        TsoState tsoState2 = (TsoState)tsoState.pred;
        if (this.sleepSet.contains(transition)) {
            return false;
        }
        while (tsoState2 != null) {
            if (tsoState.equals(tsoState2)) {
                return false;
            }
            tsoState2 = (TsoState)tsoState2.pred;
        }
        return true;
    }

    private void removeDisabledTransitions(Vector<TransitionAndSuccessor> vector) {
        Iterator<TransitionAndSuccessor> iterator = vector.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getAbstractState() != null) continue;
            iterator.remove();
        }
    }

    public synchronized void updateSleepSetIndependance(Transition transition, TsoState tsoState) {
        this.sleepSet = new HashSet();
        for (Transition transition2 : tsoState.sleepSet) {
            if (!this.independentSleepSet(transition, transition2)) continue;
            this.sleepSet.add(transition2);
        }
    }

    public synchronized void updateSleepSetIndependence(Transition transition, HashSet<Transition> hashSet) {
        this.sleepSet = new HashSet();
        for (Transition transition2 : hashSet) {
            if (!this.independentSleepSet(transition, transition2)) continue;
            this.sleepSet.add(transition2);
        }
        if (this.cycleFlag && this.cycleProcess == this.advancedProcess) {
            TsoState tsoState = this.cycleFrom;
            if (tsoState.cycleFlag && tsoState.cycleProcess == this.advancedProcess) {
                this.sleepSet.retainAll(tsoState.getSleepSet());
            }
        }
    }

    private boolean independent(Transition transition, Transition transition2) {
        int n = transition.getNbProcess();
        int n2 = transition2.getNbProcess();
        int n3 = transition.getType();
        int n4 = transition2.getType();
        if (n == n2) {
            if ((n3 == 0 || n3 == 5 || n3 == 6) && n4 == 3) {
                return true;
            }
            if ((n4 == 0 || n4 == 5 || n4 == 6) && n3 == 3) {
                return true;
            }
            if (n3 == 13 && transition.containsLoad() == -1 && n4 == 3) {
                return true;
            }
            return n4 == 13 && transition2.containsLoad() == -1 && n3 == 3;
        }
        if (n3 == 3 && n4 == 1 || n3 == 3 && n4 == 3 || n3 == 1 && n4 == 3 || n3 == 2 && n4 == 3 || n3 == 3 && n4 == 2 || n3 == 6 && n4 == 6 || n3 == 7 && n4 == 6 || n3 == 7 && n4 == 6 || (n3 == 6 || n3 == 7) && (n4 == 1 || n4 == 2 || n4 == 3) || (n4 == 6 || n4 == 7) && (n3 == 1 || n3 == 2 || n3 == 3)) {
            return false;
        }
        if (n3 == 13 && transition.containsLoad() != -1 && (n4 == 3 || n4 == 6 || n4 == 7)) {
            return false;
        }
        return n4 != 13 || transition2.containsLoad() == -1 || n3 != 3 && n3 != 6 && n3 != 7;
    }

    private boolean independentSleepSet(Transition transition, Transition transition2) {
        BufferStoreContent bufferStoreContent;
        int n;
        Action action;
        int n2;
        BufferStoreContent bufferStoreContent2;
        Commit commit;
        int n3 = transition.getNbProcess();
        int n4 = transition2.getNbProcess();
        int n5 = transition.getType();
        int n6 = transition2.getType();
        if (n3 == n4) {
            Action action2;
            Commit commit2;
            if ((n5 == 0 || n5 == 5 || n5 == 6) && n6 == 3) {
                return true;
            }
            if ((n6 == 0 || n6 == 5 || n6 == 6) && n5 == 3) {
                return true;
            }
            if (n5 == 1 && n6 == 3) {
                commit2 = (Commit)transition2.getAction();
                action2 = transition.getAction();
                if (action2 instanceof LD && commit2.getNbPossibleCommits() == 1 && !((LD)action2).bufferModified()) {
                    return true;
                }
                if (action2 instanceof LDDIFF && commit2.getNbPossibleCommits() == 1 && !((LDDIFF)action2).bufferModified()) {
                    return true;
                }
                if (!(action2 instanceof LD) && !(action2 instanceof LDDIFF)) {
                    throw new InternalError("must be load or loaddiff");
                }
            }
            if (n6 == 1 && n5 == 3) {
                commit2 = (Commit)transition.getAction();
                action2 = transition2.getAction();
                if (action2 instanceof LD && commit2.getNbPossibleCommits() == 1 && ((LD)action2).bufferModified()) {
                    return true;
                }
                if (action2 instanceof LDDIFF && commit2.getNbPossibleCommits() == 1 && ((LDDIFF)action2).bufferModified()) {
                    return true;
                }
                if (!(action2 instanceof LD) && !(action2 instanceof LDDIFF)) {
                    throw new InternalError("must be load or loaddiff");
                }
            }
            if (n6 == 2 && n5 == 3 && (commit2 = (Commit)transition.getAction()).getNbPossibleCommits() == 1 && !((LDV)((Assign)transition2.getAction()).getExpression()).bufferModified()) {
                return true;
            }
            if (n5 == 2 && n6 == 3 && (commit2 = (Commit)transition2.getAction()).getNbPossibleCommits() == 1 && !((LDV)((Assign)transition.getAction()).getExpression()).bufferModified()) {
                return true;
            }
            if (n5 == 3 && n6 == 3) {
                return false;
            }
            if (n5 == 13 && n6 == 3 && (transition.getAction().containsLoad() == -1 || ((Commit)transition2.getAction()).getNbPossibleCommits() == 1 && !((Expression)transition.getAction()).bufferModified())) {
                return true;
            }
            return n6 == 13 && n5 == 3 && (transition2.getAction().containsLoad() == -1 || ((Commit)transition.getAction()).getNbPossibleCommits() == 1 && !((Expression)transition2.getAction()).bufferModified());
        }
        if (n5 == 1 && n6 == 3) {
            commit = (Commit)transition2.getAction();
            bufferStoreContent2 = commit.getBufferStoreContent();
            n2 = bufferStoreContent2.getId();
            action = transition.getAction();
            if (action instanceof LD && ((LD)action).containsLoadAt(n2)) {
                return false;
            }
            if (action instanceof LDDIFF && ((LDDIFF)action).containsLoadAt(n2)) {
                return false;
            }
            if (!(action instanceof LD) && !(action instanceof LDDIFF)) {
                throw new InternalError("must be load or loaddiff");
            }
        }
        if (n6 == 1 && n5 == 3) {
            commit = (Commit)transition.getAction();
            bufferStoreContent2 = commit.getBufferStoreContent();
            n2 = bufferStoreContent2.getId();
            action = transition2.getAction();
            if (action instanceof LD && ((LD)action).containsLoadAt(n2)) {
                return false;
            }
            if (action instanceof LDDIFF && ((LDDIFF)action).containsLoadAt(n2)) {
                return false;
            }
            if (!(action instanceof LD) && !(action instanceof LDDIFF)) {
                throw new InternalError("must be load or loaddiff");
            }
        }
        if (n6 == 2 && n5 == 3) {
            commit = (Commit)transition.getAction();
            bufferStoreContent2 = commit.getBufferStoreContent();
            n2 = bufferStoreContent2.getId();
            action = (LDV)((Assign)transition2.getAction()).getExpression();
            if (((LDV)action).containsLoadAt(n2)) {
                return false;
            }
        }
        if (n5 == 2 && n6 == 3) {
            commit = (Commit)transition2.getAction();
            bufferStoreContent2 = commit.getBufferStoreContent();
            n2 = bufferStoreContent2.getId();
            action = (LDV)((Assign)transition.getAction()).getExpression();
            if (((LDV)action).containsLoadAt(n2)) {
                return false;
            }
        }
        if (n6 == 3 && n5 == 3 && (n2 = (bufferStoreContent2 = (commit = (Commit)transition.getAction()).getBufferStoreContent()).getId()) == (n = (bufferStoreContent = ((Commit)(action = (Commit)transition2.getAction())).getBufferStoreContent()).getId())) {
            return false;
        }
        if (n5 == 13 && n6 == 3) {
            int n7 = ((Commit)transition2.getAction()).getBufferStoreContent().getId();
            if (transition.getAction().containsLoadAt(n7)) {
                return false;
            }
        }
        if (n6 == 13 && n5 == 3) {
            int n8 = ((Commit)transition.getAction()).getBufferStoreContent().getId();
            if (transition2.getAction().containsLoadAt(n8)) {
                return false;
            }
        }
        if (!(n5 != 6 && n5 != 7 || n6 != 6 && n6 != 7 && n6 != 1 && n6 != 2 && n6 != 3)) {
            return false;
        }
        if (!(n6 != 6 && n6 != 7 || n5 != 6 && n5 != 7 && n5 != 1 && n5 != 2 && n5 != 3)) {
            return false;
        }
        if ((n5 == 6 || n5 == 7) && n6 == 13 && transition2.containsLoad() != -1) {
            return false;
        }
        return n6 != 6 && n6 != 7 || n5 != 13 || transition.containsLoad() == -1;
    }

    public boolean isDelayEmpty() {
        return this.delay.isEmpty();
    }

    public void addSetToDelaySet(HashSet<Transition> hashSet) {
        if (this.delay == null) {
            this.delay = new Vector();
        }
        Vector<Transition> vector = new Vector<Transition>();
        for (Transition transition : hashSet) {
            vector.add(transition);
        }
        this.delay.add(vector);
    }

    public int delaySetSize() {
        return this.delay.size();
    }

    public Vector<Transition> getAndRemoveDelaySet() {
        Vector<Transition> vector = this.delay.remove(0);
        return vector;
    }

    public void clearDelay() {
        this.delay.clear();
    }

    public int delaySize() {
        return this.delay.size();
    }

    @Override
    public Object clone() {
        TsoState tsoState = (TsoState)super.clone();
        tsoState.cycleFlag = false;
        tsoState.cycleProcess = -1;
        tsoState.buffers = new Buffer[this.buffers.length];
        for (int i = 0; i < this.buffers.length; ++i) {
            tsoState.buffers[i] = (Buffer)this.buffers[i].clone();
        }
        if (this.sleepSet != null) {
            tsoState.sleepSet = new HashSet();
            for (Transition transition : this.sleepSet) {
                tsoState.sleepSet.add(transition);
            }
        }
        tsoState.includedIn = new Vector();
        tsoState.equalState = null;
        tsoState.TSORelaxation = false;
        return tsoState;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof TsoState)) {
            return false;
        }
        TsoState tsoState = (TsoState)object;
        if (this.buffers.length != tsoState.buffers.length) {
            return false;
        }
        for (int i = 0; i < this.buffers.length; ++i) {
            if (this.buffers[i].equals(tsoState.buffers[i])) continue;
            return false;
        }
        return true;
    }

    public boolean includes(TsoState tsoState) {
        int n;
        if (!this.memory.equals(tsoState.memory)) {
            return false;
        }
        for (n = 0; n < this.processes.length; ++n) {
            if (this.processes[n].equals(tsoState.processes[n])) continue;
            return false;
        }
        for (n = 0; n < this.buffers.length; ++n) {
            if (tsoState.buffers[n].isSubsetOf(this.buffers[n])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = this.memory.hashCode() ^ Arrays.hashCode(this.processes) ^ Arrays.hashCode(this.buffers) ^ this.lock.hashCode();
        return n;
    }

    private boolean checkStrongParallel(int n, BufferStoreContent[] bufferStoreContentArray) {
        TsoState tsoState = this;
        if (tsoState != null) {
            Buffer buffer = (Buffer)this.buffers[n].clone();
            Memory memory = (Memory)this.memory.clone();
            if (tsoState.cycleFlag && tsoState.cycleProcess == n) {
                return buffer.strongLoadEquivalent(tsoState.buffers[n], memory, tsoState.memory, bufferStoreContentArray);
            }
            return false;
        }
        return false;
    }

    @Override
    public int setStateNumbersAntText(int n, boolean bl) {
        Object object2;
        int n2;
        this.nbGlobalState = n++;
        this.text = this.nbGlobalState + ": (";
        for (n2 = 0; n2 < this.processes.length; ++n2) {
            this.text = this.text + this.processes[n2].getControlLocation();
            this.text = this.text + ",";
        }
        this.text = this.text + this.memory.printMemory() + ")";
        if (this.cycleFlag) {
            this.text = this.text + " process " + this.cycleProcess + ": cycle found -> " + this.cycleFrom.getGlobalStateNb();
        }
        if (this.deadlockFlag) {
            this.text = this.text + "deadlock nb " + this.nbDeadlock;
        }
        if (this.stateType == 2 || this.stateType == 3) {
            this.text = this.text + " -- eq: " + this.equalState.getGlobalStateNb();
        }
        if (this.stateType == 1 || this.stateType == 3) {
            this.text = this.text + " -- incl in: ";
            for (n2 = 0; n2 < this.includedIn.size(); ++n2) {
                object2 = this.includedIn.elementAt(n2);
                this.text = this.text + ((AbstractState)object2).getGlobalStateNb();
                if (n2 >= this.includedIn.size() - 1) continue;
                this.text = this.text + ",";
            }
        }
        if (this.succ != null) {
            for (Object object2 : this.succ) {
                n = ((AbstractState)object2).setStateNumbersAntText(n, bl);
            }
        }
        if (bl) {
            for (int i = 0; i < this.buffers.length; ++i) {
                object2 = this.nbGlobalState + "_" + i;
                this.buffers[i].printBuffer((String)object2);
            }
        }
        return n;
    }

    @Override
    protected boolean computeErrorTraces() {
        boolean bl = false;
        this.errorTraceState = this.errorFlag;
        if (this.succ != null) {
            for (AbstractState abstractState : this.succ) {
                if (!((TsoState)abstractState).computeErrorTraces()) continue;
                bl = true;
            }
        }
        if (this.stateType == 2 || this.stateType == 1 || this.stateType == 3) {
            if (this.equalState != null) {
                boolean bl2 = bl = bl || ((TsoState)this.equalState).errorTraceState;
            }
            if (!bl && this.includedIn != null) {
                for (AbstractState abstractState : this.includedIn) {
                    if (!((TsoState)abstractState).errorTraceState) continue;
                    bl = true;
                    break;
                }
            }
        }
        this.errorTraceState = bl || this.errorFlag;
        return this.errorTraceState;
    }

    @Override
    protected String dotNodeTextErrorTraces() {
        if (!this.errorTraceState) {
            return "";
        }
        String string = this.nbGlobalState + " [label=\"" + this.text + "\"";
        if (this.stateType == 2 || this.stateType == 3 || this.stateType == 1) {
            string = string + ",shape=box";
        }
        if (this.errorFlag) {
            string = string + ",style=filled,color=red";
        }
        string = string + "];\n";
        if (this.succ != null) {
            for (Object object : this.succ) {
                if (!((TsoState)object).errorTraceState) continue;
                string = string + this.nbGlobalState + " -> " + ((AbstractState)object).getGlobalStateNb();
                if (((TsoState)object).tFollowed != null) {
                    string = string + " [label = \"" + ((TsoState)object).tFollowed.getLabelGlobalDot() + "\"]";
                }
                string = string + "\n";
                string = string + ((TsoState)object).dotNodeTextErrorTraces();
            }
        }
        for (int i = 0; i < this.buffers.length; ++i) {
            Object object;
            object = this.nbGlobalState + "_" + i;
            this.buffers[i].printBuffer((String)object);
        }
        return string;
    }

    @Override
    protected void printCurrentTrace() {
    }

    public Transition searchLastRelaxation() throws NoRelaxationException {
        if (this.TSORelaxation) {
            return this.getTransitionBeforeMFence();
        }
        if (this.pred != null) {
            return ((TsoState)this.pred).searchLastRelaxation();
        }
        throw new NoRelaxationException();
    }

    public Set<Transition> getAllRelaxations() {
        HashSet<Transition> hashSet = new HashSet<Transition>();
        TsoState tsoState = this;
        while (tsoState.pred != null) {
            Buffer buffer;
            if ((tsoState.operationType == 1 || tsoState.operationType == 2 || tsoState.operationType == 13 && tsoState.tFollowed.getAction().containsLoad() != -1) && !(buffer = tsoState.buffers[tsoState.advancedProcess]).isEmptyString()) {
                while (tsoState.pred != null) {
                    tsoState = (TsoState)tsoState.pred;
                    if (tsoState.getAdvancedProc() != tsoState.advancedProcess || tsoState.getOperationType() != 0) continue;
                    if (hashSet.contains(tsoState.tFollowed)) break;
                    hashSet.add(tsoState.tFollowed);
                    break;
                }
            }
            tsoState = (TsoState)tsoState.pred;
        }
        if (hashSet.isEmpty()) {
            throw new InternalError("impossible to not find a crucial relaxation");
        }
        return hashSet;
    }

    public Transition getTransitionBeforeMFence() {
        TsoState tsoState = this;
        while (tsoState.pred != null) {
            tsoState = (TsoState)tsoState.pred;
            if (tsoState.getAdvancedProc() != this.advancedProcess || tsoState.getOperationType() != 0) continue;
            return tsoState.tFollowed;
        }
        throw new InternalError("must find a store operation before the load");
    }

    public boolean check4Deadlock(ControlGraphs controlGraphs) throws SuffixException {
        for (Buffer cloneable : this.buffers) {
            if (cloneable.acceptsEmptyString()) continue;
            return false;
        }
        Vector<TransitionAndSuccessor> vector = this.computeEnabled(controlGraphs);
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            TransitionAndSuccessor transitionAndSuccessor = (TransitionAndSuccessor)iterator.next();
            Transition transition = transitionAndSuccessor.getTransition();
            if (transition.getType() == 3) continue;
            return false;
        }
        this.deadlockFlag = true;
        this.nbDeadlock = ++AbstractState.countDeadlocks;
        return true;
    }

    public boolean isDeadlockState() {
        return this.deadlockFlag;
    }

    public boolean check4Deadlock(Vector<TransitionAndSuccessor> vector) {
        for (Buffer cloneable : this.buffers) {
            if (cloneable.acceptsEmptyString()) continue;
            return false;
        }
        boolean bl = false;
        for (TransitionAndSuccessor transitionAndSuccessor : vector) {
            Transition transition = transitionAndSuccessor.getTransition();
            if (transition.getType() == 3) continue;
            if (transitionAndSuccessor.getAbstractState() != null) {
                return false;
            }
            bl = true;
        }
        if (!bl) {
            return false;
        }
        this.deadlockFlag = true;
        this.nbDeadlock = ++AbstractState.countDeadlocks;
        return true;
    }
}

