/*
 * Decompiled with CFR 0.152.
 */
import buffer.BufferContent;
import compiler.Compiler;
import controlgraph.ControlGraphs;
import controlgraph.Transition;
import exceptions.InputException;
import exceptions.NoRelaxationException;
import exceptions.SyntaxException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Iterator;
import java.util.Vector;
import modelchecker.AbstractState;
import modelchecker.Explorer;
import modelchecker.ExplorerFactory;
import options.Constants;
import options.Options;

public class Remmex {
    public static void main(String[] stringArray) {
        Remmex.parseCommandLine(stringArray);
        if (!Remmex.simpleCheck()) {
            Remmex.usageAndExit();
        }
        Remmex.startExecution();
    }

    private static void parseCommandLine(String[] stringArray) {
        int n = stringArray.length;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (string.equals("-f")) {
                if (bl) {
                    System.out.println("Error: Cannot give 2 fileNames.");
                    Remmex.usageAndExit();
                }
                Options.setFileName(stringArray[++i]);
                bl = true;
                continue;
            }
            if (string.equals("-MM")) {
                if (bl2) {
                    System.out.println("Error: Cannot give 2 memory models.");
                    Remmex.usageAndExit();
                }
                if (!Options.setMemoryModel(stringArray[++i])) {
                    System.out.println("Error: Memory model must be either SC, TSO or PSO.");
                    Remmex.usageAndExit();
                }
                bl2 = true;
                continue;
            }
            if (string.equals("-P")) {
                if (bl3) {
                    System.out.println("Error: Cannot give 2 properties to check.");
                    Remmex.usageAndExit();
                }
                if (!Options.setProperty(stringArray[++i])) {
                    System.out.println("Error: Mode must be either safety, deadlock or controlgraphs.");
                    Remmex.usageAndExit();
                }
                bl3 = true;
                continue;
            }
            if (string.equals("-Mode")) {
                if (bl4) {
                    System.out.println("Error: Cannot give to modes of the exploration mode.");
                    Remmex.usageAndExit();
                }
                if (!Options.setExplorationMode(stringArray[++i])) {
                    System.out.println("Error: Exploration Mode must be either firstError, allErrors, errorCorrection or stateSpace.");
                    Remmex.usageAndExit();
                }
                bl4 = true;
                continue;
            }
            if (string.equals("-e")) {
                Vector<Integer> vector = new Vector<Integer>();
                while (i + 1 < n && !stringArray[i + 1].startsWith("-")) {
                    try {
                        vector.add(new Integer(Integer.parseInt(stringArray[++i])));
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Error state description contained some non integer values");
                        Remmex.usageAndExit();
                    }
                }
                Options.addErrorState(vector);
                continue;
            }
            if (string.equals("-v")) {
                Options.setVerbose(true);
                continue;
            }
            if (string.equals("-printGlobalStateSpace")) {
                Options.setPrintGlobalStateSpace(true);
                continue;
            }
            if (string.equals("-printErrorTraces")) {
                Options.setPrintErrorTraces(true);
                continue;
            }
            if (string.equals("-printStateBuffers")) {
                Options.setPrintStateBuffers(true);
                continue;
            }
            if (string.equals("-maximalPermissive")) {
                Options.setMaximalPermissive(true);
                continue;
            }
            System.out.println("Command line error: unknown statement \"" + string + "\"");
            Remmex.usageAndExit();
        }
    }

    private static boolean simpleCheck() {
        Vector<Vector<Integer>> vector;
        boolean bl = true;
        if (Options.getProperty() == 0 && (vector = Options.getErrorStates()).size() == 0) {
            System.out.println("Error: If safety property is checked, at least one error state must be defined.");
            bl = false;
        }
        if (Options.getFileName() == null) {
            System.out.println("Error: An input file must be specified.");
            bl = false;
        }
        return bl;
    }

    private static void usageAndExit() {
        System.out.println("Usage: java remmex [Inputs] [Options]");
        System.out.println();
        System.out.println("Inputs:");
        System.out.println("*******");
        System.out.println("-f\tThe file to analyse\n\t[requested]\n");
        System.out.println("-MM\tThe memory model. Possible values: SC,TSO,PSO.\n\t[Default: TSO]\n");
        System.out.println("-P\tThe property to be checked. Possible values: safety, deadlock, \n\tcontrolgraphs. The option controlgraphs only analyses the syntax\n\tof the program and creates the controlgraphs.\n\t[Default: safety]\n");
        System.out.println("-Mode\tThe exploration mode. Possible values: firstError, allErrors,\n\terrorCorrection, stateSpace.\n\t[Default: errorCorrection]\n");
        System.out.println("-e\tDescription of an error state (see below). Requested for safety\n\tproperty check. There can be several error states.");
        System.out.println();
        System.out.println("Options:");
        System.out.println("********");
        System.out.println("-v\t\t\tVerbose mode. Print additionnal information.");
        System.out.println("-printGlobalStateSpace\tPrint the global state space.");
        System.out.println("-printErrorTraces\tPrint the traces leading to an error state.");
        System.out.println("-printStateBuffers\tPrint the buffers of the states.");
        System.out.println("-maximalPermissive\tEnsures that a fence-set is maximal permissive.");
        System.out.println();
        System.out.println("Error state description: An error state is defined as a list of \n\tinteger values nb c1 c2 .. cN, where c1 to cN are control\n\tlocation of processes 1 to N and where nb defines the number\n\tof processes that must at least stay in the defined control\n\tlocations. There must be one integer value for each process\n\tin the program. A preliminary execution of the tool is needed to detect the right control locations that describe an error state. To do so, just run the tool with the option P set to controlgraphs. This will print the control graphs of the processes. These control graphs are then used to define the global error states.");
        System.out.println("\tIn case that some of the processes do not participate");
        System.out.println("\tin an error state, assign a negative control location");
        System.out.println("\tto those processes in the error state description. Control");
        System.out.println("\tlocations computed by our toul are always greater that");
        System.out.println("\tzero.");
        System.out.println();
        System.out.println("Example usage:");
        System.out.println("java Remmex -f myfile.txt -MM TSO -P safety -Mode errorCorrection -e 2 4 4");
        System.out.println();
        System.exit(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void startExecution() {
        File file;
        Compiler compiler = null;
        Explorer.resetTotalTime();
        Explorer.resetIterations();
        AbstractState.resetErrorCounting();
        BufferContent.reset();
        System.out.println("File to analyse: " + Options.getFileName());
        if (Options.getVerbose()) {
            Options.printOptions();
        }
        try {
            compiler = new Compiler(new File(Options.getFileName()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File not found: " + Options.getFileName());
            System.out.println();
            Remmex.usageAndExit();
        }
        catch (SyntaxException syntaxException) {
            System.out.println("Syntax Exception");
            System.out.println(syntaxException.getMessageE());
            if (Options.getVerbose()) {
                System.out.println(syntaxException.getVerboseInfo());
            }
            System.out.println();
            Remmex.usageAndExit();
        }
        catch (InputException inputException) {
            System.out.println("Input Exception");
            System.out.println(inputException.getMessageE());
            if (Options.getVerbose()) {
                System.out.println(inputException.getVerboseInfo());
            }
            System.out.println();
            Remmex.usageAndExit();
        }
        System.out.println("Syntax Analyze [OK]");
        try {
            compiler.checkTypes();
        }
        catch (InputException inputException) {
            System.out.println("Input Exception");
            System.out.println(inputException.getMessageE());
            if (Options.getVerbose()) {
                System.out.println(inputException.getVerboseInfo());
            }
            System.out.println();
            Remmex.usageAndExit();
        }
        System.out.println("Type check [OK]");
        try {
            file = new File(Constants.TEMP_DIR + "/" + "Remmex");
            if (file.exists()) {
                Remmex.deleteFileDirectory(file);
            }
            if (!file.mkdir()) {
                System.out.println("Temporary Directory could not be created: " + file);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            System.exit(-1);
        }
        file = new File(Constants.TEMP_DIR + "/" + "Remmex" + "/" + "Buffers");
        if (!file.mkdir()) {
            System.out.println("Temporary Directory could not be created: " + file);
            System.exit(-1);
        }
        ControlGraphs controlGraphs = new ControlGraphs(compiler.getProgram());
        if (Options.getMemoryModel() == 2 && Options.getExplorationMode() == 2) {
            controlGraphs.createControlGraphs();
        } else {
            controlGraphs.createControlGraphs();
        }
        controlGraphs.deleteUseLessNodes();
        System.out.println("Control Graphs created [OK]");
        controlGraphs.printDotFiles();
        System.out.println("Dot Files printed [OK]");
        if (Options.getProperty() == 2) {
            System.out.println("Finished control graphs [OK]");
            return;
        }
        if (Options.getMemoryModel() == 2 && Options.getExplorationMode() == 2) {
            Options.setMemoryModel(1);
            Explorer explorer = ExplorerFactory.getExplorer(Options.getMemoryModel(), controlGraphs, Options.getErrorStates());
            try {
                Vector<Object> vector;
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                while (!explorer.explore()) {
                    if (Options.getVerbose()) {
                        System.out.println("\nError found");
                        explorer.printStats();
                    }
                    Remmex.moveDotAndPdf(n++);
                    explorer = ExplorerFactory.getExplorer(Options.getMemoryModel(), controlGraphs, Options.getErrorStates());
                    AbstractState.resetErrorCounting();
                    BufferContent.reset();
                    controlGraphs.printDotFiles();
                    if (!Options.getVerbose()) continue;
                    System.out.println("Dot file reprinted [OK]");
                    System.out.println("Next iteration");
                }
                if (n > 0) {
                    System.out.println("\nTSO error corrected, " + n + " mfences inserted, now check PSO...\n");
                    Explorer.setInsertedMfences(n);
                } else {
                    System.out.println("\nTSO correct, now check PSO...\n");
                }
                AbstractState.resetErrorCounting();
                BufferContent.reset();
                if (n > 0 && Options.getMaximalPermissive()) {
                    Options.setExplorationMode(0);
                    explorer = ExplorerFactory.getExplorer(Options.getMemoryModel(), controlGraphs, Options.getErrorStates());
                    System.out.println("Before going to PSO, remove unnecessary mfences");
                    Vector<Transition> vector2 = Explorer.getInsertedFences();
                    vector = new Vector<Transition>();
                    for (Transition transition : vector2) {
                        System.out.print("Remove Fence? ");
                        if (explorer.tryToRemoveMfence(transition)) {
                            vector.add(transition);
                            System.out.println("Mfence removed!");
                        } else {
                            System.out.println("Mfence not removed!");
                        }
                        explorer = ExplorerFactory.getExplorer(Options.getMemoryModel(), controlGraphs, Options.getErrorStates());
                        AbstractState.resetErrorCounting();
                        BufferContent.reset();
                    }
                    for (Transition transition : vector) {
                        Explorer.removeInsertedFence(transition);
                    }
                    if (vector.size() > 0) {
                        n2 = vector.size();
                        Explorer.setRemovedMfences(n2);
                        System.out.println(n2 + " mfences could be removed");
                        Remmex.moveDotAndPdf(n++);
                        AbstractState.resetErrorCounting();
                        BufferContent.reset();
                        controlGraphs.printDotFiles();
                    } else {
                        System.out.println("No mfences could be removed");
                    }
                    AbstractState.resetErrorCounting();
                    BufferContent.reset();
                    Explorer.clearInsertedFences();
                    Options.setExplorationMode(2);
                }
                Options.setExplorationMode(2);
                AbstractState.resetErrorCounting();
                BufferContent.reset();
                int n4 = n;
                Options.setMemoryModel(2);
                explorer = ExplorerFactory.getExplorer(Options.getMemoryModel(), controlGraphs, Options.getErrorStates());
                while (!explorer.explore()) {
                    if (Options.getVerbose()) {
                        System.out.println("\nError found");
                        explorer.printStats();
                    }
                    Remmex.moveDotAndPdf(n++);
                    explorer = ExplorerFactory.getExplorer(Options.getMemoryModel(), controlGraphs, Options.getErrorStates());
                    AbstractState.resetErrorCounting();
                    BufferContent.reset();
                    controlGraphs.printDotFiles();
                    if (!Options.getVerbose()) continue;
                    System.out.println("Dot file reprinted [OK]");
                    System.out.println("Next iteration");
                }
                Explorer.setInsertedSfences(n - n4);
                System.out.println();
                System.out.println("PSO corrected, " + (n - n4) + " sfences inserted");
                System.out.println();
                if (n - n4 <= 0) return;
                if (!Options.getMaximalPermissive()) {
                    return;
                }
                Options.setExplorationMode(0);
                explorer = ExplorerFactory.getExplorer(Options.getMemoryModel(), controlGraphs, Options.getErrorStates());
                System.out.println("Remove unnecessary sfences");
                vector = Explorer.getInsertedFences();
                Vector vector3 = new Vector();
                for (Transition transition : vector) {
                    System.out.print("Remove Fence? ");
                    if (explorer.tryToRemoveSfence(transition)) {
                        vector3.add(transition);
                        System.out.println("Sfence removed!");
                    } else {
                        System.out.println("Sfence not removed!");
                    }
                    explorer = ExplorerFactory.getExplorer(Options.getMemoryModel(), controlGraphs, Options.getErrorStates());
                    AbstractState.resetErrorCounting();
                    BufferContent.reset();
                }
                System.out.println(vector3.size() + " sfences could be removed\n");
                Iterator iterator = vector3.iterator();
                while (iterator.hasNext()) {
                    Transition transition = (Transition)iterator.next();
                    Explorer.removeInsertedFence(transition);
                }
                if (vector3.size() > 0) {
                    n3 = vector3.size();
                    Explorer.setRemovedSfences(n3);
                    Remmex.moveDotAndPdf(n++);
                    AbstractState.resetErrorCounting();
                    BufferContent.reset();
                    controlGraphs.printDotFiles();
                }
                if (n3 <= 0) {
                    // empty if block
                }
                Explorer.clearInsertedFences();
                Options.setExplorationMode(2);
                AbstractState.resetErrorCounting();
                BufferContent.reset();
                explorer = ExplorerFactory.getExplorer(Options.getMemoryModel(), controlGraphs, Options.getErrorStates());
                explorer.explore();
                return;
            }
            catch (NoRelaxationException noRelaxationException) {
                System.out.println("\n" + noRelaxationException.getMessage() + "\n");
                return;
            }
            catch (Exception exception) {
                if (exception.getMessage() != null && exception.getMessage().equals("First Error")) {
                    System.out.println("\nFirst error detected\n");
                    return;
                }
                System.out.println("Exception");
                exception.printStackTrace();
                return;
            }
            finally {
                explorer.printStats();
                controlGraphs.printDotFiles();
                explorer.finish();
                System.out.println("Finished [OK]");
            }
        }
        Explorer explorer = ExplorerFactory.getExplorer(Options.getMemoryModel(), controlGraphs, Options.getErrorStates());
        try {
            int n = 0;
            int n5 = 0;
            while (!explorer.explore()) {
                if (Options.getVerbose()) {
                    System.out.println("\nError found");
                    explorer.printStats();
                }
                Remmex.moveDotAndPdf(n++);
                explorer = ExplorerFactory.getExplorer(Options.getMemoryModel(), controlGraphs, Options.getErrorStates());
                AbstractState.resetErrorCounting();
                BufferContent.reset();
                controlGraphs.printDotFiles();
                if (!Options.getVerbose()) continue;
                System.out.println("Dot file reprinted [OK]");
                System.out.println("Next iteration");
            }
            System.out.println();
            if (Options.getExplorationMode() == 2) {
                Explorer.setInsertedMfences(n);
            }
            if (n <= 0 || Options.getExplorationMode() != 2 || !Options.getMaximalPermissive()) return;
            Options.setExplorationMode(0);
            explorer = ExplorerFactory.getExplorer(Options.getMemoryModel(), controlGraphs, Options.getErrorStates());
            System.out.println("Remove unnecessary mfences");
            Vector<Transition> vector = Explorer.getInsertedFences();
            Vector<Transition> vector4 = new Vector<Transition>();
            for (Transition transition : vector) {
                System.out.print("Remove Fence? ");
                if (explorer.tryToRemoveMfence(transition)) {
                    vector4.add(transition);
                    System.out.println("Mfence removed!");
                } else {
                    System.out.println("Mfence not removed!");
                }
                explorer = ExplorerFactory.getExplorer(Options.getMemoryModel(), controlGraphs, Options.getErrorStates());
                AbstractState.resetErrorCounting();
                BufferContent.reset();
            }
            for (Transition transition : vector4) {
                Explorer.removeInsertedFence(transition);
            }
            if (vector4.size() > 0) {
                n5 = vector4.size();
                Explorer.setRemovedMfences(n5);
                System.out.println(n5 + " mfences could be removed");
                Remmex.moveDotAndPdf(n++);
                AbstractState.resetErrorCounting();
                BufferContent.reset();
                controlGraphs.printDotFiles();
            } else {
                System.out.println("No mfences could be removed");
            }
            if (n5 <= 0) {
                // empty if block
            }
            System.out.println();
            Explorer.clearInsertedFences();
            Options.setExplorationMode(2);
            AbstractState.resetErrorCounting();
            BufferContent.reset();
            explorer = ExplorerFactory.getExplorer(Options.getMemoryModel(), controlGraphs, Options.getErrorStates());
            explorer.explore();
            return;
        }
        catch (NoRelaxationException noRelaxationException) {
            System.out.println("\n" + noRelaxationException.getMessage() + "\n");
            return;
        }
        catch (Exception exception) {
            if (exception.getMessage() != null && exception.getMessage().equals("First Error")) {
                System.out.println("\nFirst error detected\n");
                return;
            } else {
                System.out.println("Exception");
                exception.printStackTrace();
            }
            return;
        }
        finally {
            explorer.printStats();
            controlGraphs.printDotFiles();
            explorer.finish();
            System.out.println("Finished [OK]");
        }
    }

    private static void deleteFileDirectory(File file) {
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                Remmex.deleteFileDirectory(file2);
            }
        }
        if (!file.delete()) {
            System.out.println("Temporary File/Directory could not be deleted: " + file);
            System.exit(-1);
        }
    }

    private static void moveDotAndPdf(int n) {
        String string = Constants.TEMP_DIR + "/" + "Remmex" + "/";
        String string2 = string + "iteration_" + n;
        File file = new File(string2);
        File file2 = new File(string);
        if (!file.mkdir()) {
            System.out.println("Temporary Directory could not be created in: " + file2);
            System.exit(-1);
        }
        for (File file3 : file2.listFiles()) {
            if (file3.isDirectory()) continue;
            String string3 = file3.getName();
            file3.renameTo(new File(string2 + "/" + string3));
        }
    }
}

