/*
 * Decompiled with CFR 0.152.
 */
package buffer;

import buffer.BufferStoreContent;
import buffer.Elem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import options.Options;

public class BufferContent {
    private static Vector<Elem> map = new Vector();
    private static HashMap<BufferStoreContent, HashSet<BufferStoreContent>> store2StoreATransition = new HashMap(32);
    private static char nextChar = (char)65;

    public static void reset() {
        map.clear();
        store2StoreATransition.clear();
        nextChar = (char)65;
    }

    public static char getChar(BufferStoreContent bufferStoreContent) {
        if (!BufferContent.contains(bufferStoreContent)) {
            map.add(new Elem(bufferStoreContent, nextChar));
            nextChar = (char)(nextChar + '\u0001');
            if (Options.getMemoryModel() == 2 && (Options.getExplorationMode() == 2 || Options.getExplorationMode() == 0) && bufferStoreContent.getTransition() != null && bufferStoreContent.getId() != Options.getNbGlobalVars()) {
                BufferStoreContent bufferStoreContent2 = new BufferStoreContent(bufferStoreContent.getId(), bufferStoreContent.isBool(), bufferStoreContent.boolValue(), bufferStoreContent.intValue(), bufferStoreContent.getName(), null);
                if (!store2StoreATransition.containsKey(bufferStoreContent2)) {
                    store2StoreATransition.put(bufferStoreContent2, new HashSet());
                }
                store2StoreATransition.get(bufferStoreContent2).add(bufferStoreContent);
                if (!map.contains(bufferStoreContent2)) {
                    map.add(new Elem(bufferStoreContent2, nextChar));
                    nextChar = (char)(nextChar + '\u0001');
                }
            }
        }
        return BufferContent.getCharBis(bufferStoreContent);
    }

    public static BufferStoreContent getStoreContent(char c) {
        if (!BufferContent.contains(c)) {
            throw new InternalError(c + " not in language");
        }
        return BufferContent.getBufferStoreContentBis(c);
    }

    public static BufferStoreContent getStoreContentTransitionCleared(char c) {
        if (!BufferContent.contains(c)) {
            throw new InternalError(c + " not in language");
        }
        BufferStoreContent bufferStoreContent = null;
        if (Options.getMemoryModel() == 2 && (Options.getExplorationMode() == 2 || Options.getExplorationMode() == 0)) {
            BufferStoreContent bufferStoreContent2 = BufferContent.getBufferStoreContentBis(c);
            bufferStoreContent = new BufferStoreContent(bufferStoreContent2.getId(), bufferStoreContent2.isBool(), bufferStoreContent2.boolValue(), bufferStoreContent2.intValue(), bufferStoreContent2.getName(), null);
        }
        return bufferStoreContent;
    }

    public static String getStoreLable(char c) {
        if (!BufferContent.contains(c)) {
            throw new InternalError(c + " not in language");
        }
        return BufferContent.getBufferStoreContentBis(c).getLabel();
    }

    public static void printBufferContents() {
        for (Elem elem : map) {
            System.out.println(elem.getChar() + " -> " + elem.getBufferStoreContent().toString());
        }
        System.out.println();
    }

    public static HashSet<Character> getVarAlphabet(int n) {
        HashSet<Character> hashSet = new HashSet<Character>();
        for (Elem elem : map) {
            BufferStoreContent bufferStoreContent = elem.getBufferStoreContent();
            if (bufferStoreContent.getId() != n) continue;
            hashSet.add(new Character(elem.getChar()));
        }
        return hashSet;
    }

    public static HashSet<Character> getVarAlphabetWithoutBSC(int n, BufferStoreContent bufferStoreContent) {
        HashSet<Character> hashSet = new HashSet<Character>();
        for (Elem elem : map) {
            BufferStoreContent bufferStoreContent2 = elem.getBufferStoreContent();
            if (bufferStoreContent2.getId() != n || bufferStoreContent2.equals(bufferStoreContent)) continue;
            hashSet.add(Character.valueOf(BufferContent.getCharBis(bufferStoreContent2)));
        }
        return hashSet;
    }

    public static HashSet<Character> getAlphabet() {
        HashSet<Character> hashSet = new HashSet<Character>();
        for (Elem elem : map) {
            Character c = Character.valueOf(elem.getChar());
            hashSet.add(c);
        }
        return hashSet;
    }

    public static HashSet<Character> getSfenceAlphabet() {
        HashSet<Character> hashSet = new HashSet<Character>();
        int n = Options.getNbGlobalVars();
        for (Elem elem : map) {
            BufferStoreContent bufferStoreContent = elem.getBufferStoreContent();
            if (bufferStoreContent.getId() != n) continue;
            hashSet.add(Character.valueOf(BufferContent.getChar(bufferStoreContent)));
        }
        return hashSet;
    }

    public static HashSet<Character> getAlphabetWithoutSfence() {
        HashSet<Character> hashSet = new HashSet<Character>();
        int n = Options.getNbGlobalVars();
        for (Elem elem : map) {
            BufferStoreContent bufferStoreContent = elem.getBufferStoreContent();
            if (bufferStoreContent.getId() == n) continue;
            hashSet.add(Character.valueOf(BufferContent.getChar(bufferStoreContent)));
        }
        return hashSet;
    }

    public static String getBSCCharSet(BufferStoreContent bufferStoreContent) {
        if (!BufferContent.contains(bufferStoreContent)) {
            map.add(new Elem(bufferStoreContent, nextChar));
            nextChar = (char)(nextChar + '\u0001');
        }
        BufferStoreContent bufferStoreContent2 = bufferStoreContent;
        if (Options.getMemoryModel() == 2 && (Options.getExplorationMode() == 2 || Options.getExplorationMode() == 0)) {
            if (bufferStoreContent.getTransition() != null && bufferStoreContent.getId() != Options.getNbGlobalVars()) {
                bufferStoreContent2 = new BufferStoreContent(bufferStoreContent.getId(), bufferStoreContent.isBool(), bufferStoreContent.boolValue(), bufferStoreContent.intValue(), bufferStoreContent.getName(), null);
                if (!store2StoreATransition.containsKey(bufferStoreContent2)) {
                    store2StoreATransition.put(bufferStoreContent2, new HashSet());
                }
                store2StoreATransition.get(bufferStoreContent2).add(bufferStoreContent);
                if (!BufferContent.contains(bufferStoreContent2)) {
                    map.add(new Elem(bufferStoreContent2, nextChar));
                    nextChar = (char)(nextChar + '\u0001');
                }
            } else {
                bufferStoreContent2 = bufferStoreContent;
            }
        }
        String string = new String();
        string = string + BufferContent.getCharBis(bufferStoreContent2);
        if (store2StoreATransition.get(bufferStoreContent2) != null) {
            for (BufferStoreContent bufferStoreContent3 : store2StoreATransition.get(bufferStoreContent2)) {
                string = string + BufferContent.getCharBis(bufferStoreContent3);
            }
        }
        return string;
    }

    private static boolean contains(BufferStoreContent bufferStoreContent) {
        for (int i = 0; i < map.size(); ++i) {
            if (!map.elementAt(i).getBufferStoreContent().equals(bufferStoreContent)) continue;
            return true;
        }
        return false;
    }

    private static boolean contains(char c) {
        for (int i = 0; i < map.size(); ++i) {
            if (map.elementAt(i).getChar() != c) continue;
            return true;
        }
        return false;
    }

    private static BufferStoreContent getBufferStoreContentBis(char c) {
        for (int i = 0; i < map.size(); ++i) {
            if (map.elementAt(i).getChar() != c) continue;
            return map.elementAt(i).getBufferStoreContent();
        }
        return null;
    }

    private static char getCharBis(BufferStoreContent bufferStoreContent) {
        for (int i = 0; i < map.size(); ++i) {
            if (!map.elementAt(i).getBufferStoreContent().equals(bufferStoreContent)) continue;
            return map.elementAt(i).getChar();
        }
        return '@';
    }
}

