/*
 * Decompiled with CFR 0.152.
 */
package compiler;

import compiler.Token;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class TokenStream {
    private boolean isEof = false;
    private char nextChar = (char)32;
    private FileReader input;
    private BufferedReader lineReader;
    private String currentLine;
    private int currentLinePosition;
    private int nbLineFile = 1;
    private int nbLineParse = 1;

    public TokenStream(File file) throws FileNotFoundException {
        this.input = new FileReader(file);
        this.lineReader = new BufferedReader(this.input);
        try {
            this.currentLine = this.lineReader.readLine();
        }
        catch (IOException iOException) {
            System.out.println("IO Exception");
            iOException.printStackTrace();
            System.exit(-2);
        }
        this.currentLinePosition = 0;
    }

    public Token nextToken() {
        block29: {
            block9: while (true) {
                this.nbLineParse = this.nbLineFile;
                this.skipWhiteSpace();
                if (this.nextChar != '/') break block29;
                this.nextChar = this.readChar();
                if (this.nextChar == '/') {
                    this.nextChar = this.readChar();
                    while (true) {
                        if (this.isEndOfLine(this.nextChar)) continue block9;
                        this.nextChar = this.readChar();
                    }
                }
                if (this.nextChar != '*') break;
                this.nextChar = this.readChar();
                while (true) {
                    if (this.nextChar != '*') {
                        this.nextChar = this.readChar();
                        continue;
                    }
                    this.nextChar = this.readChar();
                    if (this.nextChar == '/') break;
                }
                this.nextChar = this.readChar();
            }
            return new Token("Operator", "/");
        }
        if (this.isOperator(this.nextChar)) {
            Token token = new Token("Operator", Character.toString(this.nextChar));
            switch (this.nextChar) {
                case '!': 
                case '<': 
                case '=': 
                case '>': {
                    this.nextChar = this.readChar();
                    if (this.nextChar == '=') {
                        token.addValue(Character.toString(this.nextChar));
                        this.nextChar = this.readChar();
                    }
                    return token;
                }
                case '&': {
                    this.nextChar = this.readChar();
                    if (this.nextChar == '&') {
                        token.addValue(Character.toString(this.nextChar));
                        this.nextChar = this.readChar();
                    }
                    return token;
                }
                case '|': {
                    this.nextChar = this.readChar();
                    if (this.nextChar == '|') {
                        token.addValue(Character.toString(this.nextChar));
                        this.nextChar = this.readChar();
                    }
                    return token;
                }
                case '-': {
                    this.nextChar = this.readChar();
                    if (this.nextChar == '>') {
                        token.addValue(Character.toString(this.nextChar));
                        this.nextChar = this.readChar();
                    }
                    return token;
                }
            }
            this.nextChar = this.readChar();
            return token;
        }
        if (this.isSeparator(this.nextChar)) {
            Token token = new Token("Separator", Character.toString(this.nextChar));
            switch (this.nextChar) {
                case ':': {
                    this.nextChar = this.readChar();
                    if (this.nextChar == ':') {
                        token.addValue(Character.toString(this.nextChar));
                        this.nextChar = this.readChar();
                    }
                    return token;
                }
            }
            this.nextChar = this.readChar();
            return token;
        }
        if (this.isLetter(this.nextChar)) {
            Token token = new Token("Identifier");
            while (this.isLetter(this.nextChar) || this.isDigit(this.nextChar)) {
                token.addValue(Character.toString(this.nextChar));
                this.nextChar = this.readChar();
            }
            if (this.isKeyWord(token.getValue())) {
                token.setType("Keyword");
            } else if (token.getValue().equals("true") || token.getValue().equals("false")) {
                token.setType("Literal");
            }
            return token;
        }
        if (this.isDigit(this.nextChar)) {
            Token token = new Token("Literal");
            while (this.isDigit(this.nextChar)) {
                token.addValue(Character.toString(this.nextChar));
                this.nextChar = this.readChar();
            }
            return token;
        }
        Token token = new Token();
        if (this.isEof) {
            return token;
        }
        token.addValue(Character.toString(this.nextChar));
        this.nextChar = this.readChar();
        return token;
    }

    private char readChar() {
        if (this.isEof) {
            return '\u0000';
        }
        char c = '\u0000';
        try {
            if (this.currentLinePosition < this.currentLine.length()) {
                c = this.currentLine.charAt(this.currentLinePosition++);
            } else {
                this.currentLine = this.lineReader.readLine();
                ++this.nbLineFile;
                while (this.currentLine != null && this.currentLine.length() == 0) {
                    this.currentLine = this.lineReader.readLine();
                    ++this.nbLineFile;
                }
                this.currentLinePosition = 0;
                if (this.currentLine == null) {
                    this.isEof = true;
                    return '\u0000';
                }
                c = this.currentLine.charAt(this.currentLinePosition++);
            }
        }
        catch (IOException iOException) {
            System.out.println("IO Exception");
            System.exit(-2);
        }
        return c;
    }

    private void skipWhiteSpace() {
        while (!this.isEof && this.isWhiteSpace(this.nextChar)) {
            this.nextChar = this.readChar();
        }
    }

    private boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\f';
    }

    private boolean isEndOfLine(char c) {
        return c == '\r' || c == '\n' || c == '\f';
    }

    private boolean isKeyWord(String string) {
        return string.equals("bool") || string.equals("do") || string.equals("od") || string.equals("if") || string.equals("fi") || string.equals("proctype") || string.equals("int") || string.equals("break") || string.equals("skip") || string.equals("load") || string.equals("loadval") || string.equals("store") || string.equals("LOCK") || string.equals("UNLOCK") || string.equals("MFENCE") || string.equals("SFENCE");
    }

    private boolean isLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private boolean isOperator(char c) {
        return c == '=' || c == '+' || c == '-' || c == '*' || c == '/' || c == '<' || c == '>' || c == '!' || c == '&' || c == '|';
    }

    private boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private boolean isSeparator(char c) {
        return c == '[' || c == ']' || c == '(' || c == ')' || c == ':' || c == '?' || c == '{' || c == '}' || c == ';' || c == ',' || c == '.';
    }

    public int getCurrentLineNbFile() {
        return this.nbLineFile;
    }

    public int getCurrentLineNbParse() {
        return this.nbLineParse;
    }

    public int getCurrentLinePosition() {
        return this.currentLinePosition + 1;
    }
}

