/*
 * Decompiled with CFR 0.152.
 */
package compiler.syntaxblocs;

import compiler.syntaxblocs.Output;
import compiler.syntaxblocs.Type;
import compiler.syntaxblocs.Types;
import compiler.syntaxblocs.Value;
import compiler.syntaxblocs.Variable;
import java.util.Vector;

public class Declaration
implements Cloneable {
    private Variable v;
    private Type type;
    private Value[] value;
    private int[] dimensions;
    private int size = 1;

    public Declaration() {
        this.v = null;
        this.type = new Type(Types.UNDEFINED);
        this.value = null;
        this.dimensions = null;
        this.size = -1;
    }

    public Declaration(Type type, Vector<Integer> vector, String string) {
        this.type = type;
        this.dimensions = new int[vector.size()];
        this.size = 1;
        for (int i = 0; i < this.dimensions.length; ++i) {
            this.dimensions[i] = vector.elementAt(i);
            this.size *= this.dimensions[i];
        }
        if (this.size == 0) {
            this.size = 1;
        }
        this.value = new Value[this.size];
        this.v = new Variable(string, this.size, this);
    }

    public void initValues() {
        Value value = this.type.getType() == new Type(Types.BOOLEAN).getType() ? new Value(false) : (this.type.getType() == new Type(Types.INTEGER).getType() ? new Value(0) : new Value());
        for (int i = 0; i < this.size; ++i) {
            this.value[i] = (Value)value.clone();
        }
    }

    public void setValue(Value value, int n) {
        this.value[n] = value;
    }

    public void setValue(Value value, int[] nArray) {
        int n = 0;
        for (int i = 0; i < this.value.length; ++i) {
            n += nArray[i] * this.dimensions[i];
        }
        this.value[n += nArray[this.value.length - 1]] = value;
    }

    public void setValue(Value value, Vector<Integer> vector) {
        int n = 0;
        for (int i = 0; i < this.value.length - 1; ++i) {
            n += vector.elementAt(i) * this.dimensions[i];
        }
        this.value[n += vector.elementAt((int)(this.value.length - 1)).intValue()] = value;
    }

    public Value getValue(int n) {
        return this.value[n];
    }

    public Value getValue(int[] nArray) {
        int n = 0;
        for (int i = 0; i < this.value.length - 1; ++i) {
            n += nArray[i] * this.dimensions[i];
        }
        return this.value[n += nArray[this.value.length - 1]];
    }

    public Value getValue(Vector<Integer> vector) {
        int n = 0;
        for (int i = 0; i < this.value.length; ++i) {
            n += vector.elementAt(i) * this.dimensions[i];
        }
        return this.value[n += vector.elementAt(this.value.length - 1).intValue()];
    }

    public Variable getVariable() {
        return this.v;
    }

    public void display(int n) {
        String string = this.type.display();
        string = string + " ";
        string = string + this.v.display();
        Output.display(string, n);
    }

    public String display() {
        return this.type.display() + " " + this.v.display();
    }

    public String toString() {
        return this.v.toString();
    }

    public Object clone() {
        int n;
        Declaration declaration;
        try {
            declaration = (Declaration)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("At least one of the subclasses ofDeclaration does not implement cloneable");
        }
        declaration.type = (Type)this.type.clone();
        declaration.v = (Variable)this.v.clone();
        declaration.value = new Value[this.value.length];
        declaration.dimensions = new int[this.dimensions.length];
        for (n = 0; n < this.value.length; ++n) {
            declaration.value[n] = (Value)this.value[n].clone();
        }
        for (n = 0; n < this.dimensions.length; ++n) {
            declaration.dimensions[n] = this.dimensions[n];
        }
        return declaration;
    }

    public String getName() {
        return this.v.display();
    }

    public Type getType() {
        return new Type(this.type.getType());
    }

    public int[] getDimensions() {
        return this.dimensions;
    }

    public int getSize() {
        return this.size;
    }

    public int getNbDimensions() {
        return this.dimensions.length;
    }

    public int getIndexFromPosition(int[] nArray) {
        int n = 0;
        for (int i = 0; i < this.value.length - 1; ++i) {
            n += nArray[i] * this.dimensions[i];
        }
        return n += nArray[this.value.length - 1];
    }
}

