/*
 * Decompiled with CFR 0.152.
 */
package compiler.syntaxblocs;

import compiler.syntaxblocs.Expression;
import compiler.syntaxblocs.Identifier;
import compiler.syntaxblocs.Output;
import compiler.syntaxblocs.Variable;

public class Load
extends Expression
implements Cloneable {
    private Expression expression;
    private int id;
    Identifier identifier;

    public Load(int n) {
        this.expression = null;
        this.id = n;
        this.identifier = null;
    }

    public Load(Identifier identifier, Expression expression, int n) {
        this.expression = expression;
        this.id = n;
        this.identifier = identifier;
    }

    public void setValue(Expression expression) {
        this.expression = expression;
    }

    public void setIdentifier(Identifier identifier) {
        this.identifier = identifier;
    }

    @Override
    public void display(int n) {
        Output.display("Load", n);
        Output.newLine();
        Output.display(this.identifier.display() + " == " + this.expression.display(), n + 1);
    }

    @Override
    public String display() {
        return "Load(" + this.identifier.display() + "," + this.expression.display() + ")";
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Load)) {
            return false;
        }
        Load load = (Load)object;
        if (this.id != load.id) {
            return false;
        }
        if (!this.expression.equals(load.expression)) {
            return false;
        }
        return this.identifier.equals(load.identifier);
    }

    @Override
    public int hashCode() {
        return this.id * 100 ^ this.identifier.hashCode();
    }

    @Override
    public String toString() {
        return "Load";
    }

    @Override
    public String getName() {
        return "Load";
    }

    @Override
    public Object clone() {
        Load load = (Load)super.clone();
        load.identifier = (Identifier)this.identifier.clone();
        load.expression = (Expression)this.expression.clone();
        return load;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public Variable getGlobalVariable() {
        return this.identifier.getVariable();
    }

    public Expression[] getGlobalVariableIndex() {
        return this.identifier.getVariableIndex();
    }

    public Expression getExpression() {
        return (Expression)this.expression.clone();
    }
}

