/*
 * Decompiled with CFR 0.152.
 */
package compiler.syntaxblocs;

import compiler.syntaxblocs.Expression;
import compiler.syntaxblocs.Identifier;
import compiler.syntaxblocs.Load;
import compiler.syntaxblocs.Output;
import compiler.syntaxblocs.Variable;

public class LoadVal
extends Expression
implements Cloneable {
    private int id;
    Identifier identifier;

    public LoadVal(int n) {
        this.id = n;
        this.identifier = null;
    }

    public LoadVal(Identifier identifier, int n) {
        this.id = n;
        this.identifier = identifier;
    }

    public void setIdentifier(Identifier identifier) {
        this.identifier = identifier;
    }

    @Override
    public void display(int n) {
        Output.display("LoadVal", n);
        Output.newLine();
        Output.display(this.identifier.display(), n + 1);
    }

    @Override
    public String display() {
        return "LoadVal(" + this.identifier.display() + ")";
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Load)) {
            return false;
        }
        LoadVal loadVal = (LoadVal)object;
        if (this.id != loadVal.id) {
            return false;
        }
        return this.identifier.equals(loadVal.identifier);
    }

    @Override
    public int hashCode() {
        return this.id * 100 ^ this.identifier.hashCode();
    }

    @Override
    public String toString() {
        return "LoadVal";
    }

    @Override
    public String getName() {
        return "LoadVal";
    }

    @Override
    public Object clone() {
        LoadVal loadVal = (LoadVal)super.clone();
        loadVal.identifier = (Identifier)this.identifier.clone();
        return loadVal;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public Variable getGlobalVariable() {
        return this.identifier.getVariable();
    }

    public Expression[] getGlobalVariableIndex() {
        return this.identifier.getVariableIndex();
    }
}

