/*
 * Decompiled with CFR 0.152.
 */
package compiler.syntaxblocs;

import compiler.syntaxblocs.Output;

public class Operator
implements Cloneable {
    private final String AND = "&&";
    private final String OR = "||";
    private final String LT = "<";
    private final String LE = "<=";
    private final String EQ = "==";
    private final String NE = "!=";
    private final String GE = ">=";
    private final String GT = ">";
    private final String PLUS = "+";
    private final String MINUS = "-";
    private final String TIMES = "*";
    private final String DIV = "/";
    private final String NOT = "!";
    private String val;

    public Operator(String string) {
        this.val = string;
    }

    public void display(int n) {
        Output.display("Operator: " + this.val, n);
    }

    public String display() {
        return this.val;
    }

    public String getOperatorString() {
        return this.val;
    }

    public String toString() {
        return "Operator";
    }

    public boolean boolOp() {
        return this.val.equals("&&") || this.val.equals("||");
    }

    public boolean equals(Object object) {
        if (!(object instanceof Operator)) {
            return false;
        }
        Operator operator = (Operator)object;
        return this.val.equals(operator.val);
    }

    public boolean relationOp() {
        return this.val.equals("<") || this.val.equals("<=") || this.val.equals("==") || this.val.equals("!=") || this.val.equals(">=") || this.val.equals(">");
    }

    public boolean arithmeticOp() {
        return this.val.equals("+") || this.val.equals("-") || this.val.equals("*") || this.val.equals("/");
    }

    public boolean unaryOp() {
        return this.val.equals("!");
    }

    public Object clone() {
        Operator operator;
        try {
            operator = (Operator)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("At least one of the subclasses ofOperator does not implement cloneable");
        }
        operator.val = new String(this.val);
        return operator;
    }
}

