/*
 * Decompiled with CFR 0.152.
 */
package compiler.syntaxblocs;

import compiler.syntaxblocs.Declaration;
import compiler.syntaxblocs.Declarations;
import compiler.syntaxblocs.Output;
import compiler.syntaxblocs.Proctype;
import compiler.syntaxblocs.Proctypes;
import java.util.Iterator;

public class Program
implements Cloneable {
    private Declarations ds = null;
    private Proctypes proctypes = null;
    private Proctype init = null;

    public void setGlobalDeclarations(Declarations declarations) {
        this.ds = declarations;
    }

    public void setProctypes(Proctypes proctypes) {
        this.proctypes = proctypes;
    }

    public void setInit(Proctype proctype) {
        this.init = proctype;
    }

    public void display() {
        int n = 0;
        Output.display("Program: abstract syntax", n);
        Output.newLine();
        this.ds.display(n + 1);
        Output.newLine();
        if (this.init != null) {
            this.init.display(n + 1);
            Output.newLine();
        }
        this.proctypes.display(n + 1);
    }

    public Declarations getGlobalDeclarations() {
        return (Declarations)this.ds.clone();
    }

    public Proctypes getProctypes() {
        return (Proctypes)this.proctypes.clone();
    }

    public Proctype getInit() {
        return (Proctype)this.init.clone();
    }

    public Iterator<Declaration> getGlobalDeclarationIter() {
        return this.ds.iterator();
    }

    public Iterator<Proctype> getProctypesIter() {
        return this.proctypes.iterator();
    }

    public Object clone() {
        Program program;
        try {
            program = (Program)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("At least one of the subclasses ofProgram does not implement cloneable");
        }
        program.ds = (Declarations)this.ds.clone();
        program.proctypes = (Proctypes)this.proctypes.clone();
        program.init = (Proctype)this.init.clone();
        return program;
    }
}

