/*
 * Decompiled with CFR 0.152.
 */
package compiler.syntaxblocs;

import compiler.syntaxblocs.Expression;
import compiler.syntaxblocs.Output;
import compiler.syntaxblocs.Statements;

public class Sequence
implements Cloneable {
    private Expression expr = null;
    private Statements s = null;

    public void setExpression(Expression expression) {
        this.expr = expression;
    }

    public void setStatements(Statements statements) {
        this.s = statements;
    }

    public String toString() {
        return ":: " + this.expr.display() + " -> " + this.s.display();
    }

    public void display(int n) {
        Output.display("Sequence:", n);
        Output.newLine();
        Output.display("Guard: " + this.expr.display(), n + 1);
        Output.newLine();
        this.s.display(n + 1);
    }

    public Object clone() {
        Sequence sequence;
        try {
            sequence = (Sequence)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("At least one of the subclasses ofSequence does not implement cloneable");
        }
        sequence.expr = (Expression)this.expr.clone();
        sequence.s = (Statements)this.s.clone();
        return sequence;
    }

    public Expression getExpression() {
        return (Expression)this.expr.clone();
    }

    public Statements getStatements() {
        return (Statements)this.s.clone();
    }
}

