/*
 * Decompiled with CFR 0.152.
 */
package compiler.syntaxblocs;

import compiler.syntaxblocs.Expression;
import compiler.syntaxblocs.Identifier;
import compiler.syntaxblocs.Output;
import compiler.syntaxblocs.Statement;
import compiler.syntaxblocs.Variable;

public class Store
extends Statement
implements Cloneable {
    private Expression e = null;
    private int id;
    private Identifier identifier = null;

    public Store(int n) {
        super("Store");
        this.id = n;
    }

    public Store(Identifier identifier, Expression expression, int n) {
        this(n);
        this.identifier = identifier;
        this.e = expression;
    }

    public void setExpression(Expression expression) {
        this.e = expression;
    }

    public void setIdentifier(Identifier identifier) {
        this.identifier = identifier;
    }

    @Override
    public void display(int n) {
        Output.display("Store:", n);
        Output.newLine();
        Output.display(this.display(), n + 1);
    }

    @Override
    public String display() {
        String string = new String();
        string = string + "Store(" + this.identifier.display() + "," + this.e.display() + ")";
        return string;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Store)) {
            return false;
        }
        Store store = (Store)object;
        if (this.id != store.id) {
            return false;
        }
        if (!this.e.equals(store.e)) {
            return false;
        }
        return this.identifier.equals(store.identifier);
    }

    @Override
    public int hashCode() {
        return this.id * 100 ^ this.identifier.hashCode();
    }

    public String toString() {
        return "Store";
    }

    @Override
    public String getName() {
        return "Store";
    }

    @Override
    public Object clone() {
        Store store = (Store)super.clone();
        store.e = (Expression)this.e.clone();
        store.identifier = (Identifier)this.identifier.clone();
        return store;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public Variable getGlobalVariable() {
        return this.identifier.getVariable();
    }

    public Expression[] getGlobalVariableIndex() {
        return this.identifier.getVariableIndex();
    }

    public Expression getExpression() {
        return (Expression)this.e.clone();
    }
}

