/*
 * Decompiled with CFR 0.152.
 */
package compiler.syntaxblocs;

import compiler.syntaxblocs.Expression;
import compiler.syntaxblocs.ExpressionProtected;
import compiler.syntaxblocs.Operator;
import compiler.syntaxblocs.Output;

public class Unary
extends ExpressionProtected
implements Cloneable {
    private Operator op = null;
    private Expression term = null;
    private int id;

    public Unary(int n) {
        this.id = n;
    }

    public void setOperator(Operator operator) {
        this.op = operator;
    }

    public void setTerm(Expression expression) {
        this.term = expression;
    }

    @Override
    public void display(int n) {
        Output.display("Unary:", n);
        this.op.display(n + 1);
        this.term.display(n + 1);
    }

    @Override
    public String display() {
        String string = new String(this.op.display());
        string = string + " " + this.term.display();
        return string;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Unary)) {
            return false;
        }
        Unary unary = (Unary)object;
        if (this.id != unary.id) {
            return false;
        }
        if (!this.op.equals(unary.op)) {
            return false;
        }
        return this.term.equals(unary.term);
    }

    @Override
    public int hashCode() {
        return this.id;
    }

    @Override
    public String toString() {
        return "Unary";
    }

    @Override
    public String getName() {
        return "Unary";
    }

    @Override
    public Object clone() {
        Unary unary = (Unary)super.clone();
        unary.op = (Operator)this.op.clone();
        unary.term = (Expression)this.term.clone();
        return unary;
    }

    public Operator getOperator() {
        return (Operator)this.op.clone();
    }

    public Expression getExpression() {
        return (Expression)this.term.clone();
    }
}

