/*
 * Decompiled with CFR 0.152.
 */
package controlgraph;

import buffer.Buffer;
import controlgraph.ControlGraph;
import controlgraph.Expression;
import controlgraph.Variable;
import java.util.Vector;

public class Identifier
extends Expression
implements Cloneable {
    private String name;
    private final boolean isBool;
    private int[] dimensions;
    private int size;
    private Variable[] variables;
    private Expression[] indexExpressions;
    private int index;

    public Identifier(String string, boolean bl, int[] nArray, int n, Variable[] variableArray, Expression[] expressionArray, ControlGraph controlGraph) {
        super(string, controlGraph);
        this.name = string;
        this.isBool = bl;
        this.dimensions = nArray;
        this.size = n;
        this.variables = variableArray;
        this.index = -1;
        this.indexExpressions = expressionArray;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public boolean isBool() {
        return this.isBool;
    }

    @Override
    public boolean equals(Object object) {
        int n;
        if (!(object instanceof Identifier)) {
            return false;
        }
        Identifier identifier = (Identifier)object;
        if (!this.name.equals(identifier.name)) {
            return false;
        }
        if (this.isBool != identifier.isBool) {
            return false;
        }
        if (this.size != identifier.size) {
            return false;
        }
        for (n = 0; n < this.dimensions.length; ++n) {
            if (this.dimensions[n] == identifier.dimensions[n]) continue;
            return false;
        }
        for (n = 0; n < this.variables.length; ++n) {
            if (this.variables[n].equals(identifier.variables[n])) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object clone() {
        int n;
        Identifier identifier = (Identifier)super.clone();
        identifier.name = new String(this.name);
        identifier.dimensions = new int[this.dimensions.length];
        for (n = 0; n < this.dimensions.length; ++n) {
            identifier.dimensions[n] = this.dimensions[n];
        }
        identifier.variables = new Variable[this.variables.length];
        for (n = 0; n < this.variables.length; ++n) {
            identifier.variables[n] = (Variable)this.variables[n].clone();
        }
        return identifier;
    }

    public Variable getVariable(int n) {
        this.index = n;
        if (n >= 0 && n < this.variables.length) {
            return this.variables[n];
        }
        throw new InternalError("Index out of bounds for " + this.name);
    }

    public Variable getVariable(int[] nArray) {
        if (nArray.length != this.dimensions.length) {
            throw new InternalError("index accessors not correct");
        }
        if (this.dimensions.length == 0) {
            if (nArray.length == 0) {
                return this.variables[0];
            }
            throw new InternalError("Index accessors not correct");
        }
        int n = 0;
        for (int i = 0; i < this.dimensions.length; ++i) {
            n += nArray[i] * this.dimensions[i];
        }
        if (n < this.variables.length) {
            this.index = n;
            return this.variables[this.index];
        }
        throw new InternalError("Index out of bounds " + this.name);
    }

    @Override
    public String evaluatedString() {
        if (this.index == -1) {
            throw new InternalError("identifier must be evaluated before");
        }
        return this.variables[this.index].getName();
    }

    @Override
    public boolean evaluateBool(Buffer buffer) {
        return this.cG.getVariable(this).getBoolValue();
    }

    @Override
    public int evaluateInt(Buffer buffer) {
        return this.cG.getVariable(this).getIntValue();
    }

    @Override
    public void apply(Buffer buffer) {
        throw new InternalError("Identifier cannot be applied");
    }

    @Override
    public int containsLoad() {
        return -1;
    }

    @Override
    public boolean containsLoadAt(int n) {
        return false;
    }

    @Override
    public boolean isTrue(Buffer buffer) {
        return this.cG.getVariable(this).getBoolValue();
    }

    @Override
    public int type() {
        if (this.cG.getVariable(this).isBool()) {
            return 20;
        }
        throw new InternalError("integer Identifier cannot send type back");
    }

    public int[] getDimensions() {
        return this.dimensions;
    }

    public Expression[] getIndexExpressions() {
        return this.indexExpressions;
    }

    public Variable[] getVariables() {
        return this.variables;
    }

    @Override
    public boolean isTrue(Vector<Buffer> vector) {
        return this.cG.getVariable(this).getBoolValue();
    }

    @Override
    public int evaluateInt(Vector<Buffer> vector) {
        return this.cG.getVariable(this).getIntValue();
    }

    @Override
    public boolean evaluateBool(Vector<Buffer> vector) {
        return this.cG.getVariable(this).getBoolValue();
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public boolean bufferModified() {
        return false;
    }
}

