/*
 * Decompiled with CFR 0.152.
 */
package controlgraph.actions;

import buffer.Buffer;
import controlgraph.ControlGraph;
import controlgraph.Expression;
import java.util.Vector;

public class And
extends Expression {
    private Expression term1;
    private Expression term2;

    public And(Expression expression, Expression expression2, ControlGraph controlGraph) {
        super(new String("(" + expression.toString() + "&&" + expression2.toString() + ")"), controlGraph);
        this.term1 = expression;
        this.term2 = expression2;
    }

    @Override
    public int evaluateInt(Buffer buffer) {
        throw new InternalError("And is not integer");
    }

    @Override
    public boolean isTrue(Buffer buffer) {
        return this.term1.evaluateBool(buffer) && this.term2.evaluateBool(buffer);
    }

    @Override
    public boolean evaluateBool(Buffer buffer) {
        return this.isTrue(buffer);
    }

    @Override
    public int containsLoad() {
        if (this.term1.containsLoad() != -1) {
            return this.term1.containsLoad();
        }
        return this.term2.containsLoad();
    }

    @Override
    public boolean containsLoadAt(int n) {
        return this.term1.containsLoadAt(n) || this.term2.containsLoadAt(n);
    }

    @Override
    public Object clone() {
        And and = (And)super.clone();
        and.term1 = (Expression)this.term1.clone();
        and.term2 = (Expression)this.term2.clone();
        return and;
    }

    @Override
    public String evaluatedString() {
        return new String("(" + this.term1.evaluatedString() + "&&" + this.term2.evaluatedString() + ")");
    }

    @Override
    public int type() {
        return 21;
    }

    @Override
    public void apply(Buffer buffer) {
        throw new InternalError("And cannot be applied");
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof And)) {
            return false;
        }
        And and = (And)object;
        if (!this.term1.equals(and.term1)) {
            return false;
        }
        return this.term2.equals(and.term2);
    }

    @Override
    public boolean isTrue(Vector<Buffer> vector) {
        return this.term1.evaluateBool(vector) && this.term2.evaluateBool(vector);
    }

    @Override
    public int evaluateInt(Vector<Buffer> vector) {
        throw new InternalError("No integer evaluation for AND");
    }

    @Override
    public boolean evaluateBool(Vector<Buffer> vector) {
        return this.isTrue(vector);
    }

    @Override
    public int hashCode() {
        return this.term1.hashCode() ^ this.term2.hashCode();
    }

    @Override
    public boolean bufferModified() {
        return this.term1.bufferModified() || this.term2.bufferModified();
    }
}

