/*
 * Decompiled with CFR 0.152.
 */
package controlgraph.actions;

import buffer.Buffer;
import buffer.BufferContent;
import buffer.BufferStoreContent;
import controlgraph.Action;
import controlgraph.ControlGraph;
import java.util.Vector;
import modelchecker.Process;

public class Commit
extends Action {
    private Process p;
    private BufferStoreContent bSC;
    private int nbPossibleCommits;

    public Commit(Process process, BufferStoreContent bufferStoreContent, ControlGraph controlGraph) {
        super("Commit: " + bufferStoreContent.getLabel(), controlGraph);
        this.p = process;
        this.bSC = bufferStoreContent;
        this.nbPossibleCommits = 0;
    }

    public void setNbPossibleCommits(int n) {
        this.nbPossibleCommits = n;
    }

    public int getNbPossibleCommits() {
        return this.nbPossibleCommits;
    }

    @Override
    public void apply(Buffer buffer) {
        if (buffer.commitStore(BufferContent.getChar(this.bSC)) == null) {
            buffer.makeEmpty();
        }
    }

    public BufferStoreContent getBufferStoreContent() {
        return this.bSC;
    }

    @Override
    public int containsLoad() {
        return -1;
    }

    @Override
    public boolean containsLoadAt(int n) {
        return false;
    }

    @Override
    public Object clone() {
        Commit commit = (Commit)super.clone();
        commit.p = (Process)this.p.clone();
        commit.bSC = (BufferStoreContent)this.bSC.clone();
        return commit;
    }

    @Override
    public String evaluatedString() {
        return this.toString();
    }

    @Override
    public boolean isTrue(Buffer buffer) {
        return true;
    }

    @Override
    public int type() {
        return 7;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Commit)) {
            return false;
        }
        Commit commit = (Commit)object;
        if (this.p.getProcessNb() != commit.p.getProcessNb()) {
            return false;
        }
        return this.bSC.equals(commit.bSC);
    }

    @Override
    public boolean isTrue(Vector<Buffer> vector) {
        return true;
    }

    @Override
    public int hashCode() {
        int n = this.p.getProcessNb();
        n = n * 1103515245 + 12345 + this.bSC.getId();
        n = n * 1103515245 + 12345 + (this.bSC.isBool() ? (this.bSC.boolValue() ? 1 : 0) : this.bSC.intValue());
        return n;
    }

    @Override
    public boolean bufferModified() {
        throw new InternalError("Should never ask about buffer modified by commit");
    }
}

