/*
 * Decompiled with CFR 0.152.
 */
package controlgraph.actions;

import buffer.Buffer;
import controlgraph.ControlGraph;
import controlgraph.Expression;
import controlgraph.Identifier;
import controlgraph.Transition;
import controlgraph.Variable;
import java.util.Vector;

public class LDV
extends Expression {
    private Identifier identifier;
    private Variable lV;
    private Transition t;
    private boolean bufferModified = false;

    public LDV(Identifier identifier, ControlGraph controlGraph) {
        super(new String("LoadVal(" + identifier.toString() + "," + ")"), controlGraph);
        this.identifier = identifier;
    }

    public void setBufferModified(boolean bl) {
        this.bufferModified = bl;
    }

    @Override
    public boolean bufferModified() {
        return this.bufferModified;
    }

    public Variable getGlobalVariable() {
        if (this.lV != null) {
            return this.lV;
        }
        throw new InternalError("Variable must be initialized before");
    }

    public void setTransition(Transition transition) {
        this.t = transition;
    }

    public Transition getTransition() {
        return this.t;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setLV(Variable variable) {
        this.lV = variable;
    }

    public void setLV(int n) {
        this.lV = this.identifier.getVariable(n);
    }

    public void setLV(int[] nArray) {
        this.lV = this.identifier.getVariable(nArray);
    }

    @Override
    public boolean isTrue(Buffer buffer) {
        return true;
    }

    @Override
    public int containsLoad() {
        return this.lV == null ? 1000 : this.lV.getId();
    }

    @Override
    public boolean containsLoadAt(int n) {
        if (this.lV == null) {
            throw new InternalError("must initialize variable before");
        }
        return this.lV.getId() == n;
    }

    @Override
    public Object clone() {
        LDV lDV = (LDV)super.clone();
        lDV.identifier = (Identifier)this.identifier.clone();
        if (this.lV != null) {
            lDV.lV = (Variable)this.lV.clone();
        }
        return lDV;
    }

    @Override
    public String evaluatedString() {
        return new String("LoadVal(" + this.lV.toString() + ")");
    }

    @Override
    public int type() {
        return 20;
    }

    @Override
    public void apply(Buffer buffer) {
        throw new InternalError("LoadVal cannot be applied");
    }

    public int getVarId() {
        this.lV = this.cG.getVariable(this.identifier);
        return this.lV.getId();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof LDV)) {
            return false;
        }
        LDV lDV = (LDV)object;
        return this.identifier.equals(lDV.identifier);
    }

    @Override
    public boolean isTrue(Vector<Buffer> vector) {
        return true;
    }

    @Override
    public int evaluateInt(Buffer buffer) {
        throw new InternalError("should never be called");
    }

    @Override
    public boolean evaluateBool(Buffer buffer) {
        throw new InternalError("should never be called");
    }

    @Override
    public int evaluateInt(Vector<Buffer> vector) {
        throw new InternalError("should never be called");
    }

    @Override
    public boolean evaluateBool(Vector<Buffer> vector) {
        throw new InternalError("should never be called");
    }

    @Override
    public int hashCode() {
        int n = this.lV != null ? this.lV.getId() : this.identifier.getName().hashCode();
        n = n * 1103515245 + 12345 + (this.lV != null ? this.lV.getId() : this.identifier.getName().hashCode());
        return n;
    }
}

