/*
 * Decompiled with CFR 0.152.
 */
package controlgraph.actions;

import buffer.Buffer;
import controlgraph.ControlGraph;
import controlgraph.Expression;
import java.util.Vector;

public class Mul
extends Expression {
    Expression term1;
    Expression term2;

    public Mul(Expression expression, Expression expression2, ControlGraph controlGraph) {
        super(new String("(" + expression.toString() + "*" + expression2.toString()) + ")", controlGraph);
        this.term1 = expression;
        this.term2 = expression2;
    }

    @Override
    public boolean evaluateBool(Buffer buffer) {
        throw new InternalError("Mul is not a boolean expression");
    }

    @Override
    public boolean isTrue(Buffer buffer) {
        return true;
    }

    @Override
    public int evaluateInt(Buffer buffer) {
        return this.term1.evaluateInt(buffer) * this.term2.evaluateInt(buffer);
    }

    @Override
    public int containsLoad() {
        return -1;
    }

    @Override
    public boolean containsLoadAt(int n) {
        return false;
    }

    @Override
    public Object clone() {
        Mul mul = (Mul)super.clone();
        mul.term1 = (Expression)this.term1.clone();
        mul.term2 = (Expression)this.term2.clone();
        return mul;
    }

    @Override
    public String evaluatedString() {
        return new String("(" + this.term1.evaluatedString() + "*" + this.term2.evaluatedString() + ")");
    }

    @Override
    public int type() {
        return 20;
    }

    @Override
    public void apply(Buffer buffer) {
        throw new InternalError("Mul cannot be applied");
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Mul)) {
            return false;
        }
        Mul mul = (Mul)object;
        if (!this.term1.equals(mul.term1)) {
            return false;
        }
        return this.term2.equals(mul.term2);
    }

    @Override
    public boolean isTrue(Vector<Buffer> vector) {
        return this.isTrue((Buffer)null);
    }

    @Override
    public int evaluateInt(Vector<Buffer> vector) {
        return this.evaluateInt((Buffer)null);
    }

    @Override
    public boolean evaluateBool(Vector<Buffer> vector) {
        return this.evaluateBool((Buffer)null);
    }

    @Override
    public int hashCode() {
        return this.term1.hashCode() ^ this.term2.hashCode();
    }

    @Override
    public boolean bufferModified() {
        return false;
    }
}

